/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.block;

import com.lunazstudios.cobblefurnies.block.SeatBlock;
import com.lunazstudios.cobblefurnies.entity.SeatEntity;
import com.lunazstudios.cobblefurnies.registry.CFRegistry;
import com.lunazstudios.cobblefurnies.util.block.ShapeUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ToiletBlock
extends SeatBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    protected static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)Block.box((double)2.0, (double)9.0, (double)10.0, (double)14.0, (double)18.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)11.0, (double)6.0, (double)0.0, (double)13.0, (double)9.0, (double)11.0), Block.box((double)3.0, (double)6.0, (double)0.0, (double)5.0, (double)9.0, (double)11.0), Block.box((double)5.0, (double)6.0, (double)0.0, (double)11.0, (double)9.0, (double)2.0), Block.box((double)5.0, (double)6.0, (double)8.0, (double)11.0, (double)9.0, (double)10.0), Block.box((double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)6.0, (double)10.0), Block.box((double)5.0, (double)0.0, (double)10.0, (double)11.0, (double)9.0, (double)15.0), Block.box((double)5.0, (double)6.5, (double)2.0, (double)11.0, (double)6.5, (double)8.0), Block.box((double)3.0, (double)9.0, (double)0.0, (double)13.0, (double)10.0, (double)10.0), Block.box((double)14.0, (double)16.0, (double)11.0, (double)15.0, (double)17.0, (double)14.0)});
    protected static final VoxelShape SHAPE_EAST = ShapeUtil.rotateShape(SHAPE_NORTH, Direction.EAST);
    protected static final VoxelShape SHAPE_SOUTH = ShapeUtil.rotateShape(SHAPE_NORTH, Direction.SOUTH);
    protected static final VoxelShape SHAPE_WEST = ShapeUtil.rotateShape(SHAPE_NORTH, Direction.WEST);
    protected static final VoxelShape SHAPE_OPEN_NORTH = Shapes.or((VoxelShape)Block.box((double)2.0, (double)9.0, (double)10.0, (double)14.0, (double)18.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)11.0, (double)6.0, (double)0.0, (double)13.0, (double)9.0, (double)11.0), Block.box((double)3.0, (double)6.0, (double)0.0, (double)5.0, (double)9.0, (double)11.0), Block.box((double)5.0, (double)6.0, (double)0.0, (double)11.0, (double)9.0, (double)2.0), Block.box((double)5.0, (double)6.0, (double)8.0, (double)11.0, (double)9.0, (double)10.0), Block.box((double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)6.0, (double)10.0), Block.box((double)5.0, (double)0.0, (double)10.0, (double)11.0, (double)9.0, (double)15.0), Block.box((double)5.0, (double)6.5, (double)2.0, (double)11.0, (double)6.5, (double)8.0), Block.box((double)3.0, (double)9.0, (double)0.0, (double)13.0, (double)10.0, (double)10.0), Block.box((double)14.0, (double)16.0, (double)11.0, (double)15.0, (double)17.0, (double)14.0)});
    protected static final VoxelShape SHAPE_OPEN_EAST = ShapeUtil.rotateShape(SHAPE_OPEN_NORTH, Direction.EAST);
    protected static final VoxelShape SHAPE_OPEN_SOUTH = ShapeUtil.rotateShape(SHAPE_OPEN_NORTH, Direction.SOUTH);
    protected static final VoxelShape SHAPE_OPEN_WEST = ShapeUtil.rotateShape(SHAPE_OPEN_NORTH, Direction.WEST);
    protected static final VoxelShape[] CLOSED_SHAPES = new VoxelShape[]{SHAPE_SOUTH, SHAPE_WEST, SHAPE_NORTH, SHAPE_EAST};
    protected static final VoxelShape[] OPEN_SHAPES = new VoxelShape[]{SHAPE_OPEN_SOUTH, SHAPE_OPEN_WEST, SHAPE_OPEN_NORTH, SHAPE_OPEN_EAST};

    public ToiletBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public float seatHeight(BlockState state) {
        return 0.45f;
    }

    @Override
    public BlockPos primaryDismountLocation(Level level, BlockState state, BlockPos pos) {
        return pos.relative((Direction)state.getValue((Property)FACING));
    }

    @Override
    public float setRiderRotation(BlockState state, Entity entity) {
        return ((Direction)state.getValue((Property)FACING)).toYRot();
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int index = ((Direction)state.getValue((Property)FACING)).get2DDataValue();
        return (Boolean)state.getValue((Property)OPEN) != false ? OPEN_SHAPES[index] : CLOSED_SHAPES[index];
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (CFRegistry.isFakePlayer(player)) {
            return InteractionResult.PASS;
        }
        if (!level.mayInteract(player, pos)) {
            return InteractionResult.PASS;
        }
        boolean open = (Boolean)state.getValue((Property)OPEN);
        if (!open) {
            if (!player.isCrouching()) {
                return InteractionResult.PASS;
            }
            level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true)), 3);
            return InteractionResult.SUCCESS;
        }
        if (player.isCrouching()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)), 3);
            return InteractionResult.SUCCESS;
        }
        if (!this.isSittable(state) || player.isPassenger()) {
            return InteractionResult.PASS;
        }
        if (ToiletBlock.isSeatBlocked(level, pos)) {
            return InteractionResult.PASS;
        }
        if (ToiletBlock.isSeatOccupied(level, pos)) {
            List seats = level.getEntitiesOfClass(SeatEntity.class, new AABB(pos));
            if (!seats.isEmpty() && ToiletBlock.ejectSeatedExceptPlayer(level, (SeatEntity)((Object)seats.get(0)))) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ToiletBlock.sitDown(level, pos, ToiletBlock.getLeashed(player).orElse((Entity)player));
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean waterlogged = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, OPEN});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

