/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.block;

import com.lunazstudios.cobblefurnies.block.entity.NightStandBlockEntity;
import com.lunazstudios.cobblefurnies.block.properties.CFBlockStateProperties;
import com.lunazstudios.cobblefurnies.util.block.ShapeUtil;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class NightStandBlock
extends BaseEntityBlock {
    public static final MapCodec<NightStandBlock> CODEC = NightStandBlock.simpleCodec(NightStandBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final BooleanProperty HAS_CONCRETE = CFBlockStateProperties.HAS_CONCRETE;
    public static final EnumProperty<DyeColor> CONCRETE_COLOR = CFBlockStateProperties.CONCRETE_COLOR;
    protected static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)2.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)2.0, (double)2.0), Block.box((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)2.0, (double)16.0), Block.box((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0, (double)16.0)});
    protected static final VoxelShape SHAPE_EAST = ShapeUtil.rotateShape(SHAPE_NORTH, Direction.EAST);
    protected static final VoxelShape SHAPE_SOUTH = ShapeUtil.rotateShape(SHAPE_NORTH, Direction.SOUTH);
    protected static final VoxelShape SHAPE_WEST = ShapeUtil.rotateShape(SHAPE_NORTH, Direction.WEST);

    public MapCodec<NightStandBlock> codec() {
        return CODEC;
    }

    public NightStandBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_CONCRETE, (Comparable)Boolean.valueOf(false))).setValue(CONCRETE_COLOR, (Comparable)DyeColor.LIGHT_BLUE)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        Block block;
        DyeColor color;
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof NightStandBlockEntity)) {
            return InteractionResult.PASS;
        }
        NightStandBlockEntity nightStandBE = (NightStandBlockEntity)blockEntity;
        ItemStack itemStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (player.isShiftKeyDown() && itemStack.isEmpty() && ((Boolean)state.getValue((Property)CFBlockStateProperties.HAS_CONCRETE)).booleanValue()) {
            DyeColor currentColor = (DyeColor)state.getValue(CFBlockStateProperties.CONCRETE_COLOR);
            ResourceLocation concreteId = new ResourceLocation("minecraft", currentColor.getName() + "_concrete");
            Block concreteBlock = (Block)BuiltInRegistries.BLOCK.get(concreteId);
            ItemStack concreteStack = new ItemStack((ItemLike)concreteBlock.asItem());
            if (!player.getInventory().add(concreteStack)) {
                player.drop(concreteStack, false);
            }
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)CFBlockStateProperties.HAS_CONCRETE, (Comparable)Boolean.valueOf(false))).setValue(CFBlockStateProperties.CONCRETE_COLOR, (Comparable)DyeColor.WHITE), 3);
            level.playSound(null, pos, SoundEvents.WOOL_BREAK, SoundSource.BLOCKS, 0.8f, 0.9f);
            return InteractionResult.SUCCESS;
        }
        if (!((Boolean)state.getValue((Property)CFBlockStateProperties.HAS_CONCRETE)).booleanValue() && (color = this.getConcreteColor(block = Block.byItem((Item)itemStack.getItem()))) != null) {
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)CFBlockStateProperties.HAS_CONCRETE, (Comparable)Boolean.valueOf(true))).setValue(CFBlockStateProperties.CONCRETE_COLOR, (Comparable)color), 3);
            if (!player.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
            level.playSound(null, pos, SoundEvents.WOOL_PLACE, SoundSource.BLOCKS, 0.8f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (blockEntity instanceof NightStandBlockEntity) {
            NightStandBlockEntity nighstandBE = (NightStandBlockEntity)blockEntity;
            player.openMenu((MenuProvider)nighstandBE);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    private DyeColor getConcreteColor(Block block) {
        for (DyeColor color : DyeColor.values()) {
            ResourceLocation id = new ResourceLocation("minecraft", color.getName() + "_concrete");
            Block expected = (Block)BuiltInRegistries.BLOCK.get(id);
            if (block != expected) continue;
            return color;
        }
        return null;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (state.is(newState.getBlock())) {
            return;
        }
        if (((Boolean)state.getValue((Property)HAS_CONCRETE)).booleanValue()) {
            DyeColor color = (DyeColor)state.getValue(CONCRETE_COLOR);
            ResourceLocation concreteId = new ResourceLocation("minecraft", color.getName() + "_concrete");
            Block concreteBlock = (Block)BuiltInRegistries.BLOCK.get(concreteId);
            ItemStack concreteStack = new ItemStack((ItemLike)concreteBlock.asItem());
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)concreteStack);
        }
        if ((blockEntity = level.getBlockEntity(pos)) instanceof Container) {
            Containers.dropContents((Level)level, (BlockPos)pos, (Container)((Container)blockEntity));
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof NightStandBlockEntity) {
            NightStandBlockEntity nighstandBE = (NightStandBlockEntity)blockEntity;
            nighstandBE.recheckOpen();
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new NightStandBlockEntity(pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        switch (facing) {
            case EAST: {
                return SHAPE_EAST;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_NORTH;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean waterlogged = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        Direction facing = context.getHorizontalDirection().getOpposite();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).setValue((Property)HAS_CONCRETE, (Comparable)Boolean.valueOf(false))).setValue(CONCRETE_COLOR, (Comparable)DyeColor.LIGHT_BLUE)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, OPEN, HAS_CONCRETE, CONCRETE_COLOR});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return this.rotate(state, mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

