/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.block;

import com.lunazstudios.cobblefurnies.block.FurnitureHorizontalBlock;
import com.lunazstudios.cobblefurnies.block.properties.CFBlockStateProperties;
import com.lunazstudios.cobblefurnies.block.properties.MountType;
import com.lunazstudios.cobblefurnies.util.block.ShapeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LampBlock
extends FurnitureHorizontalBlock {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final EnumProperty<MountType> MOUNT_TYPE = CFBlockStateProperties.MOUNT_TYPE;
    protected static final VoxelShape SHAPE_FLOOR = Shapes.or((VoxelShape)Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), (VoxelShape)Block.box((double)3.0, (double)6.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
    protected static final VoxelShape SHAPE_WALL_NORTH = Shapes.or((VoxelShape)Block.box((double)5.0, (double)2.0, (double)15.0, (double)11.0, (double)8.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)7.0, (double)4.0, (double)8.0, (double)9.0, (double)6.0, (double)15.0), Block.box((double)3.0, (double)6.0, (double)4.0, (double)13.0, (double)16.0, (double)14.0)});
    protected static final VoxelShape SHAPE_WALL_EAST = ShapeUtil.rotateShape(SHAPE_WALL_NORTH, Direction.EAST);
    protected static final VoxelShape SHAPE_WALL_SOUTH = ShapeUtil.rotateShape(SHAPE_WALL_NORTH, Direction.SOUTH);
    protected static final VoxelShape SHAPE_WALL_WEST = ShapeUtil.rotateShape(SHAPE_WALL_NORTH, Direction.WEST);
    protected static final VoxelShape[] WALL_SHAPES = new VoxelShape[]{SHAPE_WALL_SOUTH, SHAPE_WALL_WEST, SHAPE_WALL_NORTH, SHAPE_WALL_EAST};

    public LampBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(MOUNT_TYPE, (Comparable)((Object)MountType.FLOOR))).setValue((Property)LIT, (Comparable)Boolean.FALSE)).setValue((Property)POWERED, (Comparable)Boolean.FALSE));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction face = context.getClickedFace();
        Direction horizontal = context.getHorizontalDirection().getOpposite();
        if (face == Direction.UP || face == Direction.DOWN) {
            return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(MOUNT_TYPE, (Comparable)((Object)MountType.FLOOR))).setValue((Property)FACING, (Comparable)horizontal)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
        }
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(MOUNT_TYPE, (Comparable)((Object)MountType.WALL))).setValue((Property)FACING, (Comparable)face)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    protected VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        if (blockState.getValue(MOUNT_TYPE) == MountType.FLOOR) {
            return SHAPE_FLOOR;
        }
        return WALL_SHAPES[((Direction)blockState.getValue((Property)FACING)).get2DDataValue()];
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        if (!level.isClientSide) {
            boolean powered = (Boolean)blockState.getValue((Property)POWERED);
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)LIT, (Comparable)Boolean.valueOf((Boolean)blockState.getValue((Property)LIT) == false && !powered)), 3);
            level.playSound(null, blockPos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.isClientSide) {
            boolean isPowered = level.hasNeighborSignal(pos);
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(isPowered))).setValue((Property)LIT, (Comparable)Boolean.valueOf(isPowered)), 2);
        }
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @Override
    public BlockState mirror(BlockState state, Mirror mirror) {
        return this.rotate(state, mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, MOUNT_TYPE, LIT, POWERED});
    }
}

