/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.block;

import com.lunazstudios.cobblefurnies.block.properties.CFBlockStateProperties;
import com.lunazstudios.cobblefurnies.block.properties.CurtainHorizontalPart;
import com.lunazstudios.cobblefurnies.block.properties.CurtainVerticalPart;
import com.lunazstudios.cobblefurnies.util.block.ShapeUtil;
import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CurtainBlock
extends HorizontalDirectionalBlock {
    public static final EnumProperty<CurtainVerticalPart> VERTICAL = CFBlockStateProperties.CURTAIN_VERTICAL;
    public static final EnumProperty<CurtainHorizontalPart> HORIZONTAL = CFBlockStateProperties.CURTAIN_HORIZONTAL;
    public static final BooleanProperty OPEN = CFBlockStateProperties.OPEN;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.DOOR_HINGE;
    protected static final VoxelShape SHAPE_TOP_NORTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)14.5, (double)16.0, (double)14.0, (double)15.5));
    protected static final VoxelShape SHAPE_TOP_EAST = ShapeUtil.rotateShape(SHAPE_TOP_NORTH, Direction.EAST);
    protected static final VoxelShape SHAPE_TOP_SOUTH = ShapeUtil.rotateShape(SHAPE_TOP_NORTH, Direction.SOUTH);
    protected static final VoxelShape SHAPE_TOP_WEST = ShapeUtil.rotateShape(SHAPE_TOP_NORTH, Direction.WEST);
    protected static final VoxelShape[] SHAPES_TOP = new VoxelShape[]{SHAPE_TOP_SOUTH, SHAPE_TOP_WEST, SHAPE_TOP_NORTH, SHAPE_TOP_EAST};
    protected static final VoxelShape SHAPE_BOTTOM_NORTH = Block.box((double)0.0, (double)0.0, (double)14.5, (double)16.0, (double)16.0, (double)15.5);
    protected static final VoxelShape SHAPE_BOTTOM_EAST = ShapeUtil.rotateShape(SHAPE_BOTTOM_NORTH, Direction.EAST);
    protected static final VoxelShape SHAPE_BOTTOM_SOUTH = ShapeUtil.rotateShape(SHAPE_BOTTOM_NORTH, Direction.SOUTH);
    protected static final VoxelShape SHAPE_BOTTOM_WEST = ShapeUtil.rotateShape(SHAPE_BOTTOM_NORTH, Direction.WEST);
    protected static final VoxelShape[] SHAPES_BOTTOM = new VoxelShape[]{SHAPE_BOTTOM_SOUTH, SHAPE_BOTTOM_WEST, SHAPE_BOTTOM_NORTH, SHAPE_BOTTOM_EAST};

    public CurtainBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(VERTICAL, (Comparable)((Object)CurtainVerticalPart.BOTTOM))).setValue(HORIZONTAL, (Comparable)((Object)CurtainHorizontalPart.MIDDLE))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue(HINGE, (Comparable)DoorHingeSide.LEFT));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        int facingIndex = facing.get2DDataValue();
        if (state.getValue(VERTICAL) == CurtainVerticalPart.TOP) {
            return SHAPES_TOP[facingIndex];
        }
        return SHAPES_BOTTOM[facingIndex];
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        CurtainVerticalPart vertical;
        BlockPos otherPos;
        BlockState otherState;
        if (!level.isClientSide && (otherState = level.getBlockState(otherPos = (vertical = (CurtainVerticalPart)((Object)state.getValue(VERTICAL))) == CurtainVerticalPart.TOP ? pos.below() : pos.above())).getBlock() == this && otherState.getValue(VERTICAL) != vertical && otherState.getValue((Property)FACING) == state.getValue((Property)FACING)) {
            level.destroyBlock(otherPos, !player.isCreative());
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)OPEN) != false ? Shapes.empty() : this.getShape(state, world, pos, context);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, VERTICAL, HORIZONTAL, OPEN, HINGE});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos topPos = ctx.getClickedPos();
        BlockPos bottomPos = topPos.below();
        Level level = ctx.getLevel();
        if (!level.getBlockState(bottomPos).canBeReplaced(ctx)) {
            return null;
        }
        Direction facing = ctx.getHorizontalDirection().getOpposite();
        Vec3 clickVec = ctx.getClickLocation().subtract(Vec3.atLowerCornerOf((Vec3i)topPos));
        Direction right = facing.getClockWise();
        double side = right.getAxis().choose(clickVec.x, 0.0, clickVec.z);
        DoorHingeSide hinge = side > 0.5 ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT;
        BlockState topState = (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue(VERTICAL, (Comparable)((Object)CurtainVerticalPart.TOP))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue(HINGE, (Comparable)hinge);
        CurtainHorizontalPart horizontal = this.getCurtainHorizontalType(topState, (LevelAccessor)level, topPos);
        BlockState bottomState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue(VERTICAL, (Comparable)((Object)CurtainVerticalPart.BOTTOM))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue(HINGE, (Comparable)hinge)).setValue(HORIZONTAL, (Comparable)((Object)horizontal));
        level.setBlock(bottomPos, bottomState, 3);
        return (BlockState)topState.setValue(HORIZONTAL, (Comparable)((Object)horizontal));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        CurtainVerticalPart vertical = (CurtainVerticalPart)((Object)state.getValue(VERTICAL));
        level.setBlock(pos, (BlockState)state.setValue(HORIZONTAL, (Comparable)((Object)this.getCurtainHorizontalType(state, (LevelAccessor)level, pos))), 3);
        BlockPos leftPos = pos.relative(facing.getCounterClockWise());
        BlockPos rightPos = pos.relative(facing.getClockWise());
        for (BlockPos sidePos : List.of(leftPos, rightPos)) {
            BlockState sideState = level.getBlockState(sidePos);
            if (sideState.getBlock() != this || sideState.getValue(VERTICAL) != vertical || sideState.getValue((Property)FACING) != facing) continue;
            level.setBlock(sidePos, (BlockState)sideState.setValue(HORIZONTAL, (Comparable)((Object)this.getCurtainHorizontalType(sideState, (LevelAccessor)level, sidePos))), 3);
        }
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (dir.getAxis().isHorizontal()) {
            return (BlockState)state.setValue(HORIZONTAL, (Comparable)((Object)this.getCurtainHorizontalType(state, level, pos)));
        }
        return state;
    }

    private CurtainHorizontalPart getCurtainHorizontalType(BlockState state, LevelAccessor level, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        Direction left = facing.getCounterClockWise();
        Direction right = facing.getClockWise();
        boolean hasLeft = this.isSameCurtain(level.getBlockState(pos.relative(left)), state);
        boolean hasRight = this.isSameCurtain(level.getBlockState(pos.relative(right)), state);
        if (hasLeft && hasRight) {
            return CurtainHorizontalPart.MIDDLE;
        }
        if (hasLeft) {
            return CurtainHorizontalPart.RIGHT;
        }
        if (hasRight) {
            return CurtainHorizontalPart.LEFT;
        }
        return CurtainHorizontalPart.SINGLE;
    }

    private boolean isSameCurtain(BlockState neighbor, BlockState base) {
        return neighbor.getBlock() == base.getBlock() && neighbor.getValue((Property)FACING) == base.getValue((Property)FACING) && neighbor.getValue(VERTICAL) == base.getValue(VERTICAL);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (state.getValue(VERTICAL) == CurtainVerticalPart.BOTTOM) {
            this.toggleCurtain(level, pos.above(), (Direction)state.getValue((Property)FACING));
        } else {
            this.toggleCurtain(level, pos, (Direction)state.getValue((Property)FACING));
        }
        return InteractionResult.CONSUME;
    }

    protected List<ItemStack> getDrops(BlockState blockState, LootParams.Builder builder) {
        if (blockState.getValue(VERTICAL) == CurtainVerticalPart.TOP) {
            return Collections.emptyList();
        }
        return super.getDrops(blockState, builder);
    }

    private void toggleCurtain(Level level, BlockPos origin, Direction facing) {
        boolean targetOpen;
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.add(origin);
        BlockState originState = level.getBlockState(origin);
        boolean bl = targetOpen = (Boolean)originState.getValue((Property)OPEN) == false;
        while (!queue.isEmpty()) {
            Direction verticalDir;
            BlockPos verticalPos;
            BlockState verticalState;
            BlockState state;
            BlockPos pos = (BlockPos)queue.poll();
            if (!visited.add(pos) || !((state = level.getBlockState(pos)).getBlock() instanceof CurtainBlock) || state.getValue((Property)FACING) != facing) continue;
            if ((Boolean)state.getValue((Property)OPEN) != targetOpen) {
                level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(targetOpen)), 3);
            }
            if ((verticalState = level.getBlockState(verticalPos = pos.relative(verticalDir = state.getValue(VERTICAL) == CurtainVerticalPart.TOP ? Direction.DOWN : Direction.UP))).getBlock() == this && verticalState.getValue((Property)FACING) == facing) {
                queue.add(verticalPos);
            }
            for (Direction side : List.of(facing.getClockWise(), facing.getCounterClockWise())) {
                BlockPos sidePos = pos.relative(side);
                BlockState sideState = level.getBlockState(sidePos);
                if (sideState.getBlock() != this || sideState.getValue((Property)FACING) != facing || sideState.getValue(VERTICAL) != state.getValue(VERTICAL)) continue;
                queue.add(sidePos);
            }
        }
    }
}

