/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.block;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BonsaiPlantBlock
extends Block {
    public static final EnumProperty<DoubleBlockHalf> HALF = EnumProperty.create((String)"half", DoubleBlockHalf.class);
    protected static final VoxelShape SHAPE_BOTTOM = Shapes.or((VoxelShape)Block.box((double)2.0, (double)9.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0), Block.box((double)6.5, (double)13.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5)});
    protected static final VoxelShape SHAPE_TOP = Shapes.or((VoxelShape)Block.box((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)11.0, (double)9.5), (VoxelShape[])new VoxelShape[]{Block.box((double)4.5, (double)12.0, (double)4.5, (double)7.5, (double)15.0, (double)7.5), Block.box((double)5.5, (double)11.0, (double)5.5, (double)10.5, (double)16.0, (double)10.5), Block.box((double)8.5, (double)13.0, (double)8.5, (double)11.5, (double)16.0, (double)11.5), Block.box((double)3.5, (double)10.0, (double)8.5, (double)6.5, (double)13.0, (double)11.5)});

    public BonsaiPlantBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        if (pos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(pos.above()).canBeReplaced(context)) {
            return (BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        level.setBlock(pos.above(), (BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public void playerDestroy(Level level, Player player, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, ItemStack itemStack) {
        DoubleBlockHalf half = (DoubleBlockHalf)blockState.getValue(HALF);
        BlockPos otherHalfPos = half == DoubleBlockHalf.LOWER ? blockPos.above() : blockPos.below();
        BlockState otherHalfState = level.getBlockState(otherHalfPos);
        if (otherHalfState.is((Block)this) && otherHalfState.getValue(HALF) != half) {
            level.destroyBlock(otherHalfPos, false);
        }
        super.playerDestroy(level, player, blockPos, blockState, blockEntity, itemStack);
    }

    protected List<ItemStack> getDrops(BlockState blockState, LootParams.Builder builder) {
        if (blockState.getValue(HALF) == DoubleBlockHalf.UPPER) {
            return Collections.emptyList();
        }
        return super.getDrops(blockState, builder);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        if (direction == (half == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN)) {
            if (neighborState.is((Block)this) && neighborState.getValue(HALF) != half) {
                return state;
            }
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return state.getValue(HALF) == DoubleBlockHalf.LOWER ? SHAPE_BOTTOM : SHAPE_TOP;
    }
}

