/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.cobblenav.networking.handler.server;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.net.ServerNetworkPacketHandler;
import com.cobblemon.mod.common.api.spawning.SpawnBucket;
import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.SpawningZone;
import com.cobblemon.mod.common.api.spawning.SpawningZoneGenerator;
import com.cobblemon.mod.common.api.spawning.detail.PokemonSpawnDetail;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.position.AreaSpawnablePosition;
import com.cobblemon.mod.common.api.spawning.position.calculators.SpawnablePositionCalculator;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.cobblemon.mod.common.api.spawning.spawner.SpawningZoneInput;
import com.cobblemon.mod.common.config.CobblemonConfig;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.metacontent.cobblenav.Cobblenav;
import com.metacontent.cobblenav.config.CobblenavConfig;
import com.metacontent.cobblenav.networking.packet.client.SpawnMapPacket;
import com.metacontent.cobblenav.networking.packet.server.RequestSpawnMapPacket;
import com.metacontent.cobblenav.spawndata.SpawnData;
import com.metacontent.cobblenav.spawndata.SpawnDataHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/metacontent/cobblenav/networking/handler/server/RequestSpawnMapHandler;", "Lcom/cobblemon/mod/common/api/net/ServerNetworkPacketHandler;", "Lcom/metacontent/cobblenav/networking/packet/server/RequestSpawnMapPacket;", "<init>", "()V", "packet", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "handle", "(Lcom/metacontent/cobblenav/networking/packet/server/RequestSpawnMapPacket;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/server/level/ServerPlayer;)V", "cobblenav-common"})
@SourceDebugExtension(value={"SMAP\nRequestSpawnMapHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestSpawnMapHandler.kt\ncom/metacontent/cobblenav/networking/handler/server/RequestSpawnMapHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n295#2,2:73\n216#3:75\n217#3:77\n1#4:76\n*S KotlinDebug\n*F\n+ 1 RequestSpawnMapHandler.kt\ncom/metacontent/cobblenav/networking/handler/server/RequestSpawnMapHandler\n*L\n32#1:73,2\n62#1:75\n62#1:77\n*E\n"})
public final class RequestSpawnMapHandler
implements ServerNetworkPacketHandler<RequestSpawnMapPacket> {
    @NotNull
    public static final RequestSpawnMapHandler INSTANCE = new RequestSpawnMapHandler();

    private RequestSpawnMapHandler() {
    }

    public void handle(@NotNull RequestSpawnMapPacket packet, @NotNull MinecraftServer server, @NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        CobblemonConfig cobblemonConfig = Cobblemon.INSTANCE.getConfig();
        CobblenavConfig config = Cobblenav.INSTANCE.getConfig();
        List spawnDataList = new ArrayList();
        server.execute(() -> RequestSpawnMapHandler.handle$lambda$0(cobblemonConfig, player, config, packet, spawnDataList));
    }

    private static final void handle$lambda$0(CobblemonConfig $cobblemonConfig, ServerPlayer $player, CobblenavConfig $config, RequestSpawnMapPacket $packet, List $spawnDataList) {
        if ($cobblemonConfig.getEnableSpawning()) {
            Map spawnProbabilities;
            Object v0;
            PlayerSpawner spawner;
            block4: {
                spawner = PlayerExtensionsKt.getSpawner((ServerPlayer)$player);
                Iterable $this$firstOrNull$iv = Cobblemon.INSTANCE.getBestSpawner().getConfig().getBuckets();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SpawnBucket it = (SpawnBucket)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)$packet.getBucket())) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            SpawnBucket spawnBucket = v0;
            if (spawnBucket == null) {
                RequestSpawnMapHandler $this$handle_u24lambda_u240_u241 = INSTANCE;
                boolean bl = false;
                Cobblenav.INSTANCE.getLOGGER().error("For some reason bucket is null");
                new SpawnMapPacket($packet.getBucket(), CollectionsKt.emptyList()).sendToPlayer($player);
                return;
            }
            SpawnBucket bucket = spawnBucket;
            SpawnCause cause = new SpawnCause((Spawner)spawner, (Entity)$player);
            SpawningZoneGenerator spawningZoneGenerator = Cobblemon.INSTANCE.getSpawningZoneGenerator();
            Spawner spawner2 = (Spawner)spawner;
            ServerLevel serverLevel = $player.serverLevel();
            Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"serverLevel(...)");
            SpawningZone zone = spawningZoneGenerator.generate(spawner2, new SpawningZoneInput(cause, serverLevel, (int)Math.ceil($player.getX() - (double)((float)$config.getCheckSpawnWidth() / 2.0f)), (int)Math.ceil($player.getY() - (double)((float)$config.getCheckSpawnHeight() / 2.0f)), (int)Math.ceil($player.getZ() - (double)((float)$config.getCheckSpawnWidth() / 2.0f)), $config.getCheckSpawnWidth(), $config.getCheckSpawnHeight(), $config.getCheckSpawnWidth()));
            List<AreaSpawnablePosition> spawnablePositions = Cobblenav.INSTANCE.getResolver().resolve((Spawner)spawner, SpawnablePositionCalculator.Companion.getPrioritizedAreaCalculators(), zone);
            Map $this$forEach$iv = spawnProbabilities = spawner.getSelector().getProbabilities((Spawner)spawner, bucket, spawnablePositions);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                SpawnData spawnData;
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                SpawnDetail detail = (SpawnDetail)entry.getKey();
                float spawnChance = ((Number)entry.getValue()).floatValue();
                if (!(detail instanceof PokemonSpawnDetail) || !((PokemonSpawnDetail)detail).isValid() || (spawnData = SpawnDataHelper.INSTANCE.collect((PokemonSpawnDetail)detail, spawnChance, spawnablePositions, $player)) == null) continue;
                SpawnData it = spawnData;
                boolean bl2 = false;
                $spawnDataList.add(it);
            }
        }
        new SpawnMapPacket($packet.getBucket(), $spawnDataList).sendToPlayer($player);
    }
}

