/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.cobblenav.client.gui.overlay;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.util.math.QuaternionUtilsKt;
import com.metacontent.cobblenav.client.CobblenavClient;
import com.metacontent.cobblenav.client.gui.util.RenderUtilsKt;
import com.mojang.blaze3d.vertex.PoseStack;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u001c\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0017\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\"\u0010\u0019\u001a\u00020\u00188\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR*\u0010 \u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000f8\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b \u0010\u0011\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lcom/metacontent/cobblenav/client/gui/overlay/TrackArrowOverlay;", "Lnet/minecraft/client/gui/Gui;", "<init>", "()V", "Lnet/minecraft/client/gui/GuiGraphics;", "guiGraphics", "Lnet/minecraft/client/DeltaTracker;", "deltaTracker", "", "render", "(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V", "Lnet/minecraft/client/Minecraft;", "kotlin.jvm.PlatformType", "minecraft", "Lnet/minecraft/client/Minecraft;", "", "offset", "I", "Lnet/minecraft/world/item/ItemStack;", "stack$delegate", "Lkotlin/Lazy;", "getStack", "()Lnet/minecraft/world/item/ItemStack;", "stack", "", "tracking", "Z", "getTracking", "()Z", "setTracking", "(Z)V", "value", "entityId", "getEntityId", "()I", "setEntityId", "(I)V", "cobblenav-common"})
public final class TrackArrowOverlay
extends Gui {
    private final Minecraft minecraft = Minecraft.getInstance();
    private final int offset = CobblenavClient.INSTANCE.getConfig().getTrackArrowYOffset();
    @NotNull
    private final Lazy stack$delegate = LazyKt.lazy(TrackArrowOverlay::stack_delegate$lambda$0);
    private boolean tracking;
    private int entityId = -1;

    public TrackArrowOverlay() {
        super(Minecraft.getInstance());
    }

    private final ItemStack getStack() {
        Lazy lazy = this.stack$delegate;
        return (ItemStack)lazy.getValue();
    }

    public final boolean getTracking() {
        return this.tracking;
    }

    public final void setTracking(boolean bl) {
        this.tracking = bl;
    }

    public final int getEntityId() {
        return this.entityId;
    }

    public final void setEntityId(int value) {
        this.tracking = true;
        this.entityId = value;
    }

    public void render(@NotNull GuiGraphics guiGraphics, @NotNull DeltaTracker deltaTracker) {
        Entity entity;
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Intrinsics.checkNotNullParameter((Object)deltaTracker, (String)"deltaTracker");
        if (!this.tracking) {
            return;
        }
        ClientLevel clientLevel = this.minecraft.level;
        Entity entity2 = entity = clientLevel != null ? clientLevel.getEntity(this.entityId) : null;
        if (entity == null) {
            this.tracking = false;
            return;
        }
        LocalPlayer localPlayer = this.minecraft.player;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        PoseStack poseStack = guiGraphics.pose();
        double scale = (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth() * this.minecraft.getWindow().getGuiScale();
        int scaledOffset = (int)((double)this.offset / scale);
        int x = this.minecraft.getWindow().getGuiScaledWidth() / 2;
        int y = this.minecraft.getWindow().getGuiScaledHeight() - scaledOffset;
        Vec3 distanceVec = player.position().vectorTo(entity.position());
        float yaw = (float)Math.atan2(distanceVec.z, distanceVec.x);
        double horizontalDistance = Math.sqrt(distanceVec.x * distanceVec.x + distanceVec.z * distanceVec.z);
        float pitch = (float)Math.atan2(distanceVec.y, horizontalDistance);
        Intrinsics.checkNotNull((Object)poseStack);
        Vector3d vector3d = new Vector3d((double)x, (double)y, 0.0);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Intrinsics.checkNotNullExpressionValue((Object)quaternionf, (String)"rotateZ(...)");
        RenderUtilsKt.pushAndPop(poseStack, vector3d, QuaternionUtilsKt.fromEulerXYZDegrees((Quaternionf)quaternionf, (Vector3f)new Vector3f(player.getXRot(), -player.getYRot(), 0.0f)).rotateY(1.5707964f + yaw).rotateX(-pitch), new Vector3f(50.0f, 50.0f, -50.0f), (Function0<Unit>)((Function0)() -> TrackArrowOverlay.render$lambda$0(this, poseStack, guiGraphics)));
        Object[] objectArray = new Object[]{(int)distanceVec.length()};
        MutableComponent mutableComponent = Component.translatable((String)"gui.cobblenav.finder.distance", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        RenderHelperKt.drawScaledText$default((GuiGraphics)guiGraphics, null, (MutableComponent)mutableComponent, (Number)x, (Number)(y + 20), (float)0.0f, null, (int)0, (int)0, (boolean)true, (boolean)false, null, null, (int)7650, null);
    }

    private static final ItemStack stack_delegate$lambda$0() {
        return new ItemStack((ItemLike)CobblemonItems.POKE_BALL);
    }

    private static final Unit render$lambda$0(TrackArrowOverlay this$0, PoseStack $poseStack, GuiGraphics $guiGraphics) {
        this$0.minecraft.getItemRenderer().renderStatic(this$0.getStack(), ItemDisplayContext.GROUND, 255, 1000, $poseStack, (MultiBufferSource)$guiGraphics.bufferSource(), (Level)this$0.minecraft.level, 0);
        return Unit.INSTANCE;
    }
}

