/*
 * Decompiled with CFR 0.152.
 */
package com.levelscraft7.catchindicator.neoforge.mixin;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.levelscraft7.catchindicator.client.CatchIndicatorClientConfig;
import com.levelscraft7.catchindicator.client.DiscoveryStatus;
import com.levelscraft7.catchindicator.client.PokedexRefreshManager;
import java.lang.reflect.Method;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PokemonEntity.class})
public abstract class PokemonEntityNameMixin {
    @Inject(method={"getName()Lnet/minecraft/network/chat/Component;"}, at={@At(value="RETURN")}, cancellable=true)
    private void catchindicator$decorateWildName(CallbackInfoReturnable<Component> cir) {
        if (!CatchIndicatorClientConfig.isEnabled()) {
            return;
        }
        Component original = (Component)cir.getReturnValue();
        if (original == null) {
            return;
        }
        Pokemon pokemon = PokemonEntityNameMixin.fastGetPokemon(this);
        if (pokemon == null) {
            return;
        }
        String speciesId = PokemonEntityNameMixin.fastSpeciesKey(pokemon);
        if (speciesId == null || speciesId.isBlank()) {
            return;
        }
        boolean definitelyWild = PokemonEntityNameMixin.isDefinitelyWild(pokemon);
        if (!definitelyWild) {
            PokedexRefreshManager.markSpeciesCaught(speciesId);
            MutableComponent out = Component.empty().append(PokemonEntityNameMixin.catchindicator$getCaughtIcon()).append((Component)Component.literal((String)" ")).append(original);
            cir.setReturnValue((Object)out);
            return;
        }
        DiscoveryStatus status = PokedexRefreshManager.getCachedStatus(speciesId);
        if (status == DiscoveryStatus.CAUGHT) {
            MutableComponent out = Component.empty().append(PokemonEntityNameMixin.catchindicator$getCaughtIcon()).append((Component)Component.literal((String)" ")).append(original);
            cir.setReturnValue((Object)out);
            return;
        }
        if (status == DiscoveryStatus.UNKNOWN && PokedexRefreshManager.isCacheReady()) {
            cir.setReturnValue((Object)Component.literal((String)"???"));
        }
    }

    @Unique
    private static Component catchindicator$getCaughtIcon() {
        return Component.literal((String)"\ua000").withStyle(s -> s.withFont(CatchIndicatorClientConfig.getIconFont()));
    }

    @Unique
    private static Pokemon fastGetPokemon(Object pokemonEntity) {
        try {
            Pokemon p;
            Method m = pokemonEntity.getClass().getMethod("getPokemon", new Class[0]);
            Object v = m.invoke(pokemonEntity, new Object[0]);
            return v instanceof Pokemon ? (p = (Pokemon)v) : null;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Unique
    private static String fastSpeciesKey(Pokemon pokemon) {
        try {
            Object species = pokemon.getClass().getMethod("getSpecies", new Class[0]).invoke((Object)pokemon, new Object[0]);
            if (species == null) {
                return null;
            }
            Object rl = PokemonEntityNameMixin.tryInvoke(species, "getResourceIdentifier", "resourceIdentifier", "getResourceLocation", "resourceLocation", "getId", "id");
            if (rl != null) {
                return rl.toString();
            }
            Object showdown = PokemonEntityNameMixin.tryInvoke(species, "getShowdownId", "showdownId", "getId", "id");
            return showdown != null ? showdown.toString() : null;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    /*
     * Loose catch block
     */
    @Unique
    private static boolean isDefinitelyWild(Pokemon pokemon) {
        String s;
        block11: {
            Object wildFlag = PokemonEntityNameMixin.tryInvoke(pokemon, "isWild", "getIsWild");
            if (wildFlag instanceof Boolean) {
                Boolean b = (Boolean)wildFlag;
                return b;
            }
            Object ownedFlag = PokemonEntityNameMixin.tryInvoke(pokemon, "isOwned", "isPlayerOwned", "getIsOwned", "getOwned");
            if (ownedFlag instanceof Boolean) {
                Boolean b = (Boolean)ownedFlag;
                return b == false;
            }
            Object owner = PokemonEntityNameMixin.tryInvoke(pokemon, "getOwnerUUID", "getOwnerUuid", "getOwner", "getOwnerId", "getOriginalTrainerUUID", "getOriginalTrainer");
            if (owner == null) {
                return false;
            }
            Object unwrapped = PokemonEntityNameMixin.tryInvoke(owner, "orElse", "get");
            if (unwrapped != null) {
                owner = unwrapped;
            }
            if (owner instanceof UUID) {
                return false;
            }
            s = owner.toString();
            if (s == null || s.isBlank()) {
                return true;
            }
            if (!"NONE".equalsIgnoreCase(s) && !"null".equalsIgnoreCase(s)) break block11;
            return true;
            {
                catch (Throwable ignored) {
                    return false;
                }
            }
        }
        try {
            UUID.fromString(s);
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Unique
    private static Object tryInvoke(Object target, String ... names) {
        if (target == null) {
            return null;
        }
        for (String n : names) {
            try {
                Method m;
                try {
                    m = target.getClass().getDeclaredMethod(n, new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    m = target.getClass().getMethod(n, new Class[0]);
                }
                m.setAccessible(true);
                return m.invoke(target, new Object[0]);
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }
}

