/*
 * Decompiled with CFR 0.152.
 */
package com.levelscraft7.catchindicator.client;

import com.levelscraft7.catchindicator.client.DiscoveryStatus;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;

public final class PokemonNameCache {
    private static final Map<Entity, CacheEntry> CACHE = new WeakHashMap<Entity, CacheEntry>();

    private PokemonNameCache() {
    }

    public static CacheEntry getOrCreate(Entity entity, Component baseName) {
        CacheEntry entry = CACHE.get(entity);
        if (entry == null) {
            entry = new CacheEntry();
            entry.decoratedName = Component.literal((String)"???");
            entry.lastStatus = DiscoveryStatus.UNKNOWN;
            entry.dirty = true;
            CACHE.put(entity, entry);
        }
        if (baseName != null) {
            entry.updateBaseName(baseName);
        }
        return entry;
    }

    public static void markDirtyForSpecies(Set<String> speciesIds) {
        if (speciesIds == null || speciesIds.isEmpty()) {
            return;
        }
        for (CacheEntry entry : CACHE.values()) {
            if (entry == null || entry.speciesId == null || !speciesIds.contains(entry.speciesId)) continue;
            entry.dirty = true;
        }
    }

    public static void markAllDirty() {
        for (CacheEntry entry : CACHE.values()) {
            if (entry == null) continue;
            entry.dirty = true;
        }
    }

    public static final class CacheEntry {
        private Component decoratedName;
        private DiscoveryStatus lastStatus;
        private boolean dirty;
        private long nextAllowedRefreshMillis;
        private Component baseName;
        private String speciesId;

        public Component getDecoratedName() {
            return this.decoratedName;
        }

        public DiscoveryStatus getLastStatus() {
            return this.lastStatus;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public long getNextAllowedRefreshMillis() {
            return this.nextAllowedRefreshMillis;
        }

        public Component getBaseName() {
            return this.baseName;
        }

        public String getSpeciesId() {
            return this.speciesId;
        }

        public void setDecoratedName(Component decoratedName) {
            this.decoratedName = decoratedName;
        }

        public void setLastStatus(DiscoveryStatus lastStatus) {
            this.lastStatus = lastStatus;
        }

        public void setDirty(boolean dirty) {
            this.dirty = dirty;
        }

        public void setNextAllowedRefreshMillis(long nextAllowedRefreshMillis) {
            this.nextAllowedRefreshMillis = nextAllowedRefreshMillis;
        }

        public void setSpeciesId(String speciesId) {
            this.speciesId = speciesId;
        }

        void updateBaseName(Component baseName) {
            if (this.baseName == null || !this.baseName.equals((Object)baseName)) {
                this.baseName = baseName;
                this.dirty = true;
            }
        }
    }
}

