/*
 * Decompiled with CFR 0.152.
 */
package com.levelscraft7.catchindicator.client;

import com.levelscraft7.catchindicator.client.CatchIndicatorClientConfig;
import com.levelscraft7.catchindicator.client.DiscoveryStatus;
import com.levelscraft7.catchindicator.client.PokemonNameCache;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;

public final class PokedexRefreshManager {
    private static final Set<String> SEEN_SPECIES = new HashSet<String>();
    private static final Set<String> CAUGHT_SPECIES = new HashSet<String>();
    private static volatile boolean CACHE_READY = false;
    private static long lastFullSyncGameTime = -999999L;
    private static final long FULL_SYNC_MIN_INTERVAL_TICKS = 20L;

    private PokedexRefreshManager() {
    }

    public static DiscoveryStatus getCachedStatus(String anyId) {
        if (!CatchIndicatorClientConfig.isEnabled()) {
            return DiscoveryStatus.UNKNOWN;
        }
        if (anyId == null || anyId.isBlank()) {
            return DiscoveryStatus.UNKNOWN;
        }
        for (String normalized : PokedexRefreshManager.normalizeIds(anyId)) {
            if (!CAUGHT_SPECIES.contains(normalized)) continue;
            return DiscoveryStatus.CAUGHT;
        }
        for (String normalized : PokedexRefreshManager.normalizeIds(anyId)) {
            if (!SEEN_SPECIES.contains(normalized)) continue;
            return DiscoveryStatus.SEEN;
        }
        return DiscoveryStatus.UNKNOWN;
    }

    public static void markSpeciesCaught(String anyId) {
        if (!CatchIndicatorClientConfig.isEnabled()) {
            return;
        }
        if (anyId == null) {
            return;
        }
        String s = anyId.trim();
        if (s.isEmpty()) {
            return;
        }
        HashSet<String> changedIds = new HashSet<String>();
        boolean changed = PokedexRefreshManager.markCaught(s, changedIds);
        if (PokedexRefreshManager.markSeen(s, changedIds)) {
            changed = true;
        }
        if (changed) {
            PokemonNameCache.markDirtyForSpecies(changedIds);
        }
    }

    public static boolean isSpeciesCaught(String anyId) {
        if (!CatchIndicatorClientConfig.isEnabled()) {
            return false;
        }
        if (anyId == null || anyId.isBlank()) {
            return false;
        }
        for (String normalized : PokedexRefreshManager.normalizeIds(anyId)) {
            if (!CAUGHT_SPECIES.contains(normalized)) continue;
            return true;
        }
        return false;
    }

    private static boolean markSeen(String anyId, Set<String> changedIds) {
        if (anyId == null || anyId.isBlank()) {
            return false;
        }
        boolean changed = false;
        for (String normalized : PokedexRefreshManager.normalizeIds(anyId)) {
            if (!SEEN_SPECIES.add(normalized)) continue;
            changed = true;
            if (changedIds == null) continue;
            changedIds.add(normalized);
        }
        return changed;
    }

    private static boolean markCaught(String anyId, Set<String> changedIds) {
        if (anyId == null || anyId.isBlank()) {
            return false;
        }
        boolean changed = false;
        for (String normalized : PokedexRefreshManager.normalizeIds(anyId)) {
            if (!CAUGHT_SPECIES.add(normalized)) continue;
            changed = true;
            if (changedIds == null) continue;
            changedIds.add(normalized);
        }
        return changed;
    }

    public static void onPokedexSync(Object clientPokedexManagerOrData) {
        if (!CatchIndicatorClientConfig.isEnabled()) {
            return;
        }
        if (clientPokedexManagerOrData == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || mc.level == null) {
            return;
        }
        long now = mc.level.getGameTime();
        if (now - lastFullSyncGameTime < 20L) {
            return;
        }
        lastFullSyncGameTime = now;
        Map<?, ?> records = PokedexRefreshManager.resolveSpeciesRecords(clientPokedexManagerOrData);
        if (records == null || records.isEmpty()) {
            return;
        }
        boolean changed = false;
        HashSet<String> changedIds = new HashSet<String>();
        for (Map.Entry<?, ?> e : records.entrySet()) {
            Object speciesId;
            Object key = e.getKey();
            Object record = e.getValue();
            if (record == null) continue;
            DiscoveryStatus status = PokedexRefreshManager.computeStatusFromRecord(record);
            if (status == DiscoveryStatus.CAUGHT) {
                if (key != null && PokedexRefreshManager.markCaught(key.toString(), changedIds)) {
                    changed = true;
                }
                if ((speciesId = PokedexRefreshManager.invokeFirst(record, "getId", "id", "getSpeciesId", "speciesId")) != null && PokedexRefreshManager.markCaught(speciesId.toString(), changedIds)) {
                    changed = true;
                }
                if (key != null && PokedexRefreshManager.markSeen(key.toString(), changedIds)) {
                    changed = true;
                }
                if (speciesId == null || !PokedexRefreshManager.markSeen(speciesId.toString(), changedIds)) continue;
                changed = true;
                continue;
            }
            if (status != DiscoveryStatus.SEEN) continue;
            if (key != null && PokedexRefreshManager.markSeen(key.toString(), changedIds)) {
                changed = true;
            }
            if ((speciesId = PokedexRefreshManager.invokeFirst(record, "getId", "id", "getSpeciesId", "speciesId")) == null || !PokedexRefreshManager.markSeen(speciesId.toString(), changedIds)) continue;
            changed = true;
        }
        if (changed) {
            PokemonNameCache.markDirtyForSpecies(changedIds);
        }
        CACHE_READY = true;
    }

    public static boolean isCacheReady() {
        if (!CatchIndicatorClientConfig.isEnabled()) {
            return false;
        }
        return CACHE_READY;
    }

    private static DiscoveryStatus computeStatusFromRecord(Object speciesDexRecord) {
        Map map;
        Object formRecordsObj;
        String s;
        if (speciesDexRecord == null) {
            return DiscoveryStatus.UNKNOWN;
        }
        Object knowledge = PokedexRefreshManager.invokeFirst(speciesDexRecord, "getKnowledge", "getEntryProgress", "getProgress", "knowledge");
        String string = s = knowledge != null ? knowledge.toString() : "";
        if (!s.isBlank()) {
            String u = s.toUpperCase();
            if (u.contains("CAUGHT")) {
                return DiscoveryStatus.CAUGHT;
            }
            if (u.contains("SEEN") || u.contains("ENCOUNTERED")) {
                return DiscoveryStatus.SEEN;
            }
        }
        if ((formRecordsObj = PokedexRefreshManager.readFieldIfExists(speciesDexRecord, "formRecords")) instanceof Map && !(map = (Map)formRecordsObj).isEmpty()) {
            boolean anySeen = false;
            for (Object v : map.values()) {
                Object fk;
                if (v == null || (fk = PokedexRefreshManager.invokeFirst(v, "getKnowledge", "knowledge")) == null) continue;
                String fu = fk.toString().toUpperCase();
                if (fu.contains("CAUGHT")) {
                    return DiscoveryStatus.CAUGHT;
                }
                if (!fu.contains("SEEN") && !fu.contains("ENCOUNTERED")) continue;
                anySeen = true;
            }
            if (anySeen) {
                return DiscoveryStatus.SEEN;
            }
        }
        return DiscoveryStatus.UNKNOWN;
    }

    static Set<String> normalizeIds(String raw) {
        HashSet<String> ids = new HashSet<String>();
        String trimmed = raw.trim();
        if (trimmed.isEmpty()) {
            return ids;
        }
        ids.add(trimmed);
        Object namespaced = trimmed.contains(":") ? trimmed : "cobblemon:" + trimmed;
        ids.add((String)namespaced);
        try {
            ResourceLocation rl = ResourceLocation.parse((String)namespaced);
            ids.add(rl.toString());
            ids.add(rl.getPath());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ids;
    }

    private static Map<?, ?> resolveSpeciesRecords(Object clientPokedexManagerOrData) {
        Object recordsObj = PokedexRefreshManager.invokeFirst(clientPokedexManagerOrData, "getSpeciesRecords", "speciesRecords", "getRecords", "records");
        if (recordsObj == null) {
            recordsObj = PokedexRefreshManager.readFieldIfExists(clientPokedexManagerOrData, "speciesRecords", "records");
        }
        if (recordsObj instanceof Map) {
            Map records = (Map)recordsObj;
            return records;
        }
        return null;
    }

    private static Object readFieldIfExists(Object target, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            try {
                Field f = target.getClass().getDeclaredField(fieldName);
                f.setAccessible(true);
                Object value = f.get(target);
                if (value == null) continue;
                return value;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private static Object invokeFirst(Object target, String ... names) {
        if (target == null) {
            return null;
        }
        for (String n : names) {
            try {
                Method m;
                try {
                    m = target.getClass().getDeclaredMethod(n, new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    m = target.getClass().getMethod(n, new Class[0]);
                }
                m.setAccessible(true);
                return m.invoke(target, new Object[0]);
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }
}

