/*
 * Decompiled with CFR 0.152.
 */
package com.levelscraft7.catchindicator.client;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CatchIndicatorClientConfig {
    public static final String FILE_NAME = "catchindicator-client.cfg";
    public static final String DEFAULT_STYLE = "style_1";
    public static final List<String> SUPPORTED_STYLE_ORDER = List.of("style_1", "style_2", "style_3", "style_4", "style_5", "style_6");
    public static final Set<String> SUPPORTED_STYLES = Set.copyOf(SUPPORTED_STYLE_ORDER);
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"catchindicator");
    private static volatile boolean enabled = true;
    private static volatile String iconStyle = "style_1";
    private static volatile Path configPath;

    private CatchIndicatorClientConfig() {
    }

    public static void load(Path configDir) {
        Path path;
        Objects.requireNonNull(configDir, "configDir");
        configPath = path = configDir.resolve(FILE_NAME);
        boolean needsSave = false;
        HashMap<String, String> data = new HashMap<String, String>();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                for (String line : Files.readAllLines(path, StandardCharsets.UTF_8)) {
                    int idx;
                    String trimmed = line.trim();
                    if (trimmed.isEmpty() || trimmed.startsWith("//") || (idx = trimmed.indexOf(61)) <= 0 || idx == trimmed.length() - 1) continue;
                    String key = trimmed.substring(0, idx).trim();
                    String value = trimmed.substring(idx + 1).trim();
                    if (key.isEmpty()) continue;
                    data.put(key, value);
                }
            }
            catch (IOException e) {
                LOGGER.warn("Failed to read config {}, using defaults.", (Object)path, (Object)e);
                needsSave = true;
            }
        } else {
            needsSave = true;
        }
        boolean loadedEnabled = CatchIndicatorClientConfig.getBoolean(data, "enabled", true);
        String loadedStyle = CatchIndicatorClientConfig.getString(data, "caught_icon_style", DEFAULT_STYLE);
        String normalizedStyle = CatchIndicatorClientConfig.normalizeStyle(loadedStyle);
        if (!SUPPORTED_STYLES.contains(normalizedStyle)) {
            LOGGER.warn("Unsupported icon style '{}'; falling back to {}.", (Object)loadedStyle, (Object)DEFAULT_STYLE);
            normalizedStyle = DEFAULT_STYLE;
            needsSave = true;
        }
        enabled = loadedEnabled;
        iconStyle = normalizedStyle;
        if (needsSave) {
            CatchIndicatorClientConfig.save(path);
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean value) {
        enabled = value;
    }

    public static String getIconStyle() {
        return iconStyle;
    }

    public static void setIconStyle(String style) {
        String normalized = CatchIndicatorClientConfig.normalizeStyle(style);
        if (!SUPPORTED_STYLES.contains(normalized)) {
            LOGGER.warn("Unsupported icon style '{}'; falling back to {}.", (Object)style, (Object)DEFAULT_STYLE);
            iconStyle = DEFAULT_STYLE;
            return;
        }
        iconStyle = normalized;
    }

    public static List<String> getSupportedStyleOrder() {
        return SUPPORTED_STYLE_ORDER;
    }

    public static ResourceLocation getIconFont() {
        return ResourceLocation.parse((String)("catchindicator:" + iconStyle));
    }

    private static String normalizeStyle(String style) {
        if (style == null || style.isBlank()) {
            return DEFAULT_STYLE;
        }
        return style.trim().toLowerCase(Locale.ROOT);
    }

    private static boolean getBoolean(Map<String, String> data, String key, boolean fallback) {
        if (data == null || !data.containsKey(key)) {
            return fallback;
        }
        String raw = data.get(key);
        if (raw == null) {
            return fallback;
        }
        String normalized = raw.trim().toLowerCase(Locale.ROOT);
        if ("true".equals(normalized)) {
            return true;
        }
        if ("false".equals(normalized)) {
            return false;
        }
        return fallback;
    }

    private static String getString(Map<String, String> data, String key, String fallback) {
        if (data == null || !data.containsKey(key)) {
            return fallback;
        }
        String value = data.get(key);
        return value != null ? value : fallback;
    }

    public static void save() {
        if (configPath == null) {
            LOGGER.warn("Config path not initialized; cannot save config.");
            return;
        }
        CatchIndicatorClientConfig.save(configPath);
    }

    private static void save(Path path) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.write("// Catch Indicator client config\n");
                writer.write("// Each setting is a key=value pair.\n");
                writer.write("//\n");
                writer.write("// enabled: true or false\n");
                writer.write("enabled=" + enabled + "\n");
                writer.write("//\n");
                writer.write("// caught_icon_style: choose one of the styles below\n");
                writer.write("// style_1: Classic Pokeball\n");
                writer.write("// style_2: Blue Pokeball\n");
                writer.write("// style_3: Green Pokeball\n");
                writer.write("// style_4: Cherish Ball\n");
                writer.write("// style_5: Luxury Ball\n");
                writer.write("// style_6: Master Ball\n");
                writer.write("caught_icon_style=" + iconStyle + "\n");
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to write config {}.", (Object)path, (Object)e);
        }
    }
}

