/*
 * Decompiled with CFR 0.152.
 */
package chadlymasterson.playerxp;

import chadlymasterson.playerxp.Config;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.battles.BattleVictoryEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonCapturedEvent;
import com.cobblemon.mod.common.api.reactive.ObservableSubscription;
import com.cobblemon.mod.common.battles.actor.PlayerBattleActor;
import com.cobblemon.mod.common.battles.actor.PokemonBattleActor;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="playerxp")
public class PlayerXp {
    public static final String MOD_ID = "playerxp";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"playerxp");
    private static Config config;
    ObservableSubscription<PokemonCapturedEvent> captureEvent = CobblemonEvents.POKEMON_CAPTURED.subscribe(Priority.LOW, event -> {
        ServerPlayer player = event.getPlayer();
        int pkmnLvl = event.getPokemon().getLevel();
        this.handleXP(player, pkmnLvl);
    });
    ObservableSubscription<BattleVictoryEvent> subscription = CobblemonEvents.BATTLE_VICTORY.subscribe(Priority.LOW, event -> {
        List winners = event.getWinners();
        List losers = event.getLosers();
        int loserLevel = 0;
        for (BattleActor actor : losers) {
            if (!(actor instanceof PokemonBattleActor)) continue;
            PokemonBattleActor battleActor = (PokemonBattleActor)actor;
            Pokemon pkmn = battleActor.getPokemon().getOriginalPokemon();
            loserLevel += pkmn.getLevel();
        }
        for (BattleActor actor : winners) {
            if (!(actor instanceof PlayerBattleActor)) continue;
            PlayerBattleActor player = (PlayerBattleActor)actor;
            this.handleXP(player.getEntity(), loserLevel);
        }
        return null;
    });

    public PlayerXp() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        config = PlayerXp.getConfig();
    }

    private void handleXP(ServerPlayer player, int pokemonLevel) {
        if (!config.shouldGiveLevels()) {
            int xp = config.getBaseXP() * (float)pokemonLevel < 1.0f ? 1 : (int)Math.floor(config.getBaseXP() * (float)pokemonLevel);
            this.spawnXPOrbs(player, xp);
        } else {
            int levelsToGive = config.getBaseLevels() * pokemonLevel;
            int currentLevel = player.experienceLevel;
            int targetLevel = currentLevel + levelsToGive;
            int currentTotalXP = this.getExperienceForLevel(currentLevel);
            int targetTotalXP = this.getExperienceForLevel(targetLevel);
            int xpToGive = targetTotalXP - currentTotalXP;
            this.spawnXPOrbs(player, xpToGive);
        }
    }

    public int getExperienceForLevel(int level) {
        if (level <= 16) {
            return level * level + 6 * level;
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }

    private void spawnXPOrbs(ServerPlayer player, int xpAmount) {
        ServerLevel level = player.serverLevel();
        BlockPos pos = player.getOnPos();
        ExperienceOrb orb = new ExperienceOrb((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), xpAmount);
        level.addFreshEntity((Entity)orb);
    }

    public static Config getConfig() {
        if (config == null) {
            config = new Config("playerxp.json");
            config.load();
        }
        return config;
    }
}

