/*
 * Decompiled with CFR 0.152.
 */
package chadlymasterson.playerxp;

import chadlymasterson.playerxp.PlayerXp;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import net.neoforged.fml.loading.FMLPaths;

public class Config {
    public static final Path CONFIG_PATH = FMLPaths.CONFIGDIR.get().resolve("playerxp");
    private static File CONFIG_FILE;
    private boolean shouldGiveLevels = false;
    private float baseXP = 5.0f;
    private int baseLevels = 1;
    public static final Gson GSON;

    public Config(String filename) {
        CONFIG_FILE = new File(String.valueOf(CONFIG_PATH) + "/playerxp", filename);
        this.load();
    }

    public void load() {
        if (!CONFIG_FILE.exists()) {
            this.save();
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            Config loaded = (Config)GSON.fromJson((Reader)reader, Config.class);
            this.shouldGiveLevels = loaded.shouldGiveLevels;
            this.baseXP = loaded.baseXP;
            this.baseLevels = loaded.baseLevels;
        }
        catch (IOException e) {
            PlayerXp.LOGGER.error("Failed to load config: " + e.getMessage());
        }
    }

    public void save() {
        CONFIG_FILE.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            PlayerXp.LOGGER.error("Failed to save config: " + e.getMessage());
        }
    }

    public int getBaseLevels() {
        return this.baseLevels;
    }

    public float getBaseXP() {
        return this.baseXP;
    }

    public boolean shouldGiveLevels() {
        return this.shouldGiveLevels;
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setLenient().create();
    }
}

