/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.enchlevellangpatch.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xland.mcmod.enchlevellangpatch.impl.ChineseExchange;
import xland.mcmod.enchlevellangpatch.impl.ValueTableHolder;

public final class NumberFormatUtil {
    private NumberFormatUtil() {
    }

    static boolean isDigit(@NotNull CharSequence s, int offset) {
        int li = s.length() - 1;
        if (li < offset) {
            return false;
        }
        char c2 = s.charAt(offset);
        if (c2 == '0') {
            return li == offset;
        }
        for (int idx = li; idx >= offset; --idx) {
            c2 = s.charAt(idx);
            if (c2 >= '0' && c2 <= '9') continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static String intToRoman(int num) {
        if (num <= 0 || num >= 3999) {
            return null;
        }
        return ValueTableHolder.ROMAN[num];
    }

    @NotNull
    static String intToRomanImpl(int i, int type) {
        if (i < 0) {
            return Integer.toString(i);
        }
        if (type >= 0) {
            return ChineseExchange.numberToChinese(i, type);
        }
        String ret = NumberFormatUtil.intToRoman(i);
        return ret == null ? Integer.toString(i) : ret;
    }
}

