/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.enchlevellangpatch.impl;

import com.google.common.base.Preconditions;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class NamespacedKey
implements Comparable<NamespacedKey> {
    private static final Pattern NS_PATTERN = Pattern.compile("^[a-z0-9\\u002e\\u002d_]+$");
    private static final Pattern PATH_PATTERN = Pattern.compile("^[a-z0-9\\u002e\\u002d_/]+$");
    private final String namespace;
    private final String path;
    private String toString;

    public NamespacedKey(String namespace, String path) {
        Preconditions.checkArgument((boolean)NS_PATTERN.matcher(namespace).matches(), (Object)("Illegal namespace: " + namespace));
        Preconditions.checkArgument((boolean)PATH_PATTERN.matcher(path).matches(), (Object)("Illegal path" + path));
        this.namespace = namespace;
        this.path = path;
    }

    public static NamespacedKey of(String s) {
        int i = s.indexOf(58);
        if (i < 0) {
            return new NamespacedKey("minecraft", s);
        }
        return new NamespacedKey(s.substring(0, i), s.substring(i + 1));
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = this.namespace + ':' + this.path;
        }
        return this.toString;
    }

    @Override
    public int compareTo(NamespacedKey key) {
        int i = this.path.compareTo(key.path);
        if (i == 0) {
            i = this.namespace.compareTo(key.namespace);
        }
        return i;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NamespacedKey)) {
            return false;
        }
        NamespacedKey key = (NamespacedKey)o;
        return this.namespace.equals(key.namespace) && this.path.equals(key.path);
    }

    public int hashCode() {
        return 31 * this.namespace.hashCode() + this.path.hashCode();
    }
}

