/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.enchlevellangpatch.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;
import org.jetbrains.annotations.VisibleForTesting;
import xland.mcmod.enchlevellangpatch.impl.NumResultCacheMap;
import xland.mcmod.enchlevellangpatch.impl.ValueTableHolder;

@VisibleForTesting
public final class ChineseExchange {
    private final NumResultCacheMap cacheMap = new NumResultCacheMap();
    private final String[] pos;
    private final char[] num;
    private final String[] sec;
    private final char zeroC;
    private final String zeroS;
    private final String tenOne;
    static final int NORMAL = 0;
    static final int UPPER = 1;

    ChineseExchange(String[] pos, char[] num, String[] sec, String zeroS, String tenOne) {
        this.pos = pos;
        this.num = num;
        this.sec = sec;
        this.zeroC = num[0];
        this.zeroS = zeroS;
        this.tenOne = tenOne;
    }

    @VisibleForTesting
    @NotNull
    public static String numberToChinese(@Range(from=0L, to=0x7FFFFFFFL) int num, int type) {
        if (num < 256) {
            return ValueTableHolder.CHINESE[type][num];
        }
        return Lazy.EXCHANGES[type].numberToChinese(num);
    }

    @VisibleForTesting
    public static String numberToChineseCacheless(int num, int type) {
        return Lazy.EXCHANGES[type].numberToChinese0(num);
    }

    String numberToChinese(int num) {
        return this.cacheMap.computeIfAbsent(num, this::numberToChinese0);
    }

    @NotNull
    private String numberToChinese0(int num) {
        if (num == 0) {
            return this.zeroS;
        }
        int sectionPosition = 0;
        StringBuilder ret = new StringBuilder();
        while (num > 0) {
            int section = num % 10000;
            if (section != 0) {
                ret.append(this.sec[sectionPosition]);
            }
            this.eachSection(section, ret);
            num /= 10000;
            ++sectionPosition;
        }
        int i = ret.length() - 1;
        if (this.zeroC == ret.charAt(i)) {
            ret.setLength(i);
        }
        if ((i = ret.length() - 2) < 0) {
            return ret.toString();
        }
        if (this.tenOne.equals(ret.substring(i))) {
            ret.setLength(i + 1);
        }
        return ret.reverse().toString();
    }

    private void eachSection(int num, StringBuilder ret) {
        boolean zero = true;
        for (int i = 0; i < 4; ++i) {
            int end = num % 10;
            if (end == 0) {
                if (!zero) {
                    zero = true;
                    ret.append(this.zeroC);
                }
            } else {
                zero = false;
                ret.append(this.pos[i]).append(this.num[end]);
            }
            num /= 10;
        }
    }

    private static final class Lazy {
        static final ChineseExchange[] EXCHANGES = new ChineseExchange[]{new ChineseExchange(new String[]{"", "\u5341", "\u767e", "\u5343"}, "\u96f6\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d".toCharArray(), new String[]{"", "\u4e07", "\u4ebf", "\u4e07\u4ebf"}, "\u96f6", "\u5341\u4e00"), new ChineseExchange(new String[]{"", "\u62fe", "\u4f70", "\u4edf"}, "\u96f6\u58f9\u8cb3\u53c4\u8086\u4f0d\u9678\u67d2\u634c\u7396".toCharArray(), new String[]{"", "\u842c", "\u5104", "\u5146"}, "\u96f6", "\u62fe\u58f9")};

        private Lazy() {
        }
    }
}

