/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.enchlevellangpatch.api;

import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import org.jetbrains.annotations.Unmodifiable;
import xland.mcmod.enchlevellangpatch.impl.LangPatchImpl;
import xland.mcmod.enchlevellangpatch.impl.NamespacedKey;
import xland.mcmod.enchlevellangpatch.impl.NumberFormatUtil;

@API(status=API.Status.STABLE)
@FunctionalInterface
public interface EnchantmentLevelLangPatch {
    public static void registerPatch(@NotNull Predicate<String> keyPredicate, @NotNull EnchantmentLevelLangPatch edition) {
        LangPatchImpl.register(Objects.requireNonNull(keyPredicate), Objects.requireNonNull(edition));
    }

    @Nullable
    public static String intToRoman(@Range(from=1L, to=3998L) int num) {
        return NumberFormatUtil.intToRoman(num);
    }

    public static void registerEnchantmentPatch(@NotNull @Pattern(value="^([0-9a-z_\\-]+:)?[0-9a-z_\\-/]+$") String id, @NotNull EnchantmentLevelLangPatch edition) {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(edition, "patch");
        LangPatchImpl.hookEnchantmentPatch(NamespacedKey.of(id), edition);
    }

    public static void registerPotionPatch(@NotNull @Pattern(value="^([0-9a-z_\\-]+:)?[0-9a-z_\\-/]+$") String id, @NotNull EnchantmentLevelLangPatch edition) {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(edition, "patch");
        LangPatchImpl.hookPotionPatch(NamespacedKey.of(id), edition);
    }

    @Nullable
    public String apply(@Unmodifiable Map<String, String> var1, String var2);

    @Nullable
    default public String apply(@Unmodifiable Map<String, String> translationStorage, String key, String fallback) {
        return this.apply(translationStorage, key);
    }

    @Contract(pure=true, value="_ -> param1")
    public static EnchantmentLevelLangPatch withFallback(WithFallback patch) {
        return patch;
    }

    @FunctionalInterface
    public static interface WithFallback
    extends EnchantmentLevelLangPatch {
        @Override
        @Nullable
        default public String apply(@Unmodifiable Map<String, String> translationStorage, String key) {
            return null;
        }

        @Override
        @Nullable
        public String apply(@Unmodifiable Map<String, String> var1, String var2, String var3);
    }
}

