/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.connector.base;

import com.mrh0.createaddition.blocks.connector.base.AbstractConnectorBlock;
import com.mrh0.createaddition.blocks.connector.base.ConnectorMode;
import com.mrh0.createaddition.config.CommonConfig;
import com.mrh0.createaddition.debug.IDebugDrawer;
import com.mrh0.createaddition.energy.IEnergyProvider;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.LocalNode;
import com.mrh0.createaddition.energy.NodeRotation;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.energy.network.EnergyNetwork;
import com.mrh0.createaddition.index.CALang;
import com.mrh0.createaddition.network.EnergyNetworkPacketPayload;
import com.mrh0.createaddition.network.IObserveBlockEntity;
import com.mrh0.createaddition.network.ObservePacketPayload;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.createmod.catnip.outliner.Outliner;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConnectorBlockEntity
extends SmartBlockEntity
implements IWireNode,
IObserveBlockEntity,
IHaveGoggleInformation,
IDebugDrawer,
IEnergyProvider {
    private final Set<LocalNode> wireCache = new HashSet<LocalNode>();
    private final LocalNode[] localNodes;
    private final IWireNode[] nodeCache;
    private EnergyNetwork network;
    private int demand = 0;
    private boolean wasContraption = false;
    private boolean firstTick = true;
    public InterfaceEnergyHandler internal = new InterfaceEnergyHandler();
    protected BlockCapabilityCache<IEnergyStorage, Direction> external;
    boolean externalStorageInvalid = false;

    public AbstractConnectorBlockEntity(BlockEntityType<?> blockEntityTypeIn, BlockPos pos, BlockState state) {
        super(blockEntityTypeIn, pos, state);
        this.localNodes = new LocalNode[this.getNodeCount()];
        this.nodeCache = new IWireNode[this.getNodeCount()];
    }

    @Override
    @Nullable
    public IEnergyStorage getEnergyStorage(@Nullable Direction direction) {
        if (this.isEnergyInput(direction) || this.isEnergyOutput(direction)) {
            return this.internal;
        }
        return null;
    }

    public abstract int getMaxIn();

    public abstract int getMaxOut();

    public int getCapacity() {
        return Math.min(this.getMaxIn(), this.getMaxOut());
    }

    @Override
    @Nullable
    public IWireNode getWireNode(int index) {
        return IWireNode.getWireNodeFrom(index, this, this.localNodes, this.nodeCache, this.level);
    }

    @Override
    @Nullable
    public LocalNode getLocalNode(int index) {
        return this.localNodes[index];
    }

    @Override
    public void setNode(int index, int other, BlockPos pos, WireType type) {
        this.localNodes[index] = new LocalNode((BlockEntity)this, index, other, type, pos);
        this.notifyUpdate();
        if (this.network != null) {
            this.network.invalidate();
        }
    }

    @Override
    public void removeNode(int index, boolean dropWire) {
        LocalNode old = this.localNodes[index];
        this.localNodes[index] = null;
        this.nodeCache[index] = null;
        this.invalidateNodeCache();
        this.notifyUpdate();
        if (this.network != null) {
            this.network.invalidate();
        }
        if (dropWire && old != null) {
            this.wireCache.add(old);
        }
    }

    @Override
    public BlockPos getPos() {
        return this.getBlockPos();
    }

    @Override
    public void setNetwork(int node, EnergyNetwork network) {
        this.network = network;
    }

    @Override
    public EnergyNetwork getNetwork(int node) {
        return this.network;
    }

    public boolean isEnergyInput(Direction side) {
        return this.getBlockState().getValue((Property)AbstractConnectorBlock.FACING) == side;
    }

    public boolean isEnergyOutput(Direction side) {
        return this.getBlockState().getValue((Property)AbstractConnectorBlock.FACING) == side;
    }

    public void read(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(nbt, registries, clientPacket);
        if (!clientPacket && nbt.contains("node0")) {
            this.convertOldNbt(nbt);
            this.setChanged();
        }
        this.invalidateLocalNodes();
        this.invalidateNodeCache();
        ListTag nodes = nbt.getList("nodes", 10);
        nodes.forEach(tag -> {
            LocalNode localNode;
            this.localNodes[localNode.getIndex()] = localNode = new LocalNode((BlockEntity)this, (CompoundTag)tag);
        });
        if (nbt.contains("contraption") && !clientPacket) {
            this.wasContraption = nbt.getBoolean("contraption");
            NodeRotation rotation = (NodeRotation)((Object)this.getBlockState().getValue(NodeRotation.ROTATION));
            if (this.level == null) {
                return;
            }
            if (rotation != NodeRotation.NONE) {
                this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue(NodeRotation.ROTATION, (Comparable)((Object)NodeRotation.NONE)), 0);
            }
            for (LocalNode localNode : this.localNodes) {
                if (localNode == null) continue;
                localNode.updateRelative(rotation);
            }
        }
        if (!nodes.isEmpty() && this.network != null) {
            this.network.invalidate();
        }
    }

    public void write(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(nbt, registries, clientPacket);
        ListTag nodes = new ListTag();
        for (int i = 0; i < this.getNodeCount(); ++i) {
            LocalNode localNode = this.localNodes[i];
            if (localNode == null) continue;
            CompoundTag tag = new CompoundTag();
            localNode.write(tag);
            nodes.add((Object)tag);
        }
        nbt.put("nodes", (Tag)nodes);
    }

    private void validateNodes() {
        boolean changed = this.validateLocalNodes(this.localNodes);
        this.notifyUpdate();
        if (changed) {
            this.invalidateNodeCache();
            if (this.network != null) {
                this.network.invalidate();
            }
        }
    }

    public void firstTick() {
        this.firstTick = false;
        if (this.level == null) {
            return;
        }
        if (this.wasContraption && !this.level.isClientSide()) {
            this.wasContraption = false;
            this.validateNodes();
        }
        this.updateExternalEnergyStorage();
    }

    protected void specialTick() {
    }

    public void tick() {
        if (this.firstTick) {
            this.firstTick();
        }
        if (this.level == null) {
            return;
        }
        if (!this.level.isLoaded(this.getBlockPos())) {
            return;
        }
        if (!this.wireCache.isEmpty() && !this.isRemoved()) {
            this.handleWireCache(this.level, this.wireCache);
        }
        this.specialTick();
        if (this.getMode() == ConnectorMode.None) {
            return;
        }
        super.tick();
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        if (this.awakeNetwork(this.level)) {
            this.notifyUpdate();
        }
        this.networkTick(this.network);
        if (this.externalStorageInvalid) {
            this.updateExternalEnergyStorage();
        }
    }

    private void networkTick(EnergyNetwork network) {
        ConnectorMode mode = this.getMode();
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        IEnergyStorage otherStorage = (IEnergyStorage)this.external.getCapability();
        if (otherStorage == null) {
            return;
        }
        if (mode == ConnectorMode.Push) {
            int pulled = network.pull(network.demand(otherStorage.receiveEnergy(this.getMaxOut(), true)));
            otherStorage.receiveEnergy(pulled, false);
        }
        if (mode == ConnectorMode.Pull) {
            int toPush = otherStorage.extractEnergy(network.push(this.getMaxIn(), true), false);
            network.push(toPush);
        }
    }

    public void remove() {
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        for (int i = 0; i < this.getNodeCount(); ++i) {
            IWireNode otherNode;
            LocalNode localNode = this.getLocalNode(i);
            if (localNode == null || (otherNode = this.getWireNode(i)) == null) continue;
            int ourNode = localNode.getOtherIndex();
            if (localNode.isInvalid()) {
                otherNode.removeNode(ourNode);
                continue;
            }
            otherNode.removeNode(ourNode, true);
        }
        this.invalidateNodeCache();
        if (this.network != null) {
            this.network.invalidate();
        }
    }

    public void invalidateLocalNodes() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.localNodes[i] = null;
        }
    }

    @Override
    public void invalidateNodeCache() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.nodeCache[i] = null;
        }
    }

    public ConnectorMode getMode() {
        return (ConnectorMode)((Object)this.getBlockState().getValue(AbstractConnectorBlock.MODE));
    }

    @Override
    public void onObserved(ServerPlayer player, ObservePacketPayload pack) {
        if (this.isNetworkValid(0)) {
            EnergyNetworkPacketPayload.send(this.worldPosition, this.getNetwork(0).getPulled(), this.getNetwork(0).getPushed(), player);
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        ObservePacketPayload.send(this.worldPosition, 0);
        String spacing = " ";
        CALang.builder().add(Component.translatable((String)"createaddition.tooltip.connector.info").withStyle(ChatFormatting.WHITE)).forGoggles(tooltip);
        CALang.builder().add(Component.translatable((String)"createaddition.tooltip.energy.mode").withStyle(ChatFormatting.GRAY)).forGoggles(tooltip);
        CALang.builder().add(Component.literal((String)" ").append((Component)((ConnectorMode)((Object)this.getBlockState().getValue(AbstractConnectorBlock.MODE))).getTooltip().withStyle(ChatFormatting.AQUA))).forGoggles(tooltip);
        CALang.builder().add(Component.translatable((String)"createaddition.tooltip.energy.usage").withStyle(ChatFormatting.GRAY)).forGoggles(tooltip);
        CALang.builder().add(Component.literal((String)" ").append(Util.format(EnergyNetworkPacketPayload.clientBuff)).append("\u26a1/t").withStyle(ChatFormatting.AQUA)).forGoggles(tooltip);
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    public boolean ignoreCapSide() {
        return ((ConnectorMode)((Object)this.getBlockState().getValue(AbstractConnectorBlock.MODE))).isActive();
    }

    public void updateExternalEnergyStorage() {
        if (this.level == null) {
            return;
        }
        if (!(this.level instanceof ServerLevel)) {
            return;
        }
        if (!this.level.isLoaded(this.getBlockPos())) {
            return;
        }
        Direction side = (Direction)this.getBlockState().getValue((Property)AbstractConnectorBlock.FACING);
        if (!this.level.isLoaded(this.getBlockPos().relative(side))) {
            return;
        }
        this.externalStorageInvalid = false;
        this.external = BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)((ServerLevel)this.level), (BlockPos)this.getPos().relative(side), (Object)side.getOpposite(), () -> !this.isRemoved(), () -> {
            this.externalStorageInvalid = true;
        });
    }

    @Override
    public void drawDebug() {
        if (this.level == null) {
            return;
        }
        for (int i = 0; i < this.getNodeCount(); ++i) {
            LocalNode localNode = this.localNodes[i];
            if (localNode == null) continue;
            BlockPos pos = localNode.getPos();
            BlockState state = this.level.getBlockState(pos);
            VoxelShape shape = state.getBlockSupportShape((BlockGetter)this.level, pos);
            int color = i == 0 ? 0xFF0000 : (i == 1 ? 65280 : (i == 2 ? 255 : 0xFFFFFF));
            if (!(this.level.getBlockEntity(pos) instanceof IWireNode)) {
                shape = Shapes.block();
                color = 0xFF00FF;
            }
            Outliner.getInstance().chaseAABB((Object)("ca_nodes_" + i), shape.bounds().move(pos)).lineWidth(0.0625f).colored(color);
        }
        BlockPos pos = this.worldPosition.relative((Direction)this.getBlockState().getValue((Property)AbstractConnectorBlock.FACING));
        IEnergyStorage cap = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, pos, (Object)((Direction)this.getBlockState().getValue((Property)AbstractConnectorBlock.FACING)).getOpposite());
        if (cap == null) {
            return;
        }
        VoxelShape shape = this.level.getBlockState(pos).getBlockSupportShape((BlockGetter)this.level, pos);
        Outliner.getInstance().chaseAABB((Object)"ca_output", shape.bounds().move(pos)).lineWidth(0.0625f).colored(0x5B5BFF);
    }

    private class InterfaceEnergyHandler
    implements IEnergyStorage {
        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!((Boolean)CommonConfig.CONNECTOR_ALLOW_PASSIVE_IO.get()).booleanValue()) {
                return 0;
            }
            if (AbstractConnectorBlockEntity.this.getMode() != ConnectorMode.Pull) {
                return 0;
            }
            if (AbstractConnectorBlockEntity.this.network == null) {
                return 0;
            }
            maxReceive = Math.min(maxReceive, AbstractConnectorBlockEntity.this.getMaxIn());
            return AbstractConnectorBlockEntity.this.network.push(maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (!((Boolean)CommonConfig.CONNECTOR_ALLOW_PASSIVE_IO.get()).booleanValue()) {
                return 0;
            }
            if (AbstractConnectorBlockEntity.this.getMode() != ConnectorMode.Push) {
                return 0;
            }
            if (AbstractConnectorBlockEntity.this.network == null) {
                return 0;
            }
            maxExtract = Math.min(maxExtract, AbstractConnectorBlockEntity.this.getMaxOut());
            return AbstractConnectorBlockEntity.this.network.pull(maxExtract, simulate);
        }

        public int getEnergyStored() {
            if (AbstractConnectorBlockEntity.this.network == null) {
                return 0;
            }
            return Math.min(AbstractConnectorBlockEntity.this.getCapacity(), AbstractConnectorBlockEntity.this.network.getBuff());
        }

        public int getMaxEnergyStored() {
            return AbstractConnectorBlockEntity.this.getCapacity();
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

