/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.alternator;

import com.mrh0.createaddition.config.CommonConfig;
import com.mrh0.createaddition.energy.IEnergyProvider;
import com.mrh0.createaddition.energy.InternalEnergyStorage;
import com.mrh0.createaddition.index.CABlockEntities;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.index.CALang;
import com.mrh0.createaddition.sound.CASoundScapes;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class AlternatorBlockEntity
extends KineticBlockEntity
implements IEnergyProvider {
    protected final InternalEnergyStorage energy;
    private final IEnergyStorage capability;
    private final EnumSet<Direction> invalidSides = EnumSet.allOf(Direction.class);
    private final EnumMap<Direction, BlockCapabilityCache<IEnergyStorage, Direction>> cache = new EnumMap(Direction.class);
    private boolean firstTickState = true;

    public AlternatorBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.energy = new InternalEnergyStorage((Integer)CommonConfig.ALTERNATOR_CAPACITY.get(), 0, (Integer)CommonConfig.ALTERNATOR_MAX_OUTPUT.get());
        this.capability = this.energy;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)CABlockEntities.ALTERNATOR.get(), (be, context) -> be.capability);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        CALang.builder().add(Component.translatable((String)"createaddition.tooltip.energy.production").withStyle(ChatFormatting.GRAY)).forGoggles(tooltip);
        CALang.builder().add(Component.literal((String)(" " + Util.format(AlternatorBlockEntity.getEnergyProductionRate((int)(this.isSpeedRequirementFulfilled() ? this.getSpeed() : 0.0f))) + "\u26a1/t ")).withStyle(ChatFormatting.AQUA).append((Component)CreateLang.translateDirect((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).withStyle(ChatFormatting.DARK_GRAY))).forGoggles(tooltip);
        return true;
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)((Integer)CommonConfig.MAX_STRESS.get()).intValue() / 256.0f;
        return impact;
    }

    public boolean isEnergyInput(Direction side) {
        return false;
    }

    public boolean isEnergyOutput(Direction side) {
        return true;
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.energy.read(tag);
    }

    public void writeSafe(CompoundTag tag, HolderLookup.Provider registries) {
        super.writeSafe(tag, registries);
        this.energy.write(tag);
    }

    public void tick() {
        super.tick();
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        if (this.firstTickState) {
            this.firstTick();
        }
        this.firstTickState = false;
        if (Math.abs(this.getSpeed()) > 0.0f && this.isSpeedRequirementFulfilled()) {
            this.energy.internalProduceEnergy(AlternatorBlockEntity.getEnergyProductionRate((int)this.getSpeed()));
        }
        for (Direction d : Direction.values()) {
            IEnergyStorage ies;
            if (!this.isEnergyOutput(d) || (ies = (IEnergyStorage)this.cache.get(d).getCapability()) == null) continue;
            int ext = this.energy.extractEnergy(ies.receiveEnergy(((Integer)CommonConfig.ALTERNATOR_MAX_OUTPUT.get()).intValue(), true), false);
            ies.receiveEnergy(ext, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        float componentSpeed = Math.abs(this.getSpeed());
        if (componentSpeed == 0.0f || !this.isSpeedRequirementFulfilled()) {
            return;
        }
        float pitch = Mth.clamp((float)(componentSpeed / 256.0f + 0.5f), (float)0.5f, (float)1.5f);
        if (((Boolean)CommonConfig.AUDIO_ENABLED.get()).booleanValue()) {
            CASoundScapes.play(CASoundScapes.AmbienceGroup.DYNAMO, this.worldPosition, pitch);
        }
    }

    public static int getEnergyProductionRate(int rpm) {
        rpm = Math.abs(rpm);
        return (int)((double)((Integer)CommonConfig.FE_RPM.get()).intValue() * ((double)Math.abs(rpm) / 256.0) * (Double)CommonConfig.ALTERNATOR_EFFICIENCY.get());
    }

    protected Block getStressConfigKey() {
        return (Block)CABlocks.ALTERNATOR.get();
    }

    public void firstTick() {
        this.updateCache();
    }

    public void updateCache() {
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        for (Direction side : Direction.values()) {
            this.cache.put(side, (BlockCapabilityCache<IEnergyStorage, Direction>)BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)((ServerLevel)this.level), (BlockPos)this.getBlockPos().relative(side), (Object)side.getOpposite(), () -> !this.isRemoved(), () -> this.invalidSides.add(side)));
        }
    }

    @Override
    public IEnergyStorage getEnergyStorage(@Nullable Direction direction) {
        return this.energy;
    }
}

