/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.utils;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.animation.PlayPosableAnimationPacket;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.configs.FormChangeConfig;
import com.github.d0ctorleon.mythsandlegends.utils.FusionTransformation;
import com.github.d0ctorleon.mythsandlegends.utils.HeldItemTransformation;
import com.github.d0ctorleon.mythsandlegends.utils.InteractionTransformation;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kotlin.Unit;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class TransformationHelper {
    private static final String NBT_KEY_STORED_POKEMON = "MythsStoredFusionPokemon";
    private static final String NBT_KEY_IS_FUSED = "MythsIsFused";
    private static final String NBT_KEY_FUSION_PARTNER_SPECIES = "MythsFusionPartnerSpecies";
    private static final String NBT_KEY_FUSION_RULE_FORM = "MythsFusionRuleForm";
    private static final String NBT_KEY_IS_TRADABLE = "MythsIsTradable";

    public static boolean tryApplyHeldItemChange(Pokemon pokemon, ItemStack newStack, HeldItemTransformation rule) {
        if (rule.item == null) {
            MythsAndLegends.getLogger().warn("Invalid item ID in heldItemChanges rule for {}: {}", (Object)rule.pokemon, (Object)rule.item);
            return false;
        }
        Item requiredItem = (Item)BuiltInRegistries.ITEM.get(rule.item);
        if (newStack.is(requiredItem)) {
            TransformationHelper.applyFormChange(pokemon, rule.targetForm, rule.playAnimation, rule.isTradable, success -> {});
            return true;
        }
        return false;
    }

    public static boolean tryRevertHeldItemChange(Pokemon pokemon, ItemStack oldStack, HeldItemTransformation rule) {
        if (rule.item == null) {
            return false;
        }
        Item requiredItem = (Item)BuiltInRegistries.ITEM.get(rule.item);
        Species species = pokemon.getSpecies();
        if (species != null && oldStack.is(requiredItem) && pokemon.getForm().getName().equalsIgnoreCase(rule.targetForm)) {
            TransformationHelper.applyFormChange(pokemon, species.getStandardForm().getName(), rule.playAnimation, true, success -> {});
            return true;
        }
        return false;
    }

    public static boolean tryApplyInteractionChange(ServerPlayer player, Pokemon pokemon, ItemStack heldStack, InteractionTransformation rule) {
        if (rule.item == null) {
            MythsAndLegends.getLogger().warn("Invalid item ID in interactionChanges rule for {}: {}", (Object)rule.pokemon, (Object)rule.item);
            return false;
        }
        Item requiredItem = (Item)BuiltInRegistries.ITEM.get(rule.item);
        Species species = pokemon.getSpecies();
        if (species != null && heldStack.is(requiredItem)) {
            if (pokemon.getForm().getName().equalsIgnoreCase(rule.targetForm)) {
                TransformationHelper.applyFormChange(pokemon, species.getStandardForm().getName(), rule.playAnimation, true, success -> {});
            } else {
                TransformationHelper.applyFormChange(pokemon, rule.targetForm, rule.playAnimation, rule.isTradable, success -> {});
            }
            return true;
        }
        return false;
    }

    public static boolean tryApplyFusionOrUnfusion(ServerPlayer player, Pokemon targetPokemon, ItemStack heldStack, FusionTransformation rule, InteractionHand hand) {
        if (rule.item == null) {
            MythsAndLegends.getLogger().warn("Invalid item ID in fusions rule for {}: {}", (Object)rule.basePokemon, (Object)rule.item);
            return false;
        }
        Item requiredItem = (Item)BuiltInRegistries.ITEM.get(rule.item);
        if (!heldStack.is(requiredItem)) {
            return false;
        }
        CompoundTag persistentData = targetPokemon.getPersistentData();
        boolean isCurrentlyFused = persistentData.getBoolean(NBT_KEY_IS_FUSED);
        String storedPartnerSpecies = persistentData.getString(NBT_KEY_FUSION_PARTNER_SPECIES);
        String storedFusionForm = persistentData.getString(NBT_KEY_FUSION_RULE_FORM);
        if (isCurrentlyFused) {
            if (storedPartnerSpecies.equalsIgnoreCase(rule.partnerPokemon) && storedFusionForm.equalsIgnoreCase(rule.resultingForm)) {
                MythsAndLegends.getLogger().debug("Attempting unfusion for {} based on rule for partner {}", (Object)targetPokemon.getSpecies().getName(), (Object)rule.partnerPokemon);
                return TransformationHelper.unfusePokemon(player, targetPokemon, rule);
            }
            MythsAndLegends.getLogger().debug("Unfusion item used, but current fusion state (Partner: {}, Form: {}) doesn't match this rule (Partner: {}, Form: {}).", (Object)storedPartnerSpecies, (Object)storedFusionForm, (Object)rule.partnerPokemon, (Object)rule.resultingForm);
            return false;
        }
        targetPokemon.getSpecies().getForms().stream().filter(form -> form.getName().equalsIgnoreCase("mega")).findFirst().orElse(null);
        if (!targetPokemon.getForm().equals((Object)targetPokemon.getSpecies().getStandardForm())) {
            MythsAndLegends.getLogger().debug("Cannot fuse: {} is not in its standard form.", (Object)targetPokemon.getDisplayName(true).getString());
            player.displayClientMessage((Component)Component.translatable((String)"mythsandlegends.fusion.must_be_standard_form", (Object[])new Object[]{targetPokemon.getDisplayName(true)}), false);
            return false;
        }
        MythsAndLegends.getLogger().debug("Attempting fusion for {} with partner {}", (Object)targetPokemon.getSpecies().getName(), (Object)rule.partnerPokemon);
        return TransformationHelper.fusePokemon(player, targetPokemon, rule);
    }

    private static boolean fusePokemon(ServerPlayer player, Pokemon basePokemon, FusionTransformation rule) {
        PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
        Pokemon partnerPokemon = null;
        for (Pokemon partyPokemon : playerPartyStore) {
            if (!partyPokemon.getSpecies().getName().equalsIgnoreCase(rule.partnerPokemon) || !partyPokemon.getForm().equals((Object)partyPokemon.getSpecies().getStandardForm())) continue;
            partnerPokemon = partyPokemon;
            break;
        }
        if (partnerPokemon == null) {
            MythsAndLegends.getLogger().debug("Fusion partner {} (in standard form) not found in party.", (Object)rule.partnerPokemon);
            player.displayClientMessage((Component)Component.translatable((String)"mythsandlegends.fusion.partner_missing", (Object[])new Object[]{rule.partnerPokemon}), false);
            return false;
        }
        RegistryAccess registryAccess = player.serverLevel().registryAccess();
        CompoundTag partnerNbt = partnerPokemon.saveToNBT(registryAccess, new CompoundTag());
        CompoundTag persistentData = basePokemon.getPersistentData();
        persistentData.put(NBT_KEY_STORED_POKEMON, (Tag)partnerNbt);
        persistentData.putBoolean(NBT_KEY_IS_FUSED, true);
        persistentData.putString(NBT_KEY_FUSION_PARTNER_SPECIES, rule.partnerPokemon);
        persistentData.putString(NBT_KEY_FUSION_RULE_FORM, rule.resultingForm);
        boolean removed = playerPartyStore.remove(partnerPokemon);
        if (!removed) {
            MythsAndLegends.getLogger().error("Critical error: Failed to remove fusion partner {} from party after NBT was stored!", (Object)rule.partnerPokemon);
            persistentData.remove(NBT_KEY_STORED_POKEMON);
            persistentData.remove(NBT_KEY_IS_FUSED);
            persistentData.remove(NBT_KEY_FUSION_PARTNER_SPECIES);
            persistentData.remove(NBT_KEY_FUSION_RULE_FORM);
            player.displayClientMessage((Component)Component.translatable((String)"mythsandlegends.fusion.error.remove_failed"), true);
            return false;
        }
        MythsAndLegends.getLogger().info("Stored {} NBT and removed from party. Applying fusion form {} to {}.", (Object)rule.partnerPokemon, (Object)rule.resultingForm, (Object)basePokemon.getSpecies().getName());
        Pokemon finalPartnerPokemon = partnerPokemon;
        TransformationHelper.applyFormChange(basePokemon, rule.resultingForm, rule.playAnimation, rule.isTradable, success -> {
            if (success.booleanValue()) {
                MythsAndLegends.getLogger().info("Fusion form change successful for {}.", (Object)basePokemon.getSpecies().getName());
                player.displayClientMessage((Component)Component.translatable((String)"mythsandlegends.fusion.success", (Object[])new Object[]{basePokemon.getDisplayName(true), finalPartnerPokemon.getDisplayName(true)}), false);
            } else {
                MythsAndLegends.getLogger().error("Fusion form change failed for {} to {}! Attempting to revert state.", (Object)basePokemon.getSpecies().getName(), (Object)rule.resultingForm);
                boolean addedBack = playerPartyStore.add(finalPartnerPokemon);
                if (!addedBack) {
                    MythsAndLegends.getLogger().error("Rollback failed: Could not add partner {} back to party!", (Object)finalPartnerPokemon.getSpecies().getName());
                }
                persistentData.remove(NBT_KEY_STORED_POKEMON);
                persistentData.remove(NBT_KEY_IS_FUSED);
                persistentData.remove(NBT_KEY_FUSION_PARTNER_SPECIES);
                persistentData.remove(NBT_KEY_FUSION_RULE_FORM);
                TransformationHelper.clearTradableNBT(basePokemon);
                TransformationHelper.applyFormChange(basePokemon, basePokemon.getSpecies().getStandardForm().getName(), false, true, revertSuccess -> {
                    if (!revertSuccess.booleanValue()) {
                        MythsAndLegends.getLogger().error("Rollback failed: Could not revert base Pokemon {} to standard form!", (Object)basePokemon.getSpecies().getName());
                    }
                });
                player.displayClientMessage((Component)Component.translatable((String)"mythsandlegends.fusion.error.form_change_failed"), true);
            }
        });
        return true;
    }

    private static boolean unfusePokemon(ServerPlayer player, Pokemon basePokemon, FusionTransformation rule) {
        CompoundTag partnerNbt;
        CompoundTag persistentData = basePokemon.getPersistentData();
        if (!persistentData.contains(NBT_KEY_STORED_POKEMON)) {
            MythsAndLegends.getLogger().warn("Attempted to unfuse {}, but no stored Pokemon NBT found. Clearing fusion tags.", (Object)basePokemon.getSpecies().getName());
            TransformationHelper.clearFusionTagsAndRevert(basePokemon, rule.playAnimation);
            player.displayClientMessage((Component)Component.translatable((String)"mythsandlegends.unfusion.error.no_data"), true);
            return false;
        }
        PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
        if (playerPartyStore.occupied() >= 6) {
            MythsAndLegends.getLogger().debug("Cannot unfuse, party is full ({} / 6).", (Object)playerPartyStore.size());
            player.displayClientMessage((Component)Component.translatable((String)"mythsandlegends.unfusion.party_full"), true);
            MythsAndLegends.getLogger().debug("Sent player message key: mythsandlegends.unfusion.party_full");
            return false;
        }
        RegistryAccess registryAccess = player.serverLevel().registryAccess();
        Pokemon partnerPokemon = Pokemon.Companion.loadFromNBT(registryAccess, partnerNbt = persistentData.getCompound(NBT_KEY_STORED_POKEMON));
        if (partnerPokemon == null) {
            MythsAndLegends.getLogger().error("Failed to load stored partner Pokemon from NBT during unfusion! Clearing fusion tags.");
            TransformationHelper.clearFusionTagsAndRevert(basePokemon, rule.playAnimation);
            player.displayClientMessage((Component)Component.translatable((String)"mythsandlegends.unfusion.error.load_failed"), true);
            return false;
        }
        boolean added = playerPartyStore.add(partnerPokemon);
        if (!added) {
            MythsAndLegends.getLogger().error("Failed to add unfused partner {} back to party! Party size might have changed unexpectedly. Unfusion cannot complete.", (Object)partnerPokemon.getSpecies().getName());
            player.displayClientMessage((Component)Component.translatable((String)"mythsandlegends.unfusion.error.add_failed"), true);
            return false;
        }
        MythsAndLegends.getLogger().info("Unfusing {}. Partner {} returned to party.", (Object)basePokemon.getSpecies().getName(), (Object)partnerPokemon.getSpecies().getName());
        persistentData.remove(NBT_KEY_STORED_POKEMON);
        persistentData.remove(NBT_KEY_IS_FUSED);
        persistentData.remove(NBT_KEY_FUSION_PARTNER_SPECIES);
        persistentData.remove(NBT_KEY_FUSION_RULE_FORM);
        TransformationHelper.clearTradableNBT(basePokemon);
        String standardFormName = basePokemon.getSpecies().getStandardForm().getName();
        TransformationHelper.applyFormChange(basePokemon, standardFormName, rule.playAnimation, true, success -> {
            if (!success.booleanValue()) {
                MythsAndLegends.getLogger().warn("Post-unfusion revert failed for {}. Final form is '{}'.", (Object)basePokemon.getSpecies().getName(), (Object)basePokemon.getForm().getName());
            }
        });
        player.displayClientMessage((Component)Component.translatable((String)"mythsandlegends.unfusion.success", (Object[])new Object[]{basePokemon.getDisplayName(true), partnerPokemon.getDisplayName(true)}), false);
        return true;
    }

    public static void applyFormChange(Pokemon pokemon, String targetFormName, boolean playAnimation, boolean isTradable, Consumer<Boolean> onCompleteCallback) {
        if (pokemon == null || targetFormName == null || targetFormName.isEmpty()) {
            MythsAndLegends.getLogger().warn("Cannot change form: Invalid input pokemon or targetFormName.");
            onCompleteCallback.accept(false);
            return;
        }
        Species species = pokemon.getSpecies();
        if (species == null) {
            MythsAndLegends.getLogger().error("Cannot change form: Pokemon {} has no species data.", (Object)pokemon.getUuid());
            onCompleteCallback.accept(false);
            return;
        }
        FormData targetFormData = species.getForms().stream().filter(form -> targetFormName.equalsIgnoreCase(form.getName())).findFirst().orElse(null);
        if (targetFormData == null && targetFormName.equalsIgnoreCase(species.getStandardForm().getName())) {
            targetFormData = species.getStandardForm();
        }
        if (targetFormData == null) {
            String availableForms = species.getForms().stream().map(FormData::getName).collect(Collectors.joining(", "));
            MythsAndLegends.getLogger().warn("Cannot change form: Form '{}' not found for species '{}'. Available forms: [{}]", (Object)targetFormName, (Object)species.getName(), availableForms.isEmpty() ? species.getStandardForm().getName() : availableForms + ", " + species.getStandardForm().getName());
            TransformationHelper.setTradableNBT(pokemon, true);
            pokemon.setTradeable(true);
            onCompleteCallback.accept(false);
            return;
        }
        PokemonEntity entity = pokemon.getEntity();
        FormData finalTargetFormData = targetFormData;
        String preChangeName = pokemon.getDisplayName(true).getString();
        if (playAnimation && entity instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = entity;
            pokemonEntity.getEntityData().set(PokemonEntity.getEVOLUTION_STARTED(), (Object)true);
            pokemonEntity.getNavigation().stop();
            pokemonEntity.after(1.0f, () -> {
                TransformationHelper.evolutionAnimation((Entity)pokemonEntity);
                pokemonEntity.level().playSound(null, pokemonEntity.blockPosition(), CobblemonSounds.EVOLUTION_NOTIFICATION, SoundSource.NEUTRAL, 1.0f, 1.0f);
                return Unit.INSTANCE;
            });
            pokemonEntity.after(11.2f, () -> {
                HashSet targetAspects = new HashSet(finalTargetFormData.getAspects());
                pokemon.setForcedAspects(targetAspects);
                pokemon.initialize();
                boolean success = pokemon.getForm().equals((Object)finalTargetFormData);
                if (success) {
                    MythsAndLegends.getLogger().info("Successfully changed {} to form '{}'.", (Object)preChangeName, (Object)finalTargetFormData.getName());
                    TransformationHelper.setTradableNBT(pokemon, isTradable);
                    pokemon.setTradeable(isTradable);
                } else {
                    MythsAndLegends.getLogger().warn("Failed to change {} to form '{}'. Final form is '{}' (Expected '{}').", (Object)preChangeName, (Object)finalTargetFormData.getName(), (Object)pokemon.getForm().getName(), (Object)finalTargetFormData.getName());
                    TransformationHelper.setTradableNBT(pokemon, true);
                    pokemon.setTradeable(true);
                }
                TransformationHelper.cryAnimation((Entity)pokemonEntity);
                onCompleteCallback.accept(success);
                return Unit.INSTANCE;
            });
            pokemonEntity.after(12.0f, () -> {
                pokemonEntity.getEntityData().set(PokemonEntity.getEVOLUTION_STARTED(), (Object)false);
                return Unit.INSTANCE;
            });
        } else {
            HashSet targetAspects = new HashSet(finalTargetFormData.getAspects());
            pokemon.setForcedAspects(targetAspects);
            pokemon.initialize();
            boolean success = pokemon.getForm().equals((Object)finalTargetFormData);
            if (success) {
                MythsAndLegends.getLogger().info("Successfully changed {} to form '{}'.", (Object)preChangeName, (Object)finalTargetFormData.getName());
                TransformationHelper.setTradableNBT(pokemon, isTradable);
                pokemon.setTradeable(isTradable);
            } else {
                MythsAndLegends.getLogger().warn("Failed to change {} to form '{}'. Final form is '{}' (Expected '{}').", (Object)preChangeName, (Object)finalTargetFormData.getName(), (Object)pokemon.getForm().getName(), (Object)finalTargetFormData.getName());
                TransformationHelper.setTradableNBT(pokemon, true);
                pokemon.setTradeable(true);
            }
            onCompleteCallback.accept(success);
        }
    }

    public static void checkAndApplyPersistentForm(Pokemon pokemon) {
        CompoundTag persistentData = pokemon.getPersistentData();
        if (persistentData.getBoolean(NBT_KEY_IS_FUSED) && persistentData.contains(NBT_KEY_FUSION_RULE_FORM)) {
            String targetFormName = persistentData.getString(NBT_KEY_FUSION_RULE_FORM);
            String partnerSpecies = persistentData.getString(NBT_KEY_FUSION_PARTNER_SPECIES);
            MythsAndLegends.getLogger().debug("Loading persistent fusion state for {}: Form {}, Partner {}", (Object)pokemon.getSpecies().getName(), (Object)targetFormName, (Object)partnerSpecies);
            Optional<FusionTransformation> ruleOpt = FormChangeConfig.getConfig().fusions.stream().filter(rule -> rule.basePokemon.equalsIgnoreCase(pokemon.getSpecies().getName()) && rule.partnerPokemon.equalsIgnoreCase(partnerSpecies) && rule.resultingForm.equalsIgnoreCase(targetFormName)).findFirst();
            if (ruleOpt.isPresent()) {
                FusionTransformation rule2 = ruleOpt.get();
                boolean isTradable = persistentData.contains(NBT_KEY_IS_TRADABLE) ? persistentData.getBoolean(NBT_KEY_IS_TRADABLE) : rule2.isTradable;
                TransformationHelper.applyFormChange(pokemon, targetFormName, false, isTradable, success -> {
                    if (!success.booleanValue()) {
                        MythsAndLegends.getLogger().warn("Persistent fusion form '{}' failed to apply correctly on load for {}. Final form is '{}'. Clearing fusion tags.", (Object)targetFormName, (Object)pokemon.getSpecies().getName(), (Object)pokemon.getForm().getName());
                        TransformationHelper.clearFusionTagsAndRevert(pokemon, false);
                    } else {
                        MythsAndLegends.getLogger().debug("Successfully applied persistent fusion form '{}' to {}.", (Object)targetFormName, (Object)pokemon.getSpecies().getName());
                    }
                });
                if (!pokemon.getForm().getName().equalsIgnoreCase(targetFormName)) {
                    MythsAndLegends.getLogger().warn("Persistent fusion form '{}' failed to apply correctly on load for {}. Final form is '{}'. Clearing fusion tags.", (Object)targetFormName, (Object)pokemon.getSpecies().getName(), (Object)pokemon.getForm().getName());
                    TransformationHelper.clearFusionTagsAndRevert(pokemon, false);
                } else {
                    MythsAndLegends.getLogger().debug("Successfully applied persistent fusion form '{}' to {}.", (Object)targetFormName, (Object)pokemon.getSpecies().getName());
                }
            } else {
                MythsAndLegends.getLogger().warn("Could not find matching fusion rule to validate persistent state for {}. Clearing fusion tags.", (Object)pokemon.getSpecies().getName());
                TransformationHelper.clearFusionTagsAndRevert(pokemon, false);
            }
        }
    }

    private static void clearFusionTagsAndRevert(Pokemon pokemon, boolean playAnimation) {
        CompoundTag persistentData = pokemon.getPersistentData();
        persistentData.remove(NBT_KEY_STORED_POKEMON);
        persistentData.remove(NBT_KEY_IS_FUSED);
        persistentData.remove(NBT_KEY_FUSION_PARTNER_SPECIES);
        persistentData.remove(NBT_KEY_FUSION_RULE_FORM);
        TransformationHelper.clearTradableNBT(pokemon);
        if (pokemon.getSpecies() != null) {
            TransformationHelper.applyFormChange(pokemon, pokemon.getSpecies().getStandardForm().getName(), playAnimation, true, success -> {});
        }
    }

    private static void setTradableNBT(Pokemon pokemon, boolean isTradable) {
        pokemon.getPersistentData().putBoolean(NBT_KEY_IS_TRADABLE, isTradable);
        pokemon.setTradeable(isTradable);
        MythsAndLegends.getLogger().debug("Set tradable status for {} to: {}", (Object)pokemon.getDisplayName(true).getString(), (Object)isTradable);
    }

    private static void clearTradableNBT(Pokemon pokemon) {
        pokemon.getPersistentData().remove(NBT_KEY_IS_TRADABLE);
        pokemon.setTradeable(true);
        MythsAndLegends.getLogger().debug("Cleared custom tradable status for {}, defaulting to true.", (Object)pokemon.getDisplayName(true).getString());
    }

    public static boolean isPokemonTradable(Pokemon pokemon) {
        CompoundTag persistentData = pokemon.getPersistentData();
        return persistentData.contains(NBT_KEY_IS_TRADABLE) ? persistentData.getBoolean(NBT_KEY_IS_TRADABLE) : true;
    }

    public static void evolutionAnimation(Entity pokemonEntity) {
        Level world = pokemonEntity.level();
        if (world == null) {
            return;
        }
        PlayPosableAnimationPacket playPoseableAnimationPacket = new PlayPosableAnimationPacket(pokemonEntity.getId(), Set.of("q.bedrock_stateful('evolution', 'evolution', 'endures_primary_animations');"), List.of());
        playPoseableAnimationPacket.sendToPlayersAround(pokemonEntity.getX(), pokemonEntity.getY(), pokemonEntity.getZ(), 128.0, world.dimension(), player -> false);
    }

    public static void cryAnimation(Entity pokemonEntity) {
        Level world = pokemonEntity.level();
        if (world == null) {
            return;
        }
        PlayPosableAnimationPacket playPoseableAnimationPacket = new PlayPosableAnimationPacket(pokemonEntity.getId(), Set.of("cry"), List.of());
        playPoseableAnimationPacket.sendToPlayersAround(pokemonEntity.getX(), pokemonEntity.getY(), pokemonEntity.getZ(), 128.0, world.dimension(), player -> false);
    }
}

