/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.utils;

import com.github.d0ctorleon.mythsandlegends.items.Items;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class RegistryRemapper {
    private static final String OLD_MOD_ID = "myths_and_legends";
    private static final String NEW_MOD_ID = "mythsandlegends";

    public static void remapItems() {
        ResourceLocation newId;
        ResourceLocation oldId;
        HashMap<ResourceLocation, ResourceLocation> remapEntries = new HashMap<ResourceLocation, ResourceLocation>();
        for (String string : Items.KEY_ITEM_NAMES) {
            oldId = ResourceLocation.fromNamespaceAndPath((String)OLD_MOD_ID, (String)string);
            newId = ResourceLocation.fromNamespaceAndPath((String)NEW_MOD_ID, (String)string);
            remapEntries.put(oldId, newId);
        }
        for (Map.Entry entry : remapEntries.entrySet()) {
            oldId = (ResourceLocation)entry.getKey();
            newId = (ResourceLocation)entry.getValue();
            Item item = (Item)BuiltInRegistries.ITEM.get(newId);
            if (item == null) continue;
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)oldId, (Object)item);
        }
    }
}

