/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.utils;

import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.configs.ConfigVariables;
import com.github.d0ctorleon.mythsandlegends.items.Items;
import com.github.d0ctorleon.mythsandlegends.utils.gson.ResourceLocationTypeAdapter;
import com.github.d0ctorleon.mythsandlegends.utils.gson.UUIDTypeAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class ItemCooldownStorage {
    private final String COOLDOWN_FILE;
    private final Gson gson;
    private Map<UUID, Map<ResourceLocation, List<Long>>> playerCooldowns = new HashMap<UUID, Map<ResourceLocation, List<Long>>>();
    public static final ResourceLocation GLOBAL_COOLDOWN_ID = ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"global_cooldown_tracker");

    public ItemCooldownStorage(Path configDirectoryPath) {
        this.COOLDOWN_FILE = configDirectoryPath.resolve("cooldowns.json").toString();
        this.gson = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocationTypeAdapter()).setPrettyPrinting().create();
        this.loadCooldowns();
    }

    public Map<ResourceLocation, List<Long>> getCooldownsForPlayer(UUID playerId) {
        return new HashMap<ResourceLocation, List<Long>>(this.playerCooldowns.getOrDefault(playerId, Collections.emptyMap()));
    }

    public void saveCooldownTimestamp(UUID playerId, Item item) {
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
        if (!Items.KEY_ITEM_IDS.contains(itemId)) {
            return;
        }
        ConfigVariables config = MythsAndLegends.getConfigManager().getConfig();
        long currentTime = System.currentTimeMillis();
        this.playerCooldowns.computeIfAbsent(playerId, k -> new HashMap()).computeIfAbsent(itemId, k -> new ArrayList()).add(currentTime);
        if (config.global_item_cooldown) {
            this.playerCooldowns.computeIfAbsent(playerId, k -> new HashMap()).computeIfAbsent(GLOBAL_COOLDOWN_ID, k -> new ArrayList()).replaceAll(ts -> currentTime);
            if (this.playerCooldowns.get(playerId).get(GLOBAL_COOLDOWN_ID).isEmpty()) {
                this.playerCooldowns.get(playerId).get(GLOBAL_COOLDOWN_ID).add(currentTime);
            }
        }
        this.saveCooldowns();
    }

    public boolean hasEnoughVouchers(UUID playerId, Item item, int vouchersNeeded, int maxVouchers) {
        ConfigVariables config = MythsAndLegends.getConfigManager().getConfig();
        ResourceLocation specificItemId = BuiltInRegistries.ITEM.getKey((Object)item);
        Map playerSpecificCooldowns = this.playerCooldowns.getOrDefault(playerId, Collections.emptyMap());
        if (config.global_item_vouchers) {
            int totalUsedVouchers = 0;
            for (Map.Entry entry : playerSpecificCooldowns.entrySet()) {
                ResourceLocation currentId = (ResourceLocation)entry.getKey();
                if (currentId.equals((Object)GLOBAL_COOLDOWN_ID) || !Items.KEY_ITEM_IDS.contains(currentId)) continue;
                totalUsedVouchers += ((List)entry.getValue()).size();
            }
            MythsAndLegends.getLogger().debug("Global voucher check for {}: Used={}, Needed={}, Max={}", (Object)playerId, (Object)totalUsedVouchers, (Object)vouchersNeeded, (Object)maxVouchers);
            return totalUsedVouchers + vouchersNeeded <= maxVouchers;
        }
        if (!Items.KEY_ITEM_IDS.contains(specificItemId)) {
            return true;
        }
        List timestamps = playerSpecificCooldowns.getOrDefault(specificItemId, Collections.emptyList());
        MythsAndLegends.getLogger().debug("Per-item voucher check for {}: Item={}, Used={}, Needed={}, Max={}", (Object)playerId, (Object)specificItemId, (Object)timestamps.size(), (Object)vouchersNeeded, (Object)maxVouchers);
        return timestamps.size() + vouchersNeeded <= maxVouchers;
    }

    public static int calculateRemainingCooldownTicks(ItemCooldownStorage cooldownStorage, UUID playerId, Item item, int cooldownSeconds) {
        ConfigVariables config = MythsAndLegends.getConfigManager().getConfig();
        long currentTime = System.currentTimeMillis();
        long cooldownMillis = (long)cooldownSeconds * 1000L;
        long maxRemainingCooldown = 0L;
        ResourceLocation specificItemId = BuiltInRegistries.ITEM.getKey((Object)item);
        Map playerSpecificCooldowns = cooldownStorage.playerCooldowns.getOrDefault(playerId, Collections.emptyMap());
        if (config.global_item_cooldown) {
            long lastGlobalUse;
            long elapsedMillis;
            MythsAndLegends.getLogger().debug("Calculating global cooldown for player {}", (Object)playerId);
            List timestampsToCheck = playerSpecificCooldowns.getOrDefault(GLOBAL_COOLDOWN_ID, Collections.emptyList());
            if (!timestampsToCheck.isEmpty() && (elapsedMillis = currentTime - (lastGlobalUse = ((Long)timestampsToCheck.get(0)).longValue())) < cooldownMillis) {
                maxRemainingCooldown = cooldownMillis - elapsedMillis;
            }
        } else {
            long elapsedMillis;
            MythsAndLegends.getLogger().debug("Calculating per-item cooldown for player {}, item {}", (Object)playerId, (Object)specificItemId);
            if (!Items.KEY_ITEM_IDS.contains(specificItemId)) {
                return 0;
            }
            List timestampsToCheck = playerSpecificCooldowns.getOrDefault(specificItemId, Collections.emptyList());
            long mostRecentTimestamp = timestampsToCheck.stream().max(Long::compareTo).orElse(0L);
            if (mostRecentTimestamp > 0L && (elapsedMillis = currentTime - mostRecentTimestamp) < cooldownMillis) {
                maxRemainingCooldown = cooldownMillis - elapsedMillis;
            }
        }
        if (maxRemainingCooldown <= 0L) {
            return 0;
        }
        int ticks = (int)((maxRemainingCooldown + 49L) / 50L);
        MythsAndLegends.getLogger().debug("Cooldown calculation result: {} ticks remaining.", (Object)ticks);
        return ticks;
    }

    public void clearCooldown(UUID playerId, ResourceLocation itemId) {
        if (this.playerCooldowns.containsKey(playerId)) {
            this.playerCooldowns.get(playerId).remove(itemId);
            if (this.playerCooldowns.get(playerId).isEmpty()) {
                this.playerCooldowns.remove(playerId);
            }
            this.saveCooldowns();
        }
    }

    public void clearAllCooldowns(UUID playerId) {
        if (this.playerCooldowns.remove(playerId) != null) {
            this.saveCooldowns();
        }
    }

    @Deprecated
    public boolean canUseItem(UUID playerId, Item item, int maxVouchers, int cooldownSeconds) {
        MythsAndLegends.getLogger().warn("Deprecated method canUseItem called. Review usage.");
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
        Map playerItemCooldowns = this.playerCooldowns.getOrDefault(playerId, Collections.emptyMap());
        List timestamps = playerItemCooldowns.getOrDefault(itemId, Collections.emptyList());
        if (timestamps.size() >= maxVouchers) {
            long currentTime = System.currentTimeMillis();
            long cooldownMillis = (long)cooldownSeconds * 1000L;
            for (Long timestamp : timestamps) {
                if (currentTime - timestamp >= cooldownMillis) continue;
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public boolean isCooldownExpired(UUID playerId, Item item, int maxVouchers, int cooldownSeconds) {
        MythsAndLegends.getLogger().warn("Deprecated method isCooldownExpired called. Review usage.");
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
        Map playerItemCooldowns = this.playerCooldowns.getOrDefault(playerId, Collections.emptyMap());
        List timestamps = playerItemCooldowns.getOrDefault(itemId, Collections.emptyList());
        if (timestamps.size() < maxVouchers) {
            return true;
        }
        long currentTime = System.currentTimeMillis();
        long cooldownMillis = (long)cooldownSeconds * 1000L;
        long oldestTimestamp = timestamps.stream().min(Long::compareTo).orElse(Long.MAX_VALUE);
        return currentTime - oldestTimestamp >= cooldownMillis;
    }

    private void saveCooldowns() {
        try (FileWriter writer = new FileWriter(this.COOLDOWN_FILE);){
            this.gson.toJson(this.playerCooldowns, (Appendable)writer);
        }
        catch (IOException e) {
            MythsAndLegends.getLogger().error("Failed to save cooldowns to file: " + this.COOLDOWN_FILE, (Throwable)e);
        }
    }

    public void loadCooldowns() {
        File file = new File(this.COOLDOWN_FILE);
        if (!file.exists()) {
            this.playerCooldowns = new HashMap<UUID, Map<ResourceLocation, List<Long>>>();
            return;
        }
        try (FileReader reader = new FileReader(file);){
            Type type = TypeToken.getParameterized(HashMap.class, (Type[])new Type[]{UUID.class, TypeToken.getParameterized(HashMap.class, (Type[])new Type[]{ResourceLocation.class, TypeToken.getParameterized(ArrayList.class, (Type[])new Type[]{Long.class}).getType()}).getType()}).getType();
            Map loadedData = (Map)this.gson.fromJson((Reader)reader, type);
            if (loadedData != null) {
                this.playerCooldowns = new ConcurrentHashMap<UUID, Map<ResourceLocation, List<Long>>>(loadedData);
            } else {
                MythsAndLegends.getLogger().warn("Cooldown file {} was empty or invalid JSON. Initializing empty cooldowns.", (Object)this.COOLDOWN_FILE);
                this.playerCooldowns = new ConcurrentHashMap<UUID, Map<ResourceLocation, List<Long>>>();
            }
        }
        catch (JsonSyntaxException | IOException e) {
            MythsAndLegends.getLogger().error("Failed to load or parse cooldowns from file: " + this.COOLDOWN_FILE, e);
            this.playerCooldowns = new ConcurrentHashMap<UUID, Map<ResourceLocation, List<Long>>>();
        }
    }
}

