/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.ShulkerBoxBlock;

public class InventoryUtils {
    public static boolean hasItemInInventory(Player player, Item item) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty() || stack.getItem() != item) continue;
            return true;
        }
        return false;
    }

    public static boolean removeItemFromInventory(ServerPlayer player, Item item, int count, boolean checkBundles, boolean checkShulkerBoxes) {
        int i;
        int remainingCount = count;
        for (i = 0; i < player.getInventory().getContainerSize() && remainingCount > 0; ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty() || stack.getItem() != item) continue;
            int removeAmount = Math.min(remainingCount, stack.getCount());
            stack.shrink(removeAmount);
            remainingCount -= removeAmount;
        }
        if (remainingCount > 0 && (checkBundles || checkShulkerBoxes)) {
            for (i = 0; i < player.getInventory().getContainerSize() && remainingCount > 0; ++i) {
                ItemStack containerStack = player.getInventory().getItem(i);
                if (containerStack.isEmpty()) continue;
                int removedFromContainer = InventoryUtils.tryRemoveFromContainer(containerStack, item, remainingCount, checkBundles, checkShulkerBoxes);
                remainingCount -= removedFromContainer;
            }
        }
        return remainingCount <= 0;
    }

    public static int tryRemoveFromContainer(ItemStack containerStack, Item item, int maxToRemove, boolean checkBundles, boolean checkShulkerBoxes) {
        ItemContainerContents originalComponent;
        int itemsRemoved = 0;
        Item containerItem = containerStack.getItem();
        if (checkBundles && containerItem instanceof BundleItem) {
            BundleContents originalComponent2 = (BundleContents)containerStack.get(DataComponents.BUNDLE_CONTENTS);
            if (originalComponent2 != null && !originalComponent2.isEmpty()) {
                BundleContents.Mutable builder = new BundleContents.Mutable(originalComponent2);
                ArrayList currentStacks = new ArrayList();
                originalComponent2.itemCopyStream().forEach(currentStacks::add);
                ArrayList<ItemStack> modifiedStacks = new ArrayList<ItemStack>();
                boolean changed = false;
                for (ItemStack bundleItemStack : currentStacks) {
                    if (itemsRemoved < maxToRemove && bundleItemStack.getItem() == item) {
                        int canRemove = Math.min(maxToRemove - itemsRemoved, bundleItemStack.getCount());
                        if (canRemove > 0) {
                            bundleItemStack.shrink(canRemove);
                            itemsRemoved += canRemove;
                            changed = true;
                            if (bundleItemStack.isEmpty()) continue;
                            modifiedStacks.add(bundleItemStack);
                            continue;
                        }
                        modifiedStacks.add(bundleItemStack);
                        continue;
                    }
                    modifiedStacks.add(bundleItemStack);
                }
                if (changed) {
                    builder.clearItems();
                    for (ItemStack stackToAdd : modifiedStacks) {
                        if (stackToAdd.isEmpty()) continue;
                        builder.tryInsert(stackToAdd);
                    }
                    BundleContents newComponent = builder.toImmutable();
                    if (newComponent.isEmpty()) {
                        containerStack.remove(DataComponents.BUNDLE_CONTENTS);
                    } else {
                        containerStack.set(DataComponents.BUNDLE_CONTENTS, (Object)newComponent);
                    }
                }
            }
        } else if (checkShulkerBoxes && containerItem instanceof BlockItem && ((BlockItem)containerItem).getBlock() instanceof ShulkerBoxBlock && (originalComponent = (ItemContainerContents)containerStack.get(DataComponents.CONTAINER)) != null) {
            NonNullList mutableStacks = NonNullList.withSize((int)originalComponent.stream().toList().size(), (Object)ItemStack.EMPTY);
            originalComponent.copyInto(mutableStacks);
            boolean changed = false;
            for (int i = 0; i < mutableStacks.size(); ++i) {
                ItemStack shulkerItemStack = (ItemStack)mutableStacks.get(i);
                if (itemsRemoved < maxToRemove && !shulkerItemStack.isEmpty() && shulkerItemStack.getItem() == item) {
                    int canRemove = Math.min(maxToRemove - itemsRemoved, shulkerItemStack.getCount());
                    shulkerItemStack.shrink(canRemove);
                    itemsRemoved += canRemove;
                    changed = true;
                }
                if (itemsRemoved >= maxToRemove) break;
            }
            if (changed) {
                ItemContainerContents newComponent = ItemContainerContents.fromItems((List)mutableStacks);
                if (newComponent == ItemContainerContents.EMPTY) {
                    containerStack.remove(DataComponents.CONTAINER);
                } else {
                    containerStack.set(DataComponents.CONTAINER, (Object)newComponent);
                }
            }
        }
        return itemsRemoved;
    }
}

