/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.permissions;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.permission.CobblemonPermission;
import com.cobblemon.mod.common.api.permission.Permission;
import com.cobblemon.mod.common.api.permission.PermissionLevel;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.server.level.ServerPlayer;

public class MythsAndLegendsPermissions {
    public final CobblemonPermission ACCESS_PERMISSION;
    public final CobblemonPermission LIST_ITEMS_PERMISSION;
    public final CobblemonPermission CHECK_INVENTORY_PERMISSION;
    public final CobblemonPermission LIST_POKEMON_PERMISSION;
    public final CobblemonPermission CHECK_POKEMON_PERMISSION;
    public final CobblemonPermission SET_BLOCK_CHECK_SPECIES_PERMISSION;
    public final CobblemonPermission FORCE_SPAWN_PERMISSION;
    public final CobblemonPermission APPLY_ASPECTS_AND_FORMS;
    public final CobblemonPermission OPEN_SETTINGS_PERMISSION;
    public final CobblemonPermission CHECK_COOLDOWN_PERMISSION;
    public final CobblemonPermission CLEAR_COOLDOWN_PERMISSION;
    public final CobblemonPermission CLEAR_ALL_COOLDOWNS_PERMISSION;
    public final PermissionLevel OP_LEVEL_4 = PermissionLevel.ALL_COMMANDS;
    public final PermissionLevel OP_LEVEL_3 = PermissionLevel.MULTIPLAYER_MANAGEMENT;
    public final PermissionLevel OP_LEVEL_2 = PermissionLevel.CHEAT_COMMANDS_AND_COMMAND_BLOCKS;
    public final PermissionLevel OP_LEVEL_1 = PermissionLevel.SPAWN_PROTECTION_BYPASS;
    public final PermissionLevel OP_LEVEL_0 = PermissionLevel.NONE;

    public MythsAndLegendsPermissions() {
        this.ACCESS_PERMISSION = new CobblemonPermission("mythsandlegends.access", this.OP_LEVEL_2);
        this.LIST_ITEMS_PERMISSION = new CobblemonPermission("mythsandlegends.items.list", this.OP_LEVEL_2);
        this.CHECK_INVENTORY_PERMISSION = new CobblemonPermission("mythsandlegends.items.sync", this.OP_LEVEL_2);
        this.LIST_POKEMON_PERMISSION = new CobblemonPermission("mythsandlegends.pokemon.list", this.OP_LEVEL_2);
        this.CHECK_POKEMON_PERMISSION = new CobblemonPermission("mythsandlegends.pokemon.check", this.OP_LEVEL_2);
        this.SET_BLOCK_CHECK_SPECIES_PERMISSION = new CobblemonPermission("mythsandlegends.pokemon.placeifhas", this.OP_LEVEL_2);
        this.FORCE_SPAWN_PERMISSION = new CobblemonPermission("mythsandlegends.pokemon.forcespawn", this.OP_LEVEL_2);
        this.APPLY_ASPECTS_AND_FORMS = new CobblemonPermission("mythsandlegends.pokemon.update", this.OP_LEVEL_2);
        this.OPEN_SETTINGS_PERMISSION = new CobblemonPermission("mythsandlegends.settings.open", this.OP_LEVEL_2);
        this.CHECK_COOLDOWN_PERMISSION = new CobblemonPermission("mythsandlegends.cooldown.check", this.OP_LEVEL_2);
        this.CLEAR_COOLDOWN_PERMISSION = new CobblemonPermission("mythsandlegends.cooldown.clear", this.OP_LEVEL_2);
        this.CLEAR_ALL_COOLDOWNS_PERMISSION = new CobblemonPermission("mythsandlegends.cooldown.clearall", this.OP_LEVEL_2);
    }

    public static boolean checkPermission(SharedSuggestionProvider source, CobblemonPermission permission) {
        if (source instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)source;
            return Cobblemon.INSTANCE.getPermissionValidator().hasPermission(player, (Permission)permission);
        }
        if (source instanceof CommandSourceStack) {
            CommandSourceStack commandSource = (CommandSourceStack)source;
            return Cobblemon.INSTANCE.getPermissionValidator().hasPermission(commandSource, (Permission)permission);
        }
        return false;
    }
}

