/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.items;

import com.github.d0ctorleon.mythsandlegends.utils.ForceSpawningUtils;
import com.github.d0ctorleon.mythsandlegends.utils.PlayerDataUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class KeyItem
extends Item {
    private final String itemName;

    public KeyItem(Item.Properties settings, String itemName) {
        super(settings);
        this.itemName = itemName;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player playerEntity, InteractionHand hand) {
        if (!world.isClientSide) {
            PlayerDataUtils.updatePlayerData(playerEntity);
        }
        ItemStack itemStack = playerEntity.getItemInHand(hand);
        if (!playerEntity.isShiftKeyDown()) {
            InteractionResult result = ForceSpawningUtils.forceSpawnFromItemUse(world, playerEntity, hand, this.itemName);
            if (result.consumesAction()) {
                boolean swing = result == InteractionResult.SUCCESS;
                return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)world.isClientSide());
            }
            return InteractionResultHolder.fail((Object)itemStack);
        }
        return InteractionResultHolder.pass((Object)itemStack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.translatable((String)("item.mythsandlegends." + this.itemName + ".description")));
    }
}

