/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.items;

import com.cobblemon.mod.common.pokemon.helditem.CobblemonHeldItemManager;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.items.CreativeTab;
import com.github.d0ctorleon.mythsandlegends.items.KeyItem;
import com.github.d0ctorleon.mythsandlegends.items.ZygardeCubeBundleItem;
import com.google.common.base.Suppliers;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;

public class Items {
    public static final Supplier<RegistrarManager> MANAGER = Suppliers.memoize(() -> RegistrarManager.get((String)"mythsandlegends"));
    public static final Registrar<Item> ITEMS = MANAGER.get().get(Registries.ITEM);
    public static final List<ResourceLocation> KEY_ITEM_IDS = new ArrayList<ResourceLocation>();
    public static final List<RegistrySupplier<Item>> ITEM_REGISTRY_SUPPLIERS = new ArrayList<RegistrySupplier<Item>>();
    public static RegistrySupplier<Item> ZYGARDE_CELL;
    public static RegistrySupplier<Item> ZYGARDE_CORE;
    public static RegistrySupplier<Item> ZYGARDE_CUBE;
    public static final List<String> KEY_ITEM_NAMES;
    public static final List<ResourceLocation> ALL_ITEM_IDS;

    public static void registerItems() {
        for (String name : KEY_ITEM_NAMES) {
            ResourceLocation identifier = ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)name);
            KEY_ITEM_IDS.add(identifier);
            ALL_ITEM_IDS.add(identifier);
            RegistrySupplier item = ITEMS.register(identifier, () -> new KeyItem(new Item.Properties().stacksTo(64).rarity(Rarity.EPIC).arch$tab(CreativeTab.MYTHS_AND_LEGENDS_TAB), name));
            ITEM_REGISTRY_SUPPLIERS.add((RegistrySupplier<Item>)item);
        }
        ResourceLocation cellId = ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"zygarde_cell");
        ALL_ITEM_IDS.add(cellId);
        ZYGARDE_CELL = ITEMS.register(cellId, () -> new Item(new Item.Properties().stacksTo(64).rarity(Rarity.RARE).arch$tab(CreativeTab.MYTHS_AND_LEGENDS_TAB)));
        ResourceLocation coreId = ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"zygarde_core");
        ALL_ITEM_IDS.add(coreId);
        ZYGARDE_CORE = ITEMS.register(coreId, () -> new Item(new Item.Properties().stacksTo(64).rarity(Rarity.EPIC).arch$tab(CreativeTab.MYTHS_AND_LEGENDS_TAB)));
        ResourceLocation cubeId = ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"zygarde_cube");
        ALL_ITEM_IDS.add(cubeId);
        KEY_ITEM_IDS.add(cubeId);
        ZYGARDE_CUBE = ITEMS.register(cubeId, () -> new ZygardeCubeBundleItem(new Item.Properties().stacksTo(1).rarity(Rarity.EPIC).arch$tab(CreativeTab.MYTHS_AND_LEGENDS_TAB)));
        MythsAndLegends.getLogger().debug("Registered {} standard KeyItems.", (Object)ITEM_REGISTRY_SUPPLIERS.size());
        MythsAndLegends.getLogger().debug("Registered Zygarde Cell, Core, and Cube.");
        MythsAndLegends.getLogger().debug("Total items registered for MythsAndLegends: {}", (Object)ALL_ITEM_IDS.size());
    }

    public static Registrar<Item> getITEMS() {
        return ITEMS;
    }

    public static Supplier<RegistrarManager> getManager() {
        return MANAGER;
    }

    private static void registerItemRemap() {
        CobblemonHeldItemManager.INSTANCE.registerRemap((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"adamant_orb")), "adamantcrystal");
        CobblemonHeldItemManager.INSTANCE.registerRemap((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"blue_orb")), "blueorb");
        CobblemonHeldItemManager.INSTANCE.registerRemap((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"griseous_orb")), "griseouscore");
        CobblemonHeldItemManager.INSTANCE.registerRemap((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"red_orb")), "redorb");
        CobblemonHeldItemManager.INSTANCE.registerRemap((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"lustrous_orb")), "lustrousglobe");
        CobblemonHeldItemManager.INSTANCE.registerRemap((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"wellspring_mask")), "wellspringmask");
        CobblemonHeldItemManager.INSTANCE.registerRemap((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"cornerstone_mask")), "cornerstonemask");
        CobblemonHeldItemManager.INSTANCE.registerRemap((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"hearthflame_mask")), "hearthflamemask");
        CobblemonHeldItemManager.INSTANCE.registerRemap((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"rusted_shield")), "rustedshield");
        CobblemonHeldItemManager.INSTANCE.registerRemap((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"rusted_sword")), "rustedsword");
    }

    static {
        KEY_ITEM_NAMES = List.of("adamant_orb", "aurora_ticket", "azure_flute", "blue_orb", "bonus_disk", "clear_bell", "dna_splicer", "eon_ticket", "griseous_orb", "gs_ball", "jade_orb", "liberty_pass", "lustrous_orb", "member_card", "oaks_letter", "old_sea_map", "red_orb", "rusted_shield", "rusted_sword", "tidal_bell", "dr_fujis_diary", "rainbow_wing", "silver_wing", "violet_book", "scarlet_book", "cocoon_of_destruction", "sapling_of_life", "mystery_box", "reveal_glass", "dark_stone", "light_stone", "teal_mask", "sun_flute", "moon_flute", "lunar_feather", "magma_stone", "diancies_crown", "fini_totem", "genesect_drive", "grassland_blade", "hoopa_ring", "ironwill_sword", "koko_totem", "lele_totem", "lillies_bag", "meloetta_headset", "necro_prism", "prison_bottle", "sacred_sword", "steam_valve", "type_null_mask", "antique_pokeball", "eternatus_core", "kubfus_band", "marshadow_hood", "plasma_tablet", "prismatic_shell", "reins_of_unity", "scaly_tablet", "scroll_of_water", "soul_heart", "zarudes_cape", "zeraoras_thunderclaw", "ancient_tablet", "mythical_pecha_berry", "scroll_of_darkness", "azelf_fang", "mesprit_plume", "stone_tablet", "uxie_claw", "ice_tablet", "steel_tablet", "bulu_totem", "cavern_shield", "iceroot_carrot", "shaderoot_carrot", "binding_mochi", "cornerstone_mask", "hearthflame_mask", "wellspring_mask");
        ALL_ITEM_IDS = new ArrayList<ResourceLocation>();
    }
}

