/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.events;

import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.configs.FormChangeConfig;
import com.github.d0ctorleon.mythsandlegends.net.SyncTransformConfigPacket;
import com.github.d0ctorleon.mythsandlegends.utils.FusionTransformation;
import com.github.d0ctorleon.mythsandlegends.utils.InteractionTransformation;
import com.github.d0ctorleon.mythsandlegends.utils.TransformationConfig;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import java.util.HashSet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PlayerEvents {
    public PlayerEvents() {
        PlayerEvent.PLAYER_JOIN.register(this::onPlayerJoin);
        PlayerEvent.PLAYER_QUIT.register(this::onPlayerQuit);
        PlayerEvent.PLAYER_RESPAWN.register(this::onPlayerRespawn);
        PlayerEvent.PLAYER_CLONE.register(this::onPlayerClone);
        PlayerEvent.PICKUP_ITEM_POST.register(this::onItemPickup);
        MythsAndLegends.getLogger().info("Player Events Registered");
    }

    private void onPlayerJoin(ServerPlayer player) {
        MythsAndLegends.getLogger().info("Player {} joined, sending transformation config.", (Object)player.getName().getString());
        PlayerEvents.sendConfigToPlayer(player);
    }

    public static void sendConfigToPlayer(ServerPlayer player) {
        TransformationConfig serverConfig = FormChangeConfig.getConfig();
        HashSet<ResourceLocation> fusionItems = new HashSet<ResourceLocation>();
        HashSet<ResourceLocation> interactionItems = new HashSet<ResourceLocation>();
        for (FusionTransformation fusionTransformation : serverConfig.fusions) {
            if (fusionTransformation.item == null) continue;
            fusionItems.add(fusionTransformation.item);
        }
        for (InteractionTransformation interactionTransformation : serverConfig.interactionChanges) {
            if (interactionTransformation.item == null) continue;
            interactionItems.add(interactionTransformation.item);
        }
        SyncTransformConfigPacket packet = new SyncTransformConfigPacket(fusionItems, interactionItems);
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet);
        MythsAndLegends.getLogger().debug("Sent config to {}: {} fusion items, {} interaction items", (Object)player.getName().getString(), (Object)fusionItems.size(), (Object)interactionItems.size());
    }

    private void onPlayerQuit(ServerPlayer player) {
    }

    private void onPlayerRespawn(ServerPlayer player, boolean alive, Entity.RemovalReason reason) {
    }

    private void onPlayerClone(ServerPlayer oldPlayer, ServerPlayer newPlayer, boolean isDeath) {
    }

    private void onItemPickup(Player player, ItemEntity itemEntity, ItemStack stack) {
    }
}

