/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.commands;

import com.cobblemon.mod.common.api.permission.CobblemonPermission;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.commands.suggestions.KeyItemSuggestionProvider;
import com.github.d0ctorleon.mythsandlegends.commands.suggestions.PokemonSpeciesSuggestionProvider;
import com.github.d0ctorleon.mythsandlegends.configs.ConfigVariables;
import com.github.d0ctorleon.mythsandlegends.gui.ConfigGui;
import com.github.d0ctorleon.mythsandlegends.items.Items;
import com.github.d0ctorleon.mythsandlegends.items.KeyItem;
import com.github.d0ctorleon.mythsandlegends.permissions.MythsAndLegendsPermissions;
import com.github.d0ctorleon.mythsandlegends.utils.ForceSpawningUtils;
import com.github.d0ctorleon.mythsandlegends.utils.ItemCooldownStorage;
import com.github.d0ctorleon.mythsandlegends.utils.PlayerDataUtils;
import com.github.d0ctorleon.mythsandlegends.utils.PlayerPartyUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.text2speech.Narrator;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class Commands {
    private static final MythsAndLegendsPermissions PERMISSIONS = new MythsAndLegendsPermissions();
    private static final SimpleCommandExceptionType REQUIRES_PLAYER_EXCEPTION = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.mythsandlegends.error.requires_player"));
    private static final SimpleCommandExceptionType PLAYER_NOT_FOUND_EXCEPTION = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.mythsandlegends.error.player_not_found"));
    private static final SimpleCommandExceptionType INVALID_SPECIES_EXCEPTION = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.mythsandlegends.error.invalid_species"));
    private static final SimpleCommandExceptionType INVALID_KEY_ITEM_EXCEPTION = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.mythsandlegends.error.invalid_key_item"));
    private static final DynamicCommandExceptionType INVALID_COOLDOWN_ITEM_EXCEPTION = new DynamicCommandExceptionType(itemName -> Component.translatable((String)"commands.mythsandlegends.error.invalid_cooldown_item", (Object[])new Object[]{itemName}));
    private static final DynamicCommandExceptionType ITEM_NOT_TRACKED_EXCEPTION = new DynamicCommandExceptionType(itemName -> Component.translatable((String)"commands.mythsandlegends.error.item_not_tracked", (Object[])new Object[]{itemName}));

    public static boolean hasPermission(CommandSourceStack source, CobblemonPermission permission) {
        if (Objects.requireNonNull(source.getPlayer()).hasPermissions(2)) {
            return true;
        }
        if (!source.isPlayer()) {
            return true;
        }
        return MythsAndLegendsPermissions.checkPermission((SharedSuggestionProvider)source, permission);
    }

    public static void registerCommands() {
        CommandRegistrationEvent.EVENT.register((dispatcher, registryAccess, environment) -> Commands.register((CommandDispatcher<CommandSourceStack>)dispatcher, registryAccess));
        MythsAndLegends.getLogger().debug("Start registering commands");
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandRegistryAccess) {
        LiteralArgumentBuilder baseCommand = (LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"mythsandlegends").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.ACCESS_PERMISSION));
        baseCommand.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"items").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.LIST_ITEMS_PERMISSION))).executes(Commands::executeListItemsSelf)).then(net.minecraft.commands.Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(Commands::executeListItemsTarget)));
        baseCommand.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"syncitems").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.CHECK_INVENTORY_PERMISSION))).executes(Commands::executeSyncItemsSelf)).then(net.minecraft.commands.Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(Commands::executeSyncItemsTarget)));
        baseCommand.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"party").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.LIST_POKEMON_PERMISSION))).executes(Commands::executeListPartySelf)).then(net.minecraft.commands.Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(Commands::executeListPartyTarget)));
        baseCommand.then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"haspokemon").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.CHECK_POKEMON_PERMISSION))).then(((RequiredArgumentBuilder)net.minecraft.commands.Commands.argument((String)"pokemon_species", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new PokemonSpeciesSuggestionProvider(PokemonSpecies.INSTANCE.getSpecies())).executes(Commands::executeCheckPokemonSelf)).then(net.minecraft.commands.Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(Commands::executeCheckPokemonTarget))));
        baseCommand.then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"placeifhas").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.SET_BLOCK_CHECK_SPECIES_PERMISSION))).then(net.minecraft.commands.Commands.argument((String)"pokemon_species", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new PokemonSpeciesSuggestionProvider(PokemonSpecies.INSTANCE.getSpecies())).then(net.minecraft.commands.Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)net.minecraft.commands.Commands.argument((String)"block", (ArgumentType)BlockStateArgument.block((CommandBuildContext)commandRegistryAccess)).executes(Commands::executePlaceIfHasSelf)).then(net.minecraft.commands.Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(Commands::executePlaceIfHasTarget))))));
        baseCommand.then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"settings").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.ACCESS_PERMISSION))).executes(Commands::executeOpenSettingsGui));
        LiteralArgumentBuilder cooldownCommand = net.minecraft.commands.Commands.literal((String)"cooldown");
        cooldownCommand.then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"check").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.CHECK_COOLDOWN_PERMISSION))).then(((RequiredArgumentBuilder)net.minecraft.commands.Commands.argument((String)"item", (ArgumentType)ResourceLocationArgument.id()).suggests((SuggestionProvider)new KeyItemSuggestionProvider()).executes(Commands::executeCheckCooldownSelf)).then(net.minecraft.commands.Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(Commands::executeCheckCooldownTarget))));
        cooldownCommand.then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"clear").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.CLEAR_COOLDOWN_PERMISSION))).then(((RequiredArgumentBuilder)net.minecraft.commands.Commands.argument((String)"item", (ArgumentType)ResourceLocationArgument.id()).suggests((SuggestionProvider)new KeyItemSuggestionProvider()).executes(Commands::executeClearCooldownSelf)).then(net.minecraft.commands.Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(Commands::executeClearCooldownTarget))));
        cooldownCommand.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"clearall").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.CLEAR_ALL_COOLDOWNS_PERMISSION))).executes(Commands::executeClearAllCooldownsSelf)).then(net.minecraft.commands.Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(Commands::executeClearAllCooldownsTarget)));
        baseCommand.then((ArgumentBuilder)cooldownCommand);
        dispatcher.register(baseCommand);
        baseCommand.then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"forcespawn").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.FORCE_SPAWN_PERMISSION))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.Commands.argument((String)"keyitem", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new KeyItemSuggestionProvider()).then(((RequiredArgumentBuilder)net.minecraft.commands.Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(((RequiredArgumentBuilder)net.minecraft.commands.Commands.argument((String)"consumeVoucher", (ArgumentType)BoolArgumentType.bool()).then(net.minecraft.commands.Commands.argument((String)"ignoreCooldown", (ArgumentType)BoolArgumentType.bool()).executes(Commands::executeForceSpawnFullArgs))).executes(Commands::executeForceSpawnConsumeOnly))).executes(Commands::executeForceSpawnTargetOnly))).then(((RequiredArgumentBuilder)net.minecraft.commands.Commands.argument((String)"consumeVoucher", (ArgumentType)BoolArgumentType.bool()).then(net.minecraft.commands.Commands.argument((String)"ignoreCooldown", (ArgumentType)BoolArgumentType.bool()).executes(Commands::executeForceSpawnSelfFlags))).executes(Commands::executeForceSpawnSelfConsume))).executes(Commands::executeForceSpawnSelfOnly)));
        dispatcher.register(baseCommand);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"mal").requires(source -> Commands.hasPermission(source, Commands.PERMISSIONS.ACCESS_PERMISSION))).redirect(dispatcher.getRoot().getChild("mythsandlegends")));
        MythsAndLegends.getLogger().info("Registered Myths and Legends commands (using /mythsandlegends or /mal)");
    }

    private static boolean getOptionalBoolean(CommandContext<CommandSourceStack> context, String argName, boolean defaultValue) {
        try {
            return BoolArgumentType.getBool(context, (String)argName);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    private static ServerPlayer getTargetPlayerOptional(CommandContext<CommandSourceStack> context, String argumentName) throws CommandSyntaxException {
        try {
            return EntityArgument.getPlayer(context, (String)argumentName);
        }
        catch (IllegalArgumentException e) {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            if (source.getPlayer() != null) {
                return source.getPlayerOrException();
            }
            throw REQUIRES_PLAYER_EXCEPTION.create();
        }
    }

    private static int executeListItemsSelf(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return Commands.listItems(((CommandSourceStack)context.getSource()).getPlayerOrException(), (CommandSourceStack)context.getSource());
    }

    private static int executeListItemsTarget(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return Commands.listItems(EntityArgument.getPlayer(context, (String)"player"), (CommandSourceStack)context.getSource());
    }

    private static int listItems(ServerPlayer player, CommandSourceStack feedbackSource) {
        PlayerDataUtils.PlayerData playerData = PlayerDataUtils.getPlayerData((Player)player);
        String itemsWithCounts = playerData.getFormattedItemsWithCounts();
        String playerName = player.getName().getString();
        if (itemsWithCounts.isEmpty()) {
            feedbackSource.sendSuccess(() -> Component.translatable((String)"commands.mythsandlegends.items.none", (Object[])new Object[]{playerName}), false);
        } else {
            feedbackSource.sendSuccess(() -> Component.translatable((String)"commands.mythsandlegends.items.success", (Object[])new Object[]{playerName, itemsWithCounts}), false);
        }
        return 1;
    }

    private static int executeSyncItemsSelf(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return Commands.syncItems(((CommandSourceStack)context.getSource()).getPlayerOrException(), (CommandSourceStack)context.getSource());
    }

    private static int executeSyncItemsTarget(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return Commands.syncItems(EntityArgument.getPlayer(context, (String)"player"), (CommandSourceStack)context.getSource());
    }

    private static int syncItems(ServerPlayer player, CommandSourceStack feedbackSource) {
        PlayerDataUtils.updatePlayerData((Player)player);
        feedbackSource.sendSuccess(() -> Component.translatable((String)"commands.mythsandlegends.syncitems.success", (Object[])new Object[]{player.getName().getString()}), false);
        return 1;
    }

    private static int executeListPartySelf(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return Commands.listParty(((CommandSourceStack)context.getSource()).getPlayerOrException(), (CommandSourceStack)context.getSource());
    }

    private static int executeListPartyTarget(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return Commands.listParty(EntityArgument.getPlayer(context, (String)"player"), (CommandSourceStack)context.getSource());
    }

    private static int listParty(ServerPlayer player, CommandSourceStack feedbackSource) {
        List<Pokemon> pokemons = PlayerPartyUtils.getPokemonsInPlayerParty(player);
        String playerName = player.getName().getString();
        if (pokemons.isEmpty()) {
            feedbackSource.sendSuccess(() -> Component.translatable((String)"commands.mythsandlegends.party.none", (Object[])new Object[]{playerName}), false);
        } else {
            String pokemonList = pokemons.stream().map(pokemon -> String.format("%s (%s)", pokemon.getDisplayName(true).getString(), pokemon.getSpecies().getName())).collect(Collectors.joining(", "));
            feedbackSource.sendSuccess(() -> Component.translatable((String)"commands.mythsandlegends.party.success", (Object[])new Object[]{playerName, pokemonList}), false);
        }
        return 1;
    }

    private static int executeCheckPokemonSelf(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String speciesNameToCheck = StringArgumentType.getString(context, (String)"pokemon_species");
        return Commands.checkPokemon(((CommandSourceStack)context.getSource()).getPlayerOrException(), speciesNameToCheck, (CommandSourceStack)context.getSource());
    }

    private static int executeCheckPokemonTarget(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String speciesNameToCheck = StringArgumentType.getString(context, (String)"pokemon_species");
        return Commands.checkPokemon(EntityArgument.getPlayer(context, (String)"player"), speciesNameToCheck, (CommandSourceStack)context.getSource());
    }

    private static int checkPokemon(ServerPlayer player, String speciesNameToCheck, CommandSourceStack feedbackSource) throws CommandSyntaxException {
        if (Commands.isValidSpecies(speciesNameToCheck)) {
            throw INVALID_SPECIES_EXCEPTION.create();
        }
        String playerName = player.getName().getString();
        if (Commands.hasPokemon(player, speciesNameToCheck)) {
            feedbackSource.sendSuccess(() -> Component.translatable((String)"commands.mythsandlegends.haspokemon.yes", (Object[])new Object[]{playerName, speciesNameToCheck}), false);
        } else {
            feedbackSource.sendSuccess(() -> Component.translatable((String)"commands.mythsandlegends.haspokemon.no", (Object[])new Object[]{playerName, speciesNameToCheck}), false);
        }
        return 1;
    }

    private static int executePlaceIfHasSelf(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        String speciesName = StringArgumentType.getString(context, (String)"pokemon_species");
        BlockPos pos = BlockPosArgument.getLoadedBlockPos(context, (String)"pos");
        BlockInput block = BlockStateArgument.getBlock(context, (String)"block");
        return Commands.placeIfHas(player, speciesName, pos, block, (CommandSourceStack)context.getSource());
    }

    private static int executePlaceIfHasTarget(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"player");
        String speciesName = StringArgumentType.getString(context, (String)"pokemon_species");
        BlockPos pos = BlockPosArgument.getLoadedBlockPos(context, (String)"pos");
        BlockInput block = BlockStateArgument.getBlock(context, (String)"block");
        return Commands.placeIfHas(player, speciesName, pos, block, (CommandSourceStack)context.getSource());
    }

    private static int placeIfHas(ServerPlayer playerToCheck, String speciesName, BlockPos pos, BlockInput block, CommandSourceStack feedbackSource) throws CommandSyntaxException {
        if (Commands.isValidSpecies(speciesName)) {
            throw INVALID_SPECIES_EXCEPTION.create();
        }
        String playerName = playerToCheck.getName().getString();
        if (!Commands.hasPokemon(playerToCheck, speciesName)) {
            feedbackSource.sendFailure((Component)Component.translatable((String)"commands.mythsandlegends.placeifhas.failure_condition", (Object[])new Object[]{playerName, speciesName}));
            return 0;
        }
        ServerLevel world = feedbackSource.getLevel();
        if (!block.place(world, pos, 2)) {
            feedbackSource.sendFailure((Component)Component.translatable((String)"commands.mythsandlegends.placeifhas.failure_setblock", (Object[])new Object[]{block.getState().toString(), pos.getX(), pos.getY(), pos.getZ()}));
            Narrator.LOGGER.error("Failed to set block {} at {}", (Object)block.getState().toString(), (Object)pos);
            return 0;
        }
        feedbackSource.sendSuccess(() -> Component.translatable((String)"commands.mythsandlegends.placeifhas.success", (Object[])new Object[]{block.getState().toString(), pos.getX(), pos.getY(), pos.getZ(), playerName, speciesName}), true);
        return 1;
    }

    private static int executeForceSpawnFullArgs(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer targetPlayer = EntityArgument.getPlayer(context, (String)"player");
        String keyItemPath = StringArgumentType.getString(context, (String)"keyitem");
        boolean consumeVoucher = BoolArgumentType.getBool(context, (String)"consumeVoucher");
        boolean ignoreCooldown = BoolArgumentType.getBool(context, (String)"ignoreCooldown");
        return Commands.forceSpawn(targetPlayer, keyItemPath, consumeVoucher, ignoreCooldown, (CommandSourceStack)context.getSource());
    }

    private static int executeForceSpawnConsumeOnly(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer targetPlayer = EntityArgument.getPlayer(context, (String)"player");
        String keyItemPath = StringArgumentType.getString(context, (String)"keyitem");
        boolean consumeVoucher = BoolArgumentType.getBool(context, (String)"consumeVoucher");
        boolean ignoreCooldown = false;
        return Commands.forceSpawn(targetPlayer, keyItemPath, consumeVoucher, ignoreCooldown, (CommandSourceStack)context.getSource());
    }

    private static int executeForceSpawnTargetOnly(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer targetPlayer = EntityArgument.getPlayer(context, (String)"player");
        String keyItemPath = StringArgumentType.getString(context, (String)"keyitem");
        boolean consumeVoucher = false;
        boolean ignoreCooldown = false;
        return Commands.forceSpawn(targetPlayer, keyItemPath, consumeVoucher, ignoreCooldown, (CommandSourceStack)context.getSource());
    }

    private static int executeForceSpawnSelfFlags(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer targetPlayer = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        String keyItemPath = StringArgumentType.getString(context, (String)"keyitem");
        boolean consumeVoucher = BoolArgumentType.getBool(context, (String)"consumeVoucher");
        boolean ignoreCooldown = BoolArgumentType.getBool(context, (String)"ignoreCooldown");
        return Commands.forceSpawn(targetPlayer, keyItemPath, consumeVoucher, ignoreCooldown, (CommandSourceStack)context.getSource());
    }

    private static int executeForceSpawnSelfConsume(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer targetPlayer = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        String keyItemPath = StringArgumentType.getString(context, (String)"keyitem");
        boolean consumeVoucher = BoolArgumentType.getBool(context, (String)"consumeVoucher");
        boolean ignoreCooldown = false;
        return Commands.forceSpawn(targetPlayer, keyItemPath, consumeVoucher, ignoreCooldown, (CommandSourceStack)context.getSource());
    }

    private static int executeForceSpawnSelfOnly(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer targetPlayer = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        String keyItemPath = StringArgumentType.getString(context, (String)"keyitem");
        boolean consumeVoucher = false;
        boolean ignoreCooldown = false;
        return Commands.forceSpawn(targetPlayer, keyItemPath, consumeVoucher, ignoreCooldown, (CommandSourceStack)context.getSource());
    }

    private static int forceSpawn(ServerPlayer player, String keyItemIdentifierPath, boolean consumeVoucher, boolean ignoreCooldown, CommandSourceStack feedbackSource) throws CommandSyntaxException {
        ResourceLocation itemId = ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)keyItemIdentifierPath);
        Item keyItem = BuiltInRegistries.ITEM.getOptional(itemId).orElse(null);
        if (keyItem == null || !(keyItem instanceof KeyItem)) {
            throw INVALID_KEY_ITEM_EXCEPTION.create();
        }
        InteractionResult result = ForceSpawningUtils.forceSpawnByKeyItem(player.level(), player, keyItemIdentifierPath, consumeVoucher, ignoreCooldown, feedbackSource);
        String playerName = player.getName().getString();
        switch (result) {
            case SUCCESS: {
                feedbackSource.sendSuccess(() -> Component.translatable((String)"commands.mythsandlegends.forcespawn.success", (Object[])new Object[]{playerName, keyItemIdentifierPath}), true);
                return 1;
            }
            case SUCCESS_NO_ITEM_USED: {
                feedbackSource.sendSuccess(() -> Component.translatable((String)"commands.mythsandlegends.forcespawn.success_no_spawn", (Object[])new Object[]{playerName, keyItemIdentifierPath}), false);
                return 1;
            }
            case FAIL: {
                return 0;
            }
        }
        MythsAndLegends.getLogger().warn("Unhandled ActionResult from forceSpawnByKeyItem: " + String.valueOf(result));
        feedbackSource.sendFailure((Component)Component.literal((String)"An unexpected error occurred during force spawn."));
        return 0;
    }

    private static int executeOpenSettingsGui(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayerOrException();
        ConfigVariables config = MythsAndLegends.getConfigManager().getConfig();
        ConfigGui configGui = new ConfigGui();
        configGui.openConfigGui(player, config, 1);
        source.sendSuccess(() -> Component.translatable((String)"commands.mythsandlegends.settings.success"), true);
        return 1;
    }

    private static ResourceLocation getTrackedItemId(CommandContext<CommandSourceStack> context, String argName) throws CommandSyntaxException {
        ResourceLocation itemId = ResourceLocationArgument.getId(context, (String)argName);
        Item item = BuiltInRegistries.ITEM.getOptional(itemId).orElse(null);
        if (item == null) {
            throw INVALID_COOLDOWN_ITEM_EXCEPTION.create((Object)itemId.toString());
        }
        return itemId;
    }

    private static int executeCheckCooldownSelf(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ResourceLocation itemId = Commands.getTrackedItemId(context, "item");
        return Commands.checkCooldown(player, itemId, (CommandSourceStack)context.getSource());
    }

    private static int executeCheckCooldownTarget(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"player");
        ResourceLocation itemId = Commands.getTrackedItemId(context, "item");
        return Commands.checkCooldown(player, itemId, (CommandSourceStack)context.getSource());
    }

    private static int checkCooldown(ServerPlayer player, ResourceLocation itemId, CommandSourceStack feedbackSource) {
        ItemCooldownStorage storage = MythsAndLegends.getItemCooldownStorage();
        ConfigVariables config = MythsAndLegends.getConfigManager().getConfig();
        UUID playerId = player.getUUID();
        String playerName = player.getName().getString();
        String itemName = itemId.toString();
        Item item = BuiltInRegistries.ITEM.getOptional(itemId).orElse(null);
        if (item == null || !Items.KEY_ITEM_IDS.contains(itemId)) {
            feedbackSource.sendFailure((Component)Component.translatable((String)"commands.mythsandlegends.error.item_not_tracked", (Object[])new Object[]{itemName}));
            return 0;
        }
        Map<ResourceLocation, List<Long>> playerCooldowns = storage.getCooldownsForPlayer(playerId);
        List specificTimestamps = playerCooldowns.getOrDefault(itemId, List.of());
        int baseMaxVouchers = config.force_spawning_vouchers;
        int baseCooldownSeconds = config.force_spawn_item_cooldown;
        int remainingTicks = ItemCooldownStorage.calculateRemainingCooldownTicks(storage, playerId, item, baseCooldownSeconds);
        String remainingTimeStr = Commands.formatTicksToTime(remainingTicks);
        boolean hasEnough = storage.hasEnoughVouchers(playerId, item, 1, baseMaxVouchers);
        MutableComponent statusText = Component.literal((String)"");
        if (config.global_item_cooldown || config.global_item_vouchers) {
            statusText.append((Component)Component.translatable((String)"commands.mythsandlegends.cooldown.check.global_note"));
            if (config.global_item_cooldown) {
                long l = playerCooldowns.getOrDefault(ItemCooldownStorage.GLOBAL_COOLDOWN_ID, List.of()).stream().findFirst().orElse(0L);
            }
            if (config.global_item_vouchers) {
                int totalUsed = 0;
                for (Map.Entry<ResourceLocation, List<Long>> entry : playerCooldowns.entrySet()) {
                    if (entry.getKey().equals((Object)ItemCooldownStorage.GLOBAL_COOLDOWN_ID) || !Items.KEY_ITEM_IDS.contains(entry.getKey())) continue;
                    totalUsed += entry.getValue().size();
                }
                statusText.append((Component)Component.translatable((String)"commands.mythsandlegends.cooldown.check.global_vouchers", (Object[])new Object[]{totalUsed, baseMaxVouchers}));
            }
        }
        statusText.append((Component)Component.translatable((String)"commands.mythsandlegends.cooldown.check.status", (Object[])new Object[]{playerName, itemName, specificTimestamps.size(), baseMaxVouchers, remainingTimeStr, hasEnough ? Component.translatable((String)"commands.mythsandlegends.cooldown.check.can_use") : Component.translatable((String)"commands.mythsandlegends.cooldown.check.cannot_use")}));
        feedbackSource.sendSuccess(() -> statusText, false);
        return 1;
    }

    private static int executeClearCooldownSelf(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ResourceLocation itemId = Commands.getTrackedItemId(context, "item");
        return Commands.clearCooldown(player, itemId, (CommandSourceStack)context.getSource());
    }

    private static int executeClearCooldownTarget(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"player");
        ResourceLocation itemId = Commands.getTrackedItemId(context, "item");
        return Commands.clearCooldown(player, itemId, (CommandSourceStack)context.getSource());
    }

    private static int clearCooldown(ServerPlayer player, ResourceLocation itemId, CommandSourceStack feedbackSource) {
        ItemCooldownStorage storage = MythsAndLegends.getItemCooldownStorage();
        storage.clearCooldown(player.getUUID(), itemId);
        feedbackSource.sendSuccess(() -> Component.translatable((String)"commands.mythsandlegends.cooldown.clear.success", (Object[])new Object[]{player.getName().getString(), itemId.toString()}), true);
        return 1;
    }

    private static int executeClearAllCooldownsSelf(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        return Commands.clearAllCooldowns(player, (CommandSourceStack)context.getSource());
    }

    private static int executeClearAllCooldownsTarget(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"player");
        return Commands.clearAllCooldowns(player, (CommandSourceStack)context.getSource());
    }

    private static int clearAllCooldowns(ServerPlayer player, CommandSourceStack feedbackSource) {
        ItemCooldownStorage storage = MythsAndLegends.getItemCooldownStorage();
        storage.clearAllCooldowns(player.getUUID());
        feedbackSource.sendSuccess(() -> Component.translatable((String)"commands.mythsandlegends.cooldown.clearall.success", (Object[])new Object[]{player.getName().getString()}), true);
        return 1;
    }

    private static boolean isValidSpecies(String speciesName) {
        return PokemonSpecies.INSTANCE.getSpecies().stream().noneMatch(species -> species.getName().equalsIgnoreCase(speciesName));
    }

    private static boolean hasPokemon(ServerPlayer player, String speciesName) {
        return PlayerPartyUtils.getPokemonsInPlayerParty(player).stream().anyMatch(pokemon -> pokemon.getSpecies().getName().equalsIgnoreCase(speciesName));
    }

    public static String formatTicksToTime(int ticks) {
        if (ticks <= 0) {
            return "0s";
        }
        long totalSeconds = ticks / 20;
        long minutes = TimeUnit.SECONDS.toMinutes(totalSeconds);
        long seconds = totalSeconds % 60L;
        if (minutes > 0L) {
            return String.format("%dm %ds", minutes, seconds);
        }
        return String.format("%ds", seconds);
    }
}

