/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.pokemon.custom;

import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.position.FishingSpawnablePosition;
import com.cobblemon.mod.common.api.spawning.position.SpawnablePosition;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.MythsAndLegendsConditions;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.pokemon.PokemonCondition;
import com.github.d0ctorleon.mythsandlegends.utils.PlayerPartyUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class CustomPokemonInPartyCondition
implements PokemonCondition {
    List<CustomConditionPokemonInTeam> pokemon_in_party_requirement;

    public boolean fits(@NotNull SpawnablePosition spawnablePosition) {
        FishingSpawnablePosition fishingSpawnablePosition;
        SpawnCause fishingContextCause;
        Entity causeEntity;
        if (this.pokemon_in_party_requirement == null || this.pokemon_in_party_requirement.isEmpty()) {
            return true;
        }
        ServerPlayer targetPlayer = null;
        Spawner spawner = spawnablePosition.getSpawner();
        if (spawner instanceof PlayerSpawner) {
            PlayerSpawner playerSpawner = (PlayerSpawner)spawner;
            targetPlayer = MythsAndLegendsConditions.getPlayerFromUUID(spawnablePosition.getWorld(), playerSpawner.getUuid());
        } else if (spawnablePosition instanceof FishingSpawnablePosition && (causeEntity = (fishingContextCause = (fishingSpawnablePosition = (FishingSpawnablePosition)spawnablePosition).getCause()).getEntity()) instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity;
            targetPlayer = serverPlayerEntity = (ServerPlayer)causeEntity;
        }
        if (targetPlayer != null) {
            List<Pokemon> partyPokemons = PlayerPartyUtils.getPokemonsInPlayerParty(targetPlayer);
            for (CustomConditionPokemonInTeam requirement : this.pokemon_in_party_requirement) {
                if (requirement == null || requirement.species == null || requirement.species.isBlank()) continue;
                int requiredCount = requirement.getCount();
                long countInParty = partyPokemons.stream().filter(pokemon -> pokemon != null && pokemon.getSpecies() != null).filter(pokemon -> requirement.species.equalsIgnoreCase(pokemon.getSpecies().showdownId())).count();
                if (countInParty >= (long)requiredCount) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public List<CustomConditionPokemonInTeam> getPokemonConditions() {
        return this.pokemon_in_party_requirement;
    }

    @Override
    public List<String> getPokemonShowdownIDs() {
        if (this.pokemon_in_party_requirement == null || this.pokemon_in_party_requirement.isEmpty()) {
            return Collections.emptyList();
        }
        return this.pokemon_in_party_requirement.stream().filter(Objects::nonNull).map(condition -> condition.species).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static class CustomConditionPokemonInTeam {
        public String species;
        public Integer count;

        public String getSpecies() {
            return this.species;
        }

        public Integer getCount() {
            return this.count;
        }
    }
}

