/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.item.custom;

import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.condition.AppendageCondition;
import com.cobblemon.mod.common.api.spawning.position.FishingSpawnablePosition;
import com.cobblemon.mod.common.api.spawning.position.SpawnablePosition;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.MythsAndLegendsConditions;
import com.github.d0ctorleon.mythsandlegends.utils.PlayerDataUtils;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class CustomItemsCondition
implements AppendageCondition {
    List<CustomItemCondition> item_requirement;

    public boolean fits(@NotNull SpawnablePosition spawningContext) {
        FishingSpawnablePosition fishingSpawnablePosition;
        SpawnCause fishingContextCause;
        Entity causeEntity;
        if (this.item_requirement == null || this.item_requirement.isEmpty()) {
            return true;
        }
        ServerPlayer targetPlayer = null;
        Spawner spawner = spawningContext.getSpawner();
        if (spawner instanceof PlayerSpawner) {
            PlayerSpawner playerSpawner = (PlayerSpawner)spawner;
            targetPlayer = MythsAndLegendsConditions.getPlayerFromUUID(spawningContext.getWorld(), playerSpawner.getUuid());
        } else if (spawningContext instanceof FishingSpawnablePosition && (causeEntity = (fishingContextCause = (fishingSpawnablePosition = (FishingSpawnablePosition)spawningContext).getCause()).getEntity()) instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity;
            targetPlayer = serverPlayerEntity = (ServerPlayer)causeEntity;
        }
        if (targetPlayer != null) {
            PlayerDataUtils.PlayerData data = PlayerDataUtils.getPlayerData(targetPlayer);
            if (data == null) {
                return false;
            }
            for (CustomItemCondition requirement : this.item_requirement) {
                if (requirement == null || requirement.id == null) continue;
                int requiredCount = requirement.getCount();
                Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)requirement.id));
                if (item == null || item == BuiltInRegistries.ITEM.get(BuiltInRegistries.ITEM.getDefaultKey()) || item == Items.AIR) {
                    MythsAndLegends.getLogger().debug("Custom item requirement " + requirement.id + " not found");
                    return false;
                }
                if (data.getItemCount(item) >= requiredCount) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public List<CustomItemCondition> getItemConditions() {
        return this.item_requirement;
    }

    public static class CustomItemCondition
    implements Comparable<CustomItemCondition> {
        public String id;
        public Integer count;
        public boolean consume;

        @Override
        public int compareTo(@NotNull CustomItemCondition o) {
            if (this.id.compareTo(o.id) == 0) {
                return o.count - this.count;
            }
            return this.id.compareTo(o.id);
        }

        public String getItemIdString() {
            return this.id;
        }

        public Integer getCount() {
            return this.count;
        }

        public ResourceLocation getItemId() {
            if (this.id == null) {
                MythsAndLegends.getLogger().debug("CustomItemsCondition: id is null when calling getItemId()");
                return null;
            }
            try {
                return ResourceLocation.parse((String)this.id);
            }
            catch (Exception e) {
                MythsAndLegends.getLogger().debug("Failed to parse customitem identifier: " + this.id, (Throwable)e);
                return null;
            }
        }

        public boolean isConsume() {
            return this.consume;
        }
    }
}

