/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.item;

import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.position.FishingSpawnablePosition;
import com.cobblemon.mod.common.api.spawning.position.SpawnablePosition;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.MythsAndLegendsConditions;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.item.KeyItemCondition;
import com.github.d0ctorleon.mythsandlegends.utils.PlayerDataUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyItemConditions {

    public static class KeyItem
    implements KeyItemCondition {
        public String key_item;

        public boolean fits(@NotNull SpawnablePosition spawnablePosition) {
            FishingSpawnablePosition fishingSpawnablePosition;
            SpawnCause fishingContextCause;
            Entity causeEntity;
            if (this.key_item == null) {
                return true;
            }
            ServerPlayer targetPlayer = null;
            Spawner spawner = spawnablePosition.getSpawner();
            if (spawner instanceof PlayerSpawner) {
                PlayerSpawner playerSpawner = (PlayerSpawner)spawner;
                targetPlayer = MythsAndLegendsConditions.getPlayerFromUUID(spawnablePosition.getWorld(), playerSpawner.getUuid());
            } else if (spawnablePosition instanceof FishingSpawnablePosition && (causeEntity = (fishingContextCause = (fishingSpawnablePosition = (FishingSpawnablePosition)spawnablePosition).getCause()).getEntity()) instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity;
                targetPlayer = serverPlayerEntity = (ServerPlayer)causeEntity;
            }
            if (targetPlayer != null) {
                PlayerDataUtils.PlayerData data = PlayerDataUtils.getPlayerData(targetPlayer);
                if (data == null) {
                    return false;
                }
                ResourceLocation fullItemId = this.getKeyItemId();
                Item item = (Item)BuiltInRegistries.ITEM.get(fullItemId);
                if (item == BuiltInRegistries.ITEM.get(BuiltInRegistries.ITEM.getDefaultKey())) {
                    MythsAndLegends.getLogger().debug("Warning: Key item not found in registry: " + String.valueOf(fullItemId) + String.valueOf(item));
                    return false;
                }
                return data.getItemCount(item) >= 1;
            }
            return false;
        }

        @Override
        @Nullable
        public ResourceLocation getKeyItemId() {
            if (this.key_item == null) {
                return null;
            }
            try {
                return ResourceLocation.parse((String)this.key_item);
            }
            catch (Exception e) {
                MythsAndLegends.getLogger().debug("Failed to parse key_item identifier: " + this.key_item, (Throwable)e);
                return null;
            }
        }

        @Override
        public String getKeyItemIdString() {
            return this.key_item;
        }
    }
}

