/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.cobblemon.events;

import com.cobblemon.mod.common.api.events.entity.SpawnEvent;
import com.cobblemon.mod.common.api.spawning.position.SpawnablePosition;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.MythsAndLegendsConditions;
import com.github.d0ctorleon.mythsandlegends.configs.BroadcastConfig;
import com.github.d0ctorleon.mythsandlegends.configs.ConfigVariables;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class SpawnEventListener {
    public static void onPokemonSpawn(SpawnEvent<PokemonEntity> event) {
        boolean sendWaypointMessage;
        PlayerSpawner playerSpawner;
        boolean shouldBroadcastShiny;
        ConfigVariables config = MythsAndLegends.getConfigManager().getConfig();
        boolean isBroadcastEnabled = config.isBroadcastEnabled;
        if (!isBroadcastEnabled) {
            return;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)event.getEntity();
        Pokemon pokemon = pokemonEntity.getPokemon();
        if (pokemon.isPlayerOwned()) {
            return;
        }
        boolean isLegendary = pokemon.isLegendary();
        boolean isMythical = pokemon.isMythical();
        boolean isUltraBeast = pokemon.isUltraBeast();
        boolean isShiny = pokemon.getShiny();
        boolean bl = shouldBroadcastShiny = SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "Shiny") && isShiny;
        if (!(isLegendary || isMythical || isUltraBeast || shouldBroadcastShiny)) {
            return;
        }
        SpawnablePosition spawnablePosition = event.getSpawnablePosition();
        Spawner spawner = spawnablePosition.getSpawner();
        ServerPlayer player = null;
        MinecraftServer server = null;
        ServerLevel world = spawnablePosition.getWorld();
        if (spawner instanceof PlayerSpawner && (player = MythsAndLegendsConditions.getPlayerFromUUID(world, (playerSpawner = (PlayerSpawner)spawner).getUuid())) != null) {
            server = player.getServer();
        }
        if (server == null && world != null) {
            server = world.getServer();
        }
        if (server == null) {
            System.err.println("MythsAndLegends: Could not obtain MinecraftServer instance for broadcasting.");
            return;
        }
        MutableComponent PokemonDisplayName = pokemon.getDisplayName(true);
        String pokemonNameString = pokemon.getDisplayName(true).getString();
        BlockPos pos = pokemonEntity.blockPosition();
        MutableComponent message = Component.translatable((String)"chat.mythsandlegends.broadcast.spawn", (Object[])new Object[]{PokemonDisplayName});
        if (SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "Location")) {
            message.append((Component)Component.translatable((String)"chat.mythsandlegends.broadcast.location", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}).withStyle(ChatFormatting.GREEN));
        }
        if (pokemon.isLegendary() && SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "Legendarys")) {
            message.append((Component)Component.translatable((String)"chat.mythsandlegends.broadcast.legendary").withStyle(ChatFormatting.GOLD));
        }
        if (pokemon.isMythical() && SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "Mythicals")) {
            message.append((Component)Component.translatable((String)"chat.mythsandlegends.broadcast.mythical").withStyle(ChatFormatting.DARK_PURPLE));
        }
        if (pokemon.isUltraBeast() && SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "UltraBeasts")) {
            message.append((Component)Component.translatable((String)"chat.mythsandlegends.broadcast.ultrabeast").withStyle(ChatFormatting.DARK_AQUA));
        }
        if (pokemon.getShiny() && SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "Shiny")) {
            message.append((Component)Component.translatable((String)"chat.mythsandlegends.broadcast.shiny").withStyle(ChatFormatting.LIGHT_PURPLE));
        }
        if (SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "Level")) {
            int level = pokemon.getLevel();
            message.append((Component)Component.translatable((String)"chat.mythsandlegends.broadcast.level", (Object[])new Object[]{level}).withStyle(ChatFormatting.YELLOW));
        }
        if (sendWaypointMessage = SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "XaerosMinimapSupport")) {
            ResourceKey worldRegistryKey = world.dimension();
            String dimensionName = worldRegistryKey.location().getPath();
            String waypointSet = "Internal-" + dimensionName + "-waypoints";
            String symbol = "P";
            int colorIndex = 8;
            String waypointString = String.format("xaero-waypoint:%s:%s:%d:%d:%d:%d:false:0:%s", pokemonNameString.replace(":", ""), symbol, pos.getX(), pos.getY(), pos.getZ(), colorIndex, waypointSet);
            MutableComponent waypointText = Component.literal((String)waypointString);
            if (SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "BroadcastToAll")) {
                SpawnEventListener.broadcastMessageToServer((Component)message, server);
                SpawnEventListener.broadcastMessageToServer((Component)waypointText, server);
            } else if (player != null) {
                player.displayClientMessage((Component)message, false);
                player.displayClientMessage((Component)waypointText, false);
            }
        } else if (SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "BroadcastToAll")) {
            if (server != null) {
                SpawnEventListener.broadcastMessageToServer((Component)message, server);
            }
        } else if (player != null) {
            player.displayClientMessage((Component)message, false);
        }
    }

    public static boolean findBroadcastConfig(List<BroadcastConfig> settings, String settingName) {
        for (BroadcastConfig setting : settings) {
            if (!Objects.equals(setting.settingName, settingName)) continue;
            return setting.settingValue;
        }
        return false;
    }

    private static void broadcastMessageToServer(Component message, MinecraftServer server) {
        if (server == null) {
            System.err.println("MythsAndLegends: Attempted to broadcast with null server!");
            return;
        }
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            player.displayClientMessage(message, false);
        }
    }
}

