/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.client.events.cobblemon;

import com.cobblemon.mod.common.api.events.pokemon.interaction.PokemonInteractionGUICreationEvent;
import com.cobblemon.mod.common.client.gui.interact.wheel.InteractWheelOption;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.client.ClientSyncedConfig;
import com.github.d0ctorleon.mythsandlegends.items.ZygardeCubeBundleItem;
import com.github.d0ctorleon.mythsandlegends.net.TriggerTransformationPacket;
import com.github.d0ctorleon.mythsandlegends.net.TriggerZygardeActionPacket;
import dev.architectury.networking.NetworkManager;
import java.util.UUID;
import kotlin.Unit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CobblemonGuiEventHandler {
    private static boolean fusionOptionsEnabled = true;
    private static boolean interactionOptionsEnabled = true;
    private static boolean zygardeOptionsEnabled = true;

    public static void setFusionOptionsEnabled(boolean enabled) {
        fusionOptionsEnabled = enabled;
    }

    public static boolean isFusionOptionsEnabled() {
        return fusionOptionsEnabled;
    }

    public static void setInteractionOptionsEnabled(boolean enabled) {
        interactionOptionsEnabled = enabled;
    }

    public static boolean isInteractionOptionsEnabled() {
        return interactionOptionsEnabled;
    }

    public static void setZygardeOptionsEnabled(boolean enabled) {
        zygardeOptionsEnabled = enabled;
    }

    public static boolean isZygardeOptionsEnabled() {
        return zygardeOptionsEnabled;
    }

    public static void handlePokemonInteractionGUICreation(PokemonInteractionGUICreationEvent event) {
        Minecraft client = Minecraft.getInstance();
        LocalPlayer player = client.player;
        if (player == null) {
            return;
        }
        ItemStack heldStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (heldStack.isEmpty()) {
            return;
        }
        UUID pokemonUuid = event.getPokemonID();
        Item heldItem = heldStack.getItem();
        if (ClientSyncedConfig.isFusionItem(heldItem)) {
            MythsAndLegends.getLogger().debug("Held item {} matches a synced fusion rule, adding GUI option.", (Object)BuiltInRegistries.ITEM.getKey((Object)heldItem));
            InteractWheelOption fusionOption = new InteractWheelOption(ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"textures/gui/interact/icon_fuse.png"), null, fusionOptionsEnabled, "mythsandlegends.ui.interact.fuse.tooltip", () -> null, () -> {
                if (!fusionOptionsEnabled) {
                    return Unit.INSTANCE;
                }
                MythsAndLegends.getLogger().debug("Fusion wheel option pressed for {}", (Object)pokemonUuid);
                TriggerTransformationPacket packet = new TriggerTransformationPacket(pokemonUuid);
                NetworkManager.sendToServer((CustomPacketPayload)packet);
                client.setScreen(null);
                return Unit.INSTANCE;
            });
            event.addFillingOption(fusionOption);
            MythsAndLegends.getLogger().debug("Added fusion option to interaction wheel.");
        }
        if (ClientSyncedConfig.isInteractionItem(heldItem)) {
            MythsAndLegends.getLogger().debug("Held item {} matches a synced interaction rule, adding GUI option.", (Object)BuiltInRegistries.ITEM.getKey((Object)heldItem));
            InteractWheelOption interactionOption = new InteractWheelOption(ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"textures/gui/interact/icon_change_form.png"), null, interactionOptionsEnabled, "mythsandlegends.ui.interact.change_form.tooltip", () -> null, () -> {
                if (!interactionOptionsEnabled) {
                    return Unit.INSTANCE;
                }
                MythsAndLegends.getLogger().debug("Interaction change wheel option pressed for {}", (Object)pokemonUuid);
                TriggerTransformationPacket packet = new TriggerTransformationPacket(pokemonUuid);
                NetworkManager.sendToServer((CustomPacketPayload)packet);
                client.setScreen(null);
                return Unit.INSTANCE;
            });
            event.addFillingOption(interactionOption);
            MythsAndLegends.getLogger().debug("Added interaction transformation option to interaction wheel.");
        }
        if (heldItem instanceof ZygardeCubeBundleItem) {
            MythsAndLegends.getLogger().debug("Held item is Zygarde Cube, adding Zygarde options (server will validate).");
            InteractWheelOption zygardeTransformOption = new InteractWheelOption(ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"textures/gui/interact/icon_zygarde_transform.png"), null, zygardeOptionsEnabled, "mythsandlegends.ui.interact.zygarde_transform.tooltip", () -> null, () -> {
                if (!zygardeOptionsEnabled) {
                    return Unit.INSTANCE;
                }
                MythsAndLegends.getLogger().debug("Zygarde Transform wheel option pressed for {}", (Object)pokemonUuid);
                TriggerZygardeActionPacket packet = new TriggerZygardeActionPacket(pokemonUuid, TriggerZygardeActionPacket.ZygardeActionType.TRANSFORM);
                NetworkManager.sendToServer((CustomPacketPayload)packet);
                client.setScreen(null);
                return Unit.INSTANCE;
            });
            event.addFillingOption(zygardeTransformOption);
            InteractWheelOption zygardeChargeOption = new InteractWheelOption(ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"textures/gui/interact/icon_zygarde_charge.png"), null, zygardeOptionsEnabled, "mythsandlegends.ui.interact.zygarde_charge.tooltip", () -> null, () -> {
                if (!zygardeOptionsEnabled) {
                    return Unit.INSTANCE;
                }
                MythsAndLegends.getLogger().debug("Zygarde Charge wheel option pressed for {}", (Object)pokemonUuid);
                TriggerZygardeActionPacket packet = new TriggerZygardeActionPacket(pokemonUuid, TriggerZygardeActionPacket.ZygardeActionType.CHARGE);
                NetworkManager.sendToServer((CustomPacketPayload)packet);
                client.setScreen(null);
                return Unit.INSTANCE;
            });
            event.addFillingOption(zygardeChargeOption);
            MythsAndLegends.getLogger().debug("Added Zygarde Transform and Charge options to interaction wheel.");
        }
    }
}

