/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.entity.SpawnEvent;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.github.d0ctorleon.mythsandlegends.cobblemon.events.HeldItemUpdateEventListener;
import com.github.d0ctorleon.mythsandlegends.cobblemon.events.SpawnEventListener;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.MythsAndLegendsConditions;
import com.github.d0ctorleon.mythsandlegends.commands.Commands;
import com.github.d0ctorleon.mythsandlegends.configs.ConfigManager;
import com.github.d0ctorleon.mythsandlegends.events.LifeCycleEvents;
import com.github.d0ctorleon.mythsandlegends.events.PlayerEvents;
import com.github.d0ctorleon.mythsandlegends.events.TickEvents;
import com.github.d0ctorleon.mythsandlegends.items.CreativeTab;
import com.github.d0ctorleon.mythsandlegends.items.Items;
import com.github.d0ctorleon.mythsandlegends.loot.LootTableModifier;
import com.github.d0ctorleon.mythsandlegends.net.MythsAndLegendsNetworking;
import com.github.d0ctorleon.mythsandlegends.utils.DebtUtils;
import com.github.d0ctorleon.mythsandlegends.utils.ItemCooldownStorage;
import com.github.d0ctorleon.mythsandlegends.utils.PlayerDataUtils;
import com.github.d0ctorleon.mythsandlegends.utils.TransformationHelper;
import dev.architectury.platform.Platform;
import kotlin.Unit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;

public class MythsAndLegends {
    public static final String MOD_ID = "mythsandlegends";
    public static final String OLD_MOD_ID = "myths_and_legends";
    private static final Logger LOGGER = LogManager.getLogger((String)"mythsandlegends");
    private static ConfigManager configManager;
    private static ItemCooldownStorage cooldownStorage;
    private static DebtUtils debtUtils;

    public static void init() {
        MythsAndLegends.initializeManagers();
        MythsAndLegends.registerItemsAndGroups();
        MythsAndLegends.registerLootModifiers();
        MythsAndLegends.registerEvents();
        Commands.registerCommands();
        MythsAndLegendsConditions.register();
        MythsAndLegends.registerCobblemonEvents();
        MythsAndLegendsNetworking.init();
    }

    private static void registerItemsAndGroups() {
        Items.registerItems();
        CreativeTab.TABS.register();
    }

    private static void initializeManagers() {
        configManager = new ConfigManager();
        PlayerDataUtils.setModConfig(configManager.getConfig());
        cooldownStorage = new ItemCooldownStorage(Platform.getConfigFolder().resolve(MOD_ID));
        debtUtils = new DebtUtils(Platform.getConfigFolder().resolve(MOD_ID));
    }

    private static void registerLootModifiers() {
        LootTableModifier.registerLootModifications();
    }

    private static void registerEvents() {
        new TickEvents();
        new PlayerEvents();
        new LifeCycleEvents();
    }

    public static void registerCobblemonEvents() {
        CobblemonEvents.POKEMON_ENTITY_SPAWN.subscribe(Priority.NORMAL, event -> {
            SpawnEventListener.onPokemonSpawn((SpawnEvent<PokemonEntity>)event);
            return Unit.INSTANCE;
        });
        CobblemonEvents.HELD_ITEM_POST.subscribe(Priority.NORMAL, event -> {
            HeldItemUpdateEventListener.onHeldItemPost(event);
            return Unit.INSTANCE;
        });
        CobblemonEvents.POKEMON_ENTITY_LOAD.subscribe(Priority.NORMAL, event -> {
            TransformationHelper.checkAndApplyPersistentForm(event.component1().getPokemon());
            return Unit.INSTANCE;
        });
    }

    public static ConfigManager getConfigManager() {
        return configManager;
    }

    public static ItemCooldownStorage getItemCooldownStorage() {
        return cooldownStorage;
    }

    public static DebtUtils getDebtUtils() {
        return debtUtils;
    }

    public static Logger getLogger() {
        boolean debug = false;
        if (configManager != null && configManager.getConfig() != null) {
            debug = MythsAndLegends.configManager.getConfig().debug_mode;
        }
        if (debug) {
            Configurator.setLevel((String)MOD_ID, (Level)Level.ALL);
        } else {
            Configurator.setLevel((String)MOD_ID, (Level)Level.INFO);
        }
        return LOGGER;
    }
}

