/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.data;

import de.cristelknight.cristellib.CristelLib;
import de.cristelknight.cristellib.CristelLibExpectPlatform;
import de.cristelknight.cristellib.config.ConfigManager;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class PathFinder {
    public static List<Path> getPathsInDir(String modId, String subPath) {
        ArrayList<Path> paths = new ArrayList<Path>();
        PathFinder.findInFiles(CristelLibExpectPlatform.getRootPaths(modId), modId, subPath, x$0 -> Files.exists(x$0, new LinkOption[0]), (path, file) -> {
            if (Files.isRegularFile(file, new LinkOption[0]) && file.getFileName().toString().endsWith(".json")) {
                paths.add((Path)file);
            }
            return true;
        }, true, Integer.MAX_VALUE);
        return paths;
    }

    private static void findInFiles(List<Path> rootPaths, String modId, String subPath, Predicate<Path> rootFilter, BiFunction<Path, Path, Boolean> processor, boolean visitAllFiles, int maxDepth) {
        try {
            if (modId.equals("minecraft")) {
                PathFinder.walk(ConfigManager.CONFIG_LIB.resolve(subPath), rootFilter, processor, visitAllFiles, maxDepth);
                return;
            }
            PathFinder.findInModFiles(rootPaths, modId, String.format("data/cristellib/%s", subPath), rootFilter, processor, visitAllFiles, maxDepth);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void findInModFiles(List<Path> rootPaths, String modId, String subPath, Predicate<Path> rootFilter, BiFunction<Path, Path, Boolean> processor, boolean visitAllFiles, int maxDepth) throws IOException {
        boolean hasOldPath = false;
        boolean hasNewPath = false;
        for (Path root : rootPaths) {
            Path newPath = root.resolve(subPath);
            if (!hasOldPath) {
                hasOldPath = Files.exists(root.resolve(subPath + "s"), new LinkOption[0]);
            }
            if (!hasNewPath) {
                hasNewPath = Files.exists(newPath, new LinkOption[0]);
            }
            PathFinder.walk(newPath, rootFilter, processor, visitAllFiles, maxDepth);
        }
        if (hasOldPath && !hasNewPath) {
            CristelLib.LOGGER.warn("Mod with id: {} only has an old path for subPath: {}. New Path for Cristel Lib >=2.0.1 is missing! Maybe contact the mod author to let them know.", (Object)modId, (Object)subPath);
        }
    }

    public static void walk(Path root, Predicate<Path> rootFilter, BiFunction<Path, Path, Boolean> processor, boolean visitAllFiles, int maxDepth) throws IOException {
        if (root == null || !Files.exists(root, new LinkOption[0]) || !rootFilter.test(root)) {
            return;
        }
        if (processor == null) {
            return;
        }
        try (Stream<Path> stream = Files.walk(root, maxDepth, new FileVisitOption[0]);){
            Iterator itr = stream.iterator();
            while (itr.hasNext()) {
                boolean keepGoing = processor.apply(root, (Path)itr.next());
                if (visitAllFiles || keepGoing) continue;
                return;
            }
        }
    }
}

