/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.item.predicates;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.model.modifier.item.ItemPredicate;
import com.supermartijn642.fusion.api.util.Either;
import com.supermartijn642.fusion.api.util.Serializer;
import net.minecraft.world.item.ItemStack;

public class CountItemPredicate
implements ItemPredicate {
    public static final Serializer<CountItemPredicate> SERIALIZER = new Serializer<CountItemPredicate>(){

        @Override
        public CountItemPredicate deserialize(JsonObject json) throws JsonParseException {
            if (!(json.has("min") || json.has("min_percentage") || json.has("max") || json.has("max_percentage"))) {
                throw new JsonParseException("Count-predicate must have at least one of 'min', 'min_percentage', 'max', or 'max_percentage'!");
            }
            if (json.has("min") && json.has("min_percentage")) {
                throw new JsonParseException("Count-predicate can have only either 'min' or 'min_percentage', not both!");
            }
            Either<Integer, Float> min = Either.left(0);
            if (json.has("min")) {
                if (!json.get("min").isJsonPrimitive() || !json.getAsJsonPrimitive("min").isNumber()) {
                    throw new JsonParseException("Property 'min' must be a number!");
                }
                int minValue = json.getAsJsonPrimitive("min").getAsInt();
                if (minValue < 0) {
                    throw new JsonParseException("Property 'min' must be a positive number!");
                }
                min = Either.left(minValue);
            }
            if (json.has("min_percentage")) {
                if (!json.get("min_percentage").isJsonPrimitive() || !json.getAsJsonPrimitive("min_percentage").isNumber()) {
                    throw new JsonParseException("Property 'min_percentage' must be a number!");
                }
                float minValue = json.getAsJsonPrimitive("min_percentage").getAsFloat();
                if (minValue < 0.0f || minValue > 1.0f) {
                    throw new JsonParseException("Property 'min_percentage' must be between 0 and 1!");
                }
                min = Either.right(Float.valueOf(minValue));
            }
            if (json.has("max") && json.has("max_percentage")) {
                throw new JsonParseException("Count-predicate can have only either 'max' or 'max_percentage', not both!");
            }
            Either<Integer, Float> max = Either.right(Float.valueOf(1.0f));
            if (json.has("max")) {
                if (!json.get("max").isJsonPrimitive() || !json.getAsJsonPrimitive("max").isNumber()) {
                    throw new JsonParseException("Property 'max' must be a number!");
                }
                int maxValue = json.getAsJsonPrimitive("max").getAsInt();
                if (maxValue < 0) {
                    throw new JsonParseException("Property 'max' must be a positive number!");
                }
                max = Either.left(maxValue);
            }
            if (json.has("max_percentage")) {
                if (!json.get("max_percentage").isJsonPrimitive() || !json.getAsJsonPrimitive("max_percentage").isNumber()) {
                    throw new JsonParseException("Property 'max_percentage' must be a number!");
                }
                float maxValue = json.getAsJsonPrimitive("max_percentage").getAsFloat();
                if (maxValue < 0.0f || maxValue > 1.0f) {
                    throw new JsonParseException("Property 'max_percentage' must be between 0 and 1!");
                }
                max = Either.right(Float.valueOf(maxValue));
            }
            if (min.isLeft() && max.isLeft() && min.left() > max.left() || min.isRight() && max.isRight() && ((Float)min.right()).floatValue() > max.right().floatValue()) {
                throw new JsonParseException("Minimum count must be less than or equal to maximum count!");
            }
            return new CountItemPredicate(min, max);
        }

        @Override
        public JsonObject serialize(CountItemPredicate value) {
            JsonObject json = new JsonObject();
            if (value.isMinPercentage) {
                json.addProperty("min_percentage", (Number)Float.valueOf(value.minPercentage));
            } else {
                json.addProperty("min", (Number)value.min);
            }
            if (value.isMaxPercentage) {
                json.addProperty("max_percentage", (Number)Float.valueOf(value.maxPercentage));
            } else {
                json.addProperty("max", (Number)value.max);
            }
            return json;
        }
    };
    private final int min;
    private final int max;
    private final float minPercentage;
    private final float maxPercentage;
    private final boolean isMinPercentage;
    private final boolean isMaxPercentage;

    public CountItemPredicate(Either<Integer, Float> min, Either<Integer, Float> max) {
        if (min.isLeft() && min.left() < 0) {
            throw new IllegalArgumentException("Minimum count must be a positive number!");
        }
        if (min.isRight() && (min.right().floatValue() < 0.0f || min.right().floatValue() > 1.0f)) {
            throw new IllegalArgumentException("Minimum percentage must be between 0 and 1!");
        }
        if (max.isLeft() && max.left() < 0) {
            throw new IllegalArgumentException("Maximum count must be a positive number!");
        }
        if (max.isRight() && (max.right().floatValue() < 0.0f || max.right().floatValue() > 1.0f)) {
            throw new IllegalArgumentException("Maximum percentage must be between 0 and 1!");
        }
        if (min.isLeft() && max.isLeft() && min.left() > max.left() || min.isRight() && max.isRight() && min.right().floatValue() > max.right().floatValue()) {
            throw new IllegalArgumentException("Minimum count must be less than or equal to maximum count!");
        }
        this.min = min.isLeft() ? min.left() : -1;
        this.max = max.isLeft() ? max.left() : -1;
        this.minPercentage = min.isRight() ? min.right().floatValue() : -1.0f;
        this.maxPercentage = max.isRight() ? max.right().floatValue() : -1.0f;
        this.isMinPercentage = min.isRight();
        this.isMaxPercentage = max.isRight();
    }

    @Override
    public boolean test(ItemStack stack) {
        int count = stack.getCount();
        return (this.isMinPercentage ? this.minPercentage * (float)stack.getItem().getDefaultMaxStackSize() <= (float)count : this.min <= count) && (this.isMaxPercentage ? this.maxPercentage * (float)stack.getItem().getDefaultMaxStackSize() >= (float)count : this.max >= count);
    }

    @Override
    public Serializer<? extends ItemPredicate> getSerializer() {
        return SERIALIZER;
    }
}

