/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.util;

import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class Lazy<T>
implements Supplier<T> {
    private final Supplier<T> valueSupplier;
    private transient T value;
    private volatile transient boolean initialized;

    private Lazy(Supplier<@NotNull T> valueSupplier) {
        this.valueSupplier = valueSupplier;
    }

    public static <T> Lazy<T> of(Supplier<@NotNull T> valueSupplier) {
        return new Lazy<T>(valueSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (!this.initialized) {
            Lazy lazy = this;
            synchronized (lazy) {
                if (!this.initialized) {
                    this.value = this.valueSupplier.get();
                    this.initialized = true;
                }
            }
        }
        return this.value;
    }

    public synchronized void invalidate() {
        this.initialized = false;
        this.value = null;
    }

    public String toString() {
        return "Lazy(" + String.valueOf(this.initialized ? this.value : "uninitialized") + ")";
    }
}

