/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config;

import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.config.manager.ConfigManager;
import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.EnumValue;
import dev.ftb.mods.ftblibrary.snbt.config.IntArrayValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftblibrary.snbt.config.StringSidebarMapValue;
import java.util.HashMap;
import java.util.Map;

public interface FTBLibraryClientConfig {
    public static final String KEY = "ftblibrary-client";
    public static final SNBTConfig CONFIG = (SNBTConfig)SNBTConfig.create("ftblibrary-client").comment("Client-specific configuration for FTB Library");
    public static final SNBTConfig TOOLTIPS = CONFIG.addGroup("tooltips");
    public static final BooleanValue ITEM_MODNAME = (BooleanValue)TOOLTIPS.addBoolean("item_modname", false).comment("Add the name of the mod that items belong to in the item selection GUI.\nNote that several common mods also do this (modnametooltip,WTHIT,EMI...) so this is false by default");
    public static final BooleanValue FLUID_MODNAME = (BooleanValue)TOOLTIPS.addBoolean("fluid_modname", true).comment("Add the name of the mod that fluids belong to in the fluid selection GUI.");
    public static final BooleanValue IMAGE_MODNAME = (BooleanValue)TOOLTIPS.addBoolean("image_modname", true).comment("Add the name of the mod that images belong to in the image selection GUI.");
    public static final BooleanValue ENTITY_MODNAME = (BooleanValue)TOOLTIPS.addBoolean("entity_modname", true).comment("Add the name of the mod that entities belong to in the entity face selection GUI.");
    public static final SNBTConfig COLOR = CONFIG.addGroup("colorselector");
    public static final IntArrayValue RECENT = (IntArrayValue)COLOR.addIntArray("recents", new int[0]).comment("Colors recently selected in the color selector");
    public static final SNBTConfig SIDEBAR = CONFIG.addGroup("sidebar");
    public static final BooleanValue SIDEBAR_ENABLED = (BooleanValue)SIDEBAR.addBoolean("enabled", true).comment("Enable the sidebar");
    public static final EnumValue<SidebarPosition> SIDEBAR_POSITION = (EnumValue)SIDEBAR.addEnum("position", SidebarPosition.NAME_MAP, SidebarPosition.TOP_LEFT).comment("Position of the sidebar");
    public static final StringSidebarMapValue SIDEBAR_BUTTONS = SIDEBAR.add(new StringSidebarMapValue(SIDEBAR, "buttons", (Map<String, StringSidebarMapValue.SideButtonInfo>)new HashMap<String, StringSidebarMapValue.SideButtonInfo>()));

    public static void save() {
        ConfigManager.getInstance().save(KEY);
    }

    public static enum SidebarPosition {
        TOP_LEFT(false, false),
        TOP_RIGHT(false, true),
        BOTTOM_LEFT(true, false),
        BOTTOM_RIGHT(true, true);

        public static final NameMap<SidebarPosition> NAME_MAP;
        private final boolean isBottom;
        private final boolean isRight;

        private SidebarPosition(boolean isBottom, boolean isRight) {
            this.isBottom = isBottom;
            this.isRight = isRight;
        }

        public boolean isBottom() {
            return this.isBottom;
        }

        public boolean isRight() {
            return this.isRight;
        }

        static {
            NAME_MAP = NameMap.of(TOP_LEFT, SidebarPosition.values()).baseNameKey("ftblibrary.panel.position").create();
        }
    }
}

