/*
 * Decompiled with CFR 0.152.
 */
package me.frankv.jmi.api.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import me.frankv.jmi.api.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMIEventBus {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JMIEventBus.class);
    private final Map<Class<? extends Event>, List<Consumer<? extends Event>>> eventHandlers = new HashMap<Class<? extends Event>, List<Consumer<? extends Event>>>();
    private boolean firstLogin = false;
    private boolean haveDim = false;

    public <T extends Event> void sendEvent(T event) {
        Optional.ofNullable(this.eventHandlers.get(event.getClass())).orElseGet(ArrayList::new).forEach(consumer -> consumer.accept(event));
    }

    public <T extends Event> void subscribe(Class<T> clazz, Consumer<T> consumer) {
        this.eventHandlers.computeIfAbsent(clazz, k -> new ArrayList()).add(consumer);
    }

    @Generated
    public boolean isFirstLogin() {
        return this.firstLogin;
    }

    @Generated
    public void setFirstLogin(boolean firstLogin) {
        this.firstLogin = firstLogin;
    }

    @Generated
    public boolean isHaveDim() {
        return this.haveDim;
    }

    @Generated
    public void setHaveDim(boolean haveDim) {
        this.haveDim = haveDim;
    }
}

