/*
 * Decompiled with CFR 0.152.
 */
package me.frankv.jmi;

import me.frankv.jmi.JMI;
import me.frankv.jmi.api.event.Event;
import me.frankv.jmi.api.event.JMIEventBus;
import me.frankv.jmi.config.NeoForgeClientConfig;
import me.frankv.jmi.jmdefaultconfig.JMDefaultConfig;
import me.frankv.jmi.waypointmessage.WaypointChatMessage;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="jmi")
public class JMINeoForge {
    public static final NeoForgeClientConfig CLIENT_CONFIG = new NeoForgeClientConfig();

    public JMINeoForge(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::setupClient);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_CONFIG.getSpec());
    }

    private void setupClient(FMLClientSetupEvent event) {
        JMI.init(CLIENT_CONFIG);
        new JMDefaultConfig().tryWriteJMDefaultConfig();
        this.registerEvent();
    }

    private void registerEvent() {
        JMIEventBus eventBus = JMI.getJmiEventBus();
        NeoForge.EVENT_BUS.addListener(e -> eventBus.sendEvent(new Event.ClientTick()));
        NeoForge.EVENT_BUS.addListener(e -> eventBus.sendEvent(new Event.ScreenClose(e.getScreen())));
        NeoForge.EVENT_BUS.addListener(e -> {
            if (e.getAction() == 0) {
                eventBus.sendEvent(new Event.MouseRelease(e.getButton()));
            }
        });
        NeoForge.EVENT_BUS.addListener(e -> eventBus.sendEvent(new Event.ScreenDraw(e.getScreen(), e.getGuiGraphics())));
        NeoForge.EVENT_BUS.addListener(e -> WaypointChatMessage.onRightClickOnBlock(e.getPos(), e.getItemStack()));
    }
}

