/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.client.model;

import com.mrcrayfish.framework.api.serialize.DataObject;
import com.mrcrayfish.framework.client.model.IOpenModel;
import com.mrcrayfish.framework.platform.ClientServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class OpenModelHelper {
    public static DataObject getData(ModelResourceLocation location) {
        DataObject dataObject;
        BakedModel model = ClientServices.CLIENT.getBakedModel(location);
        if (model instanceof IOpenModel) {
            IOpenModel openModel = (IOpenModel)model;
            dataObject = openModel.getData();
        } else {
            dataObject = DataObject.EMPTY;
        }
        return dataObject;
    }

    public static DataObject getData(BlockState state) {
        DataObject dataObject;
        BakedModel model = Minecraft.getInstance().getModelManager().getBlockModelShaper().getBlockModel(state);
        if (model instanceof IOpenModel) {
            IOpenModel openModel = (IOpenModel)model;
            dataObject = openModel.getData();
        } else {
            dataObject = DataObject.EMPTY;
        }
        return dataObject;
    }

    public static DataObject getData(Item item) {
        DataObject dataObject;
        BakedModel model = Minecraft.getInstance().getItemRenderer().getItemModelShaper().getItemModel(item);
        if (model instanceof IOpenModel) {
            IOpenModel openModel = (IOpenModel)model;
            dataObject = openModel.getData();
        } else {
            dataObject = DataObject.EMPTY;
        }
        return dataObject;
    }

    public static DataObject getData(ItemStack stack, @Nullable Level level, @Nullable LivingEntity entity, int seed) {
        BakedModel model = Minecraft.getInstance().getItemRenderer().getItemModelShaper().getItemModel(stack.getItem());
        if (model != null) {
            DataObject dataObject;
            ClientLevel clientLevel = level instanceof ClientLevel ? (ClientLevel)level : null;
            BakedModel overrideModel = model.getOverrides().resolve(model, stack, clientLevel, entity, seed);
            if (overrideModel instanceof IOpenModel) {
                IOpenModel openModel = (IOpenModel)overrideModel;
                dataObject = openModel.getData();
            } else {
                dataObject = DataObject.EMPTY;
            }
            return dataObject;
        }
        return DataObject.EMPTY;
    }
}

