/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.util;

import com.mrcrayfish.framework.api.Environment;
import com.mrcrayfish.framework.api.LogicalEnvironment;
import com.mrcrayfish.framework.platform.Services;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.util.thread.BlockableEventLoop;
import org.apache.commons.lang3.tuple.MutablePair;

public class TaskRunner {
    private static final MutablePair<BlockableEventLoop<?>, BlockableEventLoop<?>> EXECUTOR = new MutablePair(null, null);

    public static void setExecutor(LogicalEnvironment env, BlockableEventLoop<?> eventLoop) {
        switch (env) {
            case CLIENT: {
                EXECUTOR.setLeft(eventLoop);
                break;
            }
            case SERVER: {
                EXECUTOR.setRight(eventLoop);
            }
        }
    }

    public static <T> T callIf(Environment env, Supplier<Supplier<T>> task) {
        if (Services.PLATFORM.getEnvironment() == env) {
            return task.get().get();
        }
        return null;
    }

    public static void runIf(Environment env, Supplier<Runnable> task) {
        if (Services.PLATFORM.getEnvironment() == env) {
            task.get().run();
        }
    }

    public static void submitOn(Environment env, Supplier<Runnable> task) {
        TaskRunner.submitOn(env.getLogical(), task);
    }

    public static void submitOn(LogicalEnvironment env, Supplier<Runnable> task) {
        switch (env) {
            case CLIENT: {
                Optional.ofNullable((BlockableEventLoop)EXECUTOR.getLeft()).ifPresent(e -> e.submit((Runnable)task.get()));
                break;
            }
            case SERVER: {
                Optional.ofNullable((BlockableEventLoop)EXECUTOR.getRight()).ifPresent(e -> e.submit((Runnable)task.get()));
            }
        }
    }
}

