/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.config;

import com.electronwill.nightconfig.core.ConfigSpec;
import com.google.common.base.Preconditions;
import com.mrcrayfish.framework.api.config.AbstractProperty;
import com.mrcrayfish.framework.api.config.validate.Validator;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public final class StringProperty
extends AbstractProperty<String> {
    StringProperty(String defaultValue, Validator<String> validator) {
        super(defaultValue, validator);
    }

    @Override
    public StreamCodec<ByteBuf, String> streamCodec() {
        return ByteBufCodecs.STRING_UTF8;
    }

    @Override
    public void defineSpec(ConfigSpec spec) {
        Preconditions.checkState((this.data != null ? 1 : 0) != 0, (Object)"Config property is not initialized yet");
        spec.define(this.data.getPath(), this.defaultValue, e -> {
            String s;
            return e instanceof String && this.isValid(s = (String)e);
        });
    }

    @Override
    public boolean isValid(String value) {
        return value != null && (this.validator == null || this.validator.test(value));
    }

    public static StringProperty create(String defaultValue) {
        return StringProperty.create(defaultValue, null);
    }

    public static <V extends Validator<String>> StringProperty create(String defaultValue, V validator) {
        return new StringProperty(defaultValue, validator);
    }
}

