/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.client.screen.widget;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.framework.api.client.screen.widget.layout.Border;
import com.mrcrayfish.framework.api.client.screen.widget.layout.Padding;
import com.mrcrayfish.framework.client.ClientUtils;
import com.mrcrayfish.framework.platform.ClientServices;
import com.mrcrayfish.framework.util.Utils;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class FrameworkSelectionList
extends ObjectSelectionList<Item> {
    public static final ResourceLocation DEFAULT_BACKGROUND = Utils.rl("widget/selection_list/background");
    public static final ItemSprites DEFAULT_ITEM_SPRITE = ItemSprites.builder().setEnabledSelected(Utils.rl("widget/selection_list/item_enabled_selected")).setEnabledHoveredSelected(Utils.rl("widget/selection_list/item_enabled_selected")).build();
    public static final Padding DEFAULT_LIST_PADDING = Padding.of(4);
    public static final Border DEFAULT_LIST_BORDER = Border.of(0);
    public static final ScrollerSprites DEFAULT_SCROLLER_SPRITE = ScrollerSprites.of(ResourceLocation.withDefaultNamespace((String)"widget/scroller"));
    public static final ResourceLocation DEFAULT_SCROLL_BAR_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"widget/scroller_background");
    public static final Padding DEFAULT_SCROLL_BAR_PADDING = Padding.of(0);
    public static final Border DEFAULT_SCROLL_BAR_BORDER = Border.of(0);
    public static final Padding DEFAULT_SCROLL_BAR_CONTAINER_PADDING = Padding.of(0);
    public static final int DEFAULT_SCROLL_BAR_SPACING = 4;
    public static final int DEFAULT_SCROLLER_WIDTH = 6;
    public static final int DEFAULT_MIN_SCROLLER_HEIGHT = 32;
    public static final int DEFAULT_ITEM_HEIGHT = 20;
    public static final int DEFAULT_ITEM_SPACING = 0;
    @Nullable
    protected ItemSprites itemSprites;
    protected int itemSpacing;
    @Nullable
    protected ResourceLocation listBackground;
    protected Border listBorder = Border.ZERO;
    protected Padding listPadding = Padding.ZERO;
    protected boolean scrolling;
    protected boolean scrollBarAlwaysVisible;
    protected int scrollBarSpacing;
    protected ScrollBarStyle scrollBarStyle = ScrollBarStyle.DETACHED;
    protected int scrollerWidth = 6;
    protected int minScrollerHeight = 32;
    @Nullable
    protected ScrollerSprites scrollerSprites;
    @Nullable
    protected ResourceLocation scrollBarBackground;
    protected Border scrollBarBorder = Border.ZERO;
    protected Padding scrollBarPadding = Padding.ZERO;
    protected Padding scrollBarContainerPadding = Padding.ZERO;
    @Nullable
    protected Supplier<Boolean> activeSupplier;

    protected FrameworkSelectionList(int width, int height, int x, int y, int itemHeight) {
        super(Minecraft.getInstance(), width, height, y, itemHeight);
        this.setPosition(x, y);
    }

    private FrameworkSelectionList(int x, int y, int width, int height, int itemHeight, @Nullable ItemSprites itemSprites, int itemSpacing, @Nullable ResourceLocation listBackground, Border listBorder, Padding listPadding, boolean scrollBarAlwaysVisible, int scrollBarSpacing, ScrollBarStyle scrollBarStyle, @Nullable ScrollerSprites scrollerSprites, int scrollerWidth, int minScrollerHeight, @Nullable ResourceLocation scrollBarBackground, Border scrollBarBorder, Padding scrollBarPadding, Padding scrollBarContainerPadding, @Nullable Supplier<Boolean> activeSupplier, @Nullable Consumer<Consumer<Item>> itemsSupplier) {
        this(width, height, x, y, itemHeight);
        this.itemSprites = itemSprites;
        this.itemSpacing = itemSpacing;
        this.listBackground = listBackground;
        this.listBorder = listBorder;
        this.listPadding = listPadding;
        this.scrollBarAlwaysVisible = scrollBarAlwaysVisible;
        this.scrollBarSpacing = scrollBarSpacing;
        this.scrollBarStyle = scrollBarStyle;
        this.scrollerSprites = scrollerSprites;
        this.scrollerWidth = scrollerWidth;
        this.minScrollerHeight = minScrollerHeight;
        this.scrollBarBackground = scrollBarBackground;
        this.scrollBarBorder = scrollBarBorder;
        this.scrollBarPadding = scrollBarPadding;
        this.scrollBarContainerPadding = scrollBarContainerPadding;
        this.activeSupplier = activeSupplier;
        if (itemsSupplier != null) {
            itemsSupplier.accept(this::addItem);
        }
    }

    public void setPosition(int x, int y) {
        super.setPosition(x, y);
        this.setSize(this.width, this.height);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseY >= (double)this.getY() && mouseY <= (double)(this.getY() + this.getHeight()) && mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + this.getWidth());
    }

    public int getRowWidth() {
        return this.getRowRight() - this.getRowLeft();
    }

    public int getRowLeft() {
        return this.getX() + this.listBorder.left() + this.listPadding.left();
    }

    public int getRowRight() {
        if (this.getMaxScroll() > 0 || this.scrollBarAlwaysVisible) {
            int scrollBarArea = switch (this.scrollBarStyle.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.listPadding.right() + this.listBorder.right() + this.scrollBarSpacing + this.scrollBarContainerPadding.left() + this.scrollBarBorder.left() + this.scrollBarPadding.left() + this.scrollerWidth + this.scrollBarPadding.right() + this.scrollBarBorder.right() + this.scrollBarContainerPadding.right();
                case 1 -> this.scrollBarSpacing + this.scrollBarContainerPadding.left() + this.scrollBarBorder.left() + this.scrollBarPadding.left() + this.scrollerWidth + this.scrollBarPadding.right() + this.scrollBarBorder.right() + this.scrollBarContainerPadding.right() + this.listPadding.right() + this.listBorder.right();
            };
            return this.getX() + this.getWidth() - scrollBarArea;
        }
        return this.getX() + this.getWidth() - this.listPadding.right() - this.listBorder.right();
    }

    protected int getRowTop(int index) {
        return this.getY() + this.listBorder.top() + this.listPadding.top() - (int)this.getScrollAmount() + index * this.itemHeight + index * this.itemSpacing;
    }

    protected int getScrollbarPosition() {
        int offset = switch (this.scrollBarStyle.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.scrollerWidth + this.scrollBarPadding.right() + this.scrollBarBorder.right() + this.scrollBarContainerPadding.right();
            case 1 -> this.scrollerWidth + this.scrollBarPadding.right() + this.scrollBarBorder.right() + this.scrollBarContainerPadding.right() + this.listPadding.right() + this.listBorder.right();
        };
        return this.getX() + this.getWidth() - offset;
    }

    protected int getScrollbarHeight() {
        int scrollAreaHeight = this.getScrollAreaHeight();
        int scrollBarHeight = (int)((float)Mth.square((int)scrollAreaHeight) / (float)this.getMaxPosition());
        return Mth.clamp((int)scrollBarHeight, (int)this.minScrollerHeight, (int)scrollAreaHeight);
    }

    protected int getScrollAreaHeight() {
        int offset = switch (this.scrollBarStyle.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.scrollBarContainerPadding.top() + this.scrollBarBorder.top() + this.scrollBarPadding.top() + this.scrollBarPadding.bottom() + this.scrollBarBorder.bottom() + this.scrollBarContainerPadding.bottom();
            case 1 -> this.listBorder.top() + this.listPadding.top() + this.scrollBarContainerPadding.top() + this.scrollBarBorder.top() + this.scrollBarPadding.top() + this.scrollBarPadding.bottom() + this.scrollBarBorder.bottom() + this.scrollBarContainerPadding.bottom() + this.listPadding.bottom() + this.listBorder.bottom();
        };
        return this.getHeight() - offset;
    }

    protected int getScrollAreaTop() {
        int offset = switch (this.scrollBarStyle.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.scrollBarContainerPadding.top() + this.scrollBarBorder.top() + this.scrollBarPadding.top();
            case 1 -> this.listBorder.top() + this.listPadding.top() + this.scrollBarContainerPadding.top() + this.scrollBarBorder.top() + this.scrollBarPadding.top();
        };
        return this.getY() + offset;
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - this.height + this.listBorder.top() + this.listPadding.top() + this.listPadding.bottom() + this.listBorder.bottom());
    }

    protected int getMaxPosition() {
        return this.getItemCount() * (this.itemHeight + this.itemSpacing) - this.itemSpacing;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.activeSupplier != null) {
            this.active = this.activeSupplier.get();
        }
        this.renderListBackground(graphics, mouseX, mouseY, partialTick);
        this.renderListItems(graphics, mouseX, mouseY, partialTick);
        this.renderScrollBar(graphics, mouseX, mouseY, partialTick);
    }

    protected int getListBackgroundWidth() {
        return switch (this.scrollBarStyle.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.listBorder.left() + this.listPadding.left() + this.getRowWidth() + this.listPadding.right() + this.listBorder.right();
            case 1 -> this.getWidth();
        };
    }

    protected int getListBackgroundHeight() {
        return this.getHeight();
    }

    protected void renderListBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.listBackground != null) {
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            graphics.blitSprite(this.listBackground, this.getX(), this.getY(), this.getListBackgroundWidth(), this.getListBackgroundHeight());
            RenderSystem.disableBlend();
        }
    }

    protected void renderScrollBar(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int maxScroll = this.getMaxScroll();
        if (maxScroll > 0 || this.scrollBarAlwaysVisible) {
            if (this.scrollBarBackground != null) {
                RenderSystem.enableBlend();
                RenderSystem.enableDepthTest();
                int scrollBarTop = this.getY();
                if (this.scrollBarStyle == ScrollBarStyle.MERGED) {
                    scrollBarTop += this.listBorder.top() + this.listPadding.top() + this.scrollBarContainerPadding.top();
                }
                int scrollBarLeft = this.getScrollbarPosition() - this.scrollBarPadding.left() - this.scrollBarBorder.left();
                int scrollBarAreaWidth = this.scrollBarBorder.left() + this.scrollBarPadding.left() + this.scrollerWidth + this.scrollBarPadding.right() + this.scrollBarBorder.right();
                int scrollBarAreaHeight = this.getHeight() - this.scrollBarContainerPadding.top() - this.scrollBarContainerPadding.bottom();
                if (this.scrollBarStyle == ScrollBarStyle.MERGED) {
                    scrollBarAreaHeight -= this.listBorder.top() + this.listPadding.top() + this.listPadding.bottom() + this.listBorder.bottom();
                }
                graphics.blitSprite(this.scrollBarBackground, scrollBarLeft, scrollBarTop, scrollBarAreaWidth, scrollBarAreaHeight);
                RenderSystem.disableBlend();
            }
            boolean scrollBarEnabled = maxScroll > 0 && this.isActive();
            int scrollBarStart = this.getScrollbarPosition();
            int scrollBarEnd = scrollBarStart + this.scrollerWidth;
            int scrollBarHeight = this.getScrollbarHeight();
            int scrollBarTop = (int)((double)this.getScrollAreaTop() + (double)(this.getScrollAreaHeight() - this.getScrollbarHeight()) * (this.getScrollAmount() / (double)Math.max(maxScroll, 1)));
            boolean scrollBarHovered = ClientUtils.isPointInArea(mouseX, mouseY, scrollBarStart, scrollBarTop, this.scrollerWidth, scrollBarHeight);
            if (this.scrollerSprites != null) {
                ResourceLocation sprite = this.scrollerSprites.get(scrollBarEnabled, scrollBarHovered, this.scrolling);
                if (sprite != null) {
                    RenderSystem.enableBlend();
                    RenderSystem.enableDepthTest();
                    graphics.setColor(1.0f, 1.0f, 1.0f, this.active ? 1.0f : 0.5f);
                    graphics.blitSprite(sprite, scrollBarStart, scrollBarTop, scrollBarEnd - scrollBarStart, scrollBarHeight);
                    graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                    RenderSystem.disableBlend();
                }
            } else {
                int scrollBarColour = scrollBarHovered ? -13423059 : -12107714;
                graphics.fill(scrollBarStart, scrollBarTop, scrollBarEnd, scrollBarTop + scrollBarHeight, scrollBarColour);
            }
        }
    }

    protected void renderListItems(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int startIndex;
        int rowTop;
        graphics.enableScissor(this.getRowLeft(), this.getY() + this.listBorder.top(), this.getRowRight(), this.getY() + this.getHeight() - this.listBorder.bottom());
        int rowLeft = this.getRowLeft();
        int rowWidth = this.getRowWidth();
        int rowHeight = this.itemHeight;
        int rowCount = this.getItemCount();
        for (int i = startIndex = Math.max(0, (int)((this.getScrollAmount() - (double)this.listPadding.top()) / (double)(rowHeight + this.itemSpacing))); i < rowCount && (rowTop = this.getRowTop(i)) <= this.getY() + this.getHeight(); ++i) {
            boolean hovered = !this.scrolling && ClientUtils.isPointInArea(mouseX, mouseY, rowLeft, rowTop, rowWidth, rowHeight);
            boolean selected = this.isSelectedItem(i);
            Item item = (Item)this.getEntry(i);
            item.setHovered(hovered);
            item.renderBackground(this.itemSprites, graphics, i, rowLeft, rowTop, rowWidth, rowHeight, mouseX, mouseY, hovered, selected);
            item.render(graphics, i, rowTop, rowLeft, rowWidth, rowHeight, mouseX, mouseY, selected, partialTick);
        }
        graphics.disableScissor();
    }

    protected void renderSelection(GuiGraphics graphics, int top, int rowWidth, int rowHeight, int outlineColour, int innerColour) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.active || !this.isValidMouseClick(button)) {
            return false;
        }
        this.updateScrollingState(mouseX, mouseY, button);
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        Item item = this.getEntry(mouseX, mouseY);
        if (item != null && item.mouseClicked(mouseX, mouseY, button)) {
            Item focused = (Item)this.getFocused();
            if (focused != item && focused instanceof ContainerEventHandler) {
                ContainerEventHandler handler = (ContainerEventHandler)focused;
                handler.setFocused(null);
            }
            this.setFocused((GuiEventListener)item);
            this.setDragging(true);
            return true;
        }
        return this.scrolling;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0) {
            if (this.getFocused() != null && this.isDragging() && ((Item)this.getFocused()).mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
                return true;
            }
            if (this.scrolling) {
                double unitsPerScroll = (double)this.getMaxScroll() / (double)Math.max(1, this.getScrollAreaHeight() - this.getScrollbarHeight());
                this.setScrollAmount(this.getScrollAmount() + deltaY * unitsPerScroll);
                return true;
            }
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        return this.active && super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    public void addItem(Item item) {
        super.addEntry((AbstractSelectionList.Entry)item);
    }

    @Nullable
    public Item removeItem(int index) {
        if (index >= 0 && index < this.children().size()) {
            Item removed = (Item)super.remove(index);
            if (removed != null) {
                this.clampScrollAmount();
            }
            return removed;
        }
        return null;
    }

    public boolean removeItem(Item item) {
        boolean result = super.removeEntry((AbstractSelectionList.Entry)item);
        if (result) {
            this.clampScrollAmount();
        }
        return result;
    }

    public void removeIf(Predicate<? super Item> predicate) {
        if (this.children().removeIf(predicate)) {
            this.clampScrollAmount();
        }
    }

    public Item getEntry(double mouseX, double mouseY) {
        int contentHeight;
        int contentWidth;
        int contentTop;
        int contentLeft = this.getX() + this.listBorder.left() + this.listPadding.left();
        if (ClientUtils.isPointInArea((int)mouseX, (int)mouseY, contentLeft, contentTop = this.getY() + this.listBorder.top(), contentWidth = this.getRowWidth(), contentHeight = this.getHeight() - this.listBorder.top() - this.listBorder.bottom())) {
            int startIndex;
            int rowTop;
            int rowLeft = this.getRowLeft();
            int rowWidth = this.getRowWidth();
            int rowHeight = this.itemHeight;
            int rowCount = this.getItemCount();
            for (int i = startIndex = Math.max(0, (int)((this.getScrollAmount() - (double)this.listPadding.top()) / (double)(rowHeight + this.itemSpacing))); i < rowCount && (rowTop = this.getRowTop(i)) <= this.getY() + this.getHeight(); ++i) {
                if (!ClientUtils.isPointInArea((int)mouseX, (int)mouseY, rowLeft, rowTop, rowWidth, rowHeight)) continue;
                return (Item)this.getEntry(i);
            }
        }
        return null;
    }

    protected void updateScrollingState(double mouseX, double mouseY, int button) {
        this.scrolling = this.getMaxScroll() > 0 && button == 0 && ClientUtils.isPointInArea((int)mouseX, (int)mouseY, this.getScrollbarPosition(), this.getScrollAreaTop(), this.scrollerWidth, this.getScrollAreaHeight());
        ClientServices.CLIENT.setScrollingState((AbstractSelectionList<?>)this, this.scrolling);
    }

    @Nullable
    public Item getSelected() {
        Item selected = (Item)super.getSelected();
        if (selected != null && selected.isSelectable()) {
            return selected;
        }
        return null;
    }

    public void setSelected(@Nullable Item item) {
        if (item == null || item.isSelectable()) {
            super.setSelected((AbstractSelectionList.Entry)item);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ScrollBarStyle {
        DETACHED,
        MERGED;

    }

    public static final class ItemSprites {
        private final ImmutableMap<Integer, ResourceLocation> map;

        private ItemSprites(@Nullable ResourceLocation enabled, @Nullable ResourceLocation disabled, @Nullable ResourceLocation enabledHovered, @Nullable ResourceLocation disabledHovered, @Nullable ResourceLocation enabledSelected, @Nullable ResourceLocation disabledSelected, @Nullable ResourceLocation enabledHoveredSelected, @Nullable ResourceLocation disabledHoveredSelected) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            if (disabled != null) {
                builder.put((Object)this.calculateKey(false, false, false), (Object)disabled);
            }
            if (enabled != null) {
                builder.put((Object)this.calculateKey(true, false, false), (Object)enabled);
            }
            if (disabledHovered != null) {
                builder.put((Object)this.calculateKey(false, true, false), (Object)disabledHovered);
            }
            if (enabledHovered != null) {
                builder.put((Object)this.calculateKey(true, true, false), (Object)enabledHovered);
            }
            if (disabledSelected != null) {
                builder.put((Object)this.calculateKey(false, false, true), (Object)disabledSelected);
            }
            if (enabledSelected != null) {
                builder.put((Object)this.calculateKey(true, false, true), (Object)enabledSelected);
            }
            if (disabledHoveredSelected != null) {
                builder.put((Object)this.calculateKey(false, true, true), (Object)disabledHoveredSelected);
            }
            if (enabledHoveredSelected != null) {
                builder.put((Object)this.calculateKey(true, true, true), (Object)enabledHoveredSelected);
            }
            this.map = builder.build();
        }

        private int calculateKey(boolean enabled, boolean hovered, boolean selected) {
            int key = 0;
            if (enabled) {
                key |= 1;
            }
            if (hovered) {
                key |= 2;
            }
            if (selected) {
                key |= 4;
            }
            return key;
        }

        @Nullable
        public ResourceLocation getSprite(boolean enabled, boolean hovered, boolean selected) {
            return (ResourceLocation)this.map.get((Object)this.calculateKey(enabled, hovered, selected));
        }

        public static ItemSprites of(@Nullable ResourceLocation all) {
            return new ItemSprites(all, all, all, all, all, all, all, all);
        }

        public static ItemSprites of(@Nullable ResourceLocation enabled, @Nullable ResourceLocation disabled, @Nullable ResourceLocation enabledSelected) {
            return new ItemSprites(enabled, disabled, enabled, disabled, enabledSelected, disabled, enabledSelected, disabled);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            @Nullable
            private ResourceLocation enabled;
            @Nullable
            private ResourceLocation disabled;
            @Nullable
            private ResourceLocation enabledHovered;
            @Nullable
            private ResourceLocation disabledHovered;
            @Nullable
            private ResourceLocation enabledSelected;
            @Nullable
            private ResourceLocation disabledSelected;
            @Nullable
            private ResourceLocation enabledHoveredSelected;
            @Nullable
            private ResourceLocation disabledHoveredSelected;

            public ItemSprites build() {
                return new ItemSprites(this.enabled, this.disabled, this.enabledHovered, this.disabledHovered, this.enabledSelected, this.disabledSelected, this.enabledHoveredSelected, this.disabledHoveredSelected);
            }

            public Builder setEnabled(@Nullable ResourceLocation texture) {
                this.enabled = texture;
                return this;
            }

            public Builder setDisabled(@Nullable ResourceLocation texture) {
                this.disabled = texture;
                return this;
            }

            public Builder setEnabledHovered(@Nullable ResourceLocation texture) {
                this.enabledHovered = texture;
                return this;
            }

            public Builder setDisabledHovered(@Nullable ResourceLocation texture) {
                this.disabledHovered = texture;
                return this;
            }

            public Builder setEnabledSelected(@Nullable ResourceLocation texture) {
                this.enabledSelected = texture;
                return this;
            }

            public Builder setDisabledSelected(@Nullable ResourceLocation texture) {
                this.disabledSelected = texture;
                return this;
            }

            public Builder setEnabledHoveredSelected(@Nullable ResourceLocation texture) {
                this.enabledHoveredSelected = texture;
                return this;
            }

            public Builder setDisabledHoveredSelected(@Nullable ResourceLocation texture) {
                this.disabledHoveredSelected = texture;
                return this;
            }
        }
    }

    public static final class ScrollerSprites {
        private final ResourceLocation enabled;
        @Nullable
        private final ResourceLocation disabled;
        private final ResourceLocation hovered;
        private final ResourceLocation dragging;

        private ScrollerSprites(ResourceLocation enabled, @Nullable ResourceLocation disabled, ResourceLocation hovered, ResourceLocation dragging) {
            this.enabled = enabled;
            this.disabled = disabled;
            this.hovered = hovered;
            this.dragging = dragging;
        }

        public static ScrollerSprites of(ResourceLocation all) {
            return new ScrollerSprites(all, all, all, all);
        }

        public static ScrollerSprites of(ResourceLocation enabled, ResourceLocation disabled, ResourceLocation hovered) {
            return new ScrollerSprites(enabled, disabled, hovered, hovered);
        }

        public static ScrollerSprites of(ResourceLocation enabled, ResourceLocation disabled, ResourceLocation hovered, ResourceLocation dragging) {
            return new ScrollerSprites(enabled, disabled, hovered, dragging);
        }

        @Nullable
        public ResourceLocation get(boolean enabled, boolean hovered, boolean dragging) {
            if (!enabled) {
                return this.disabled;
            }
            if (hovered) {
                return this.hovered;
            }
            if (dragging) {
                return this.dragging;
            }
            return this.enabled;
        }
    }

    public static abstract class Item
    extends ObjectSelectionList.Entry<Item> {
        private boolean hovered;

        protected abstract void renderContent(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, boolean var10, float var11);

        private void setHovered(boolean hovered) {
            this.hovered = hovered;
        }

        public boolean isSelectable() {
            return true;
        }

        public Component getNarration() {
            return CommonComponents.EMPTY;
        }

        public final void render(GuiGraphics graphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean selected, float partialTick) {
            this.renderContent(graphics, index, x, y, width, height, mouseX, mouseY, this.hovered, selected, partialTick);
        }

        protected void renderBackground(@Nullable ItemSprites sprites, GuiGraphics graphics, int index, int x, int y, int width, int height, int mouseX, int mouseY, boolean hovered, boolean selected) {
            ResourceLocation sprite;
            if (sprites != null && (sprite = sprites.getSprite(true, hovered, selected)) != null) {
                graphics.blitSprite(sprite, x, y, width, height);
            }
        }
    }

    public static class Builder {
        private int x;
        private int y;
        private int width = 100;
        private int height = 100;
        private int itemHeight = 20;
        @Nullable
        private ItemSprites itemSprites = DEFAULT_ITEM_SPRITE;
        private int itemSpacing = 0;
        @Nullable
        private ResourceLocation listBackground = DEFAULT_BACKGROUND;
        private Border listBorder = DEFAULT_LIST_BORDER;
        private Padding listPadding = DEFAULT_LIST_PADDING;
        private boolean scrollBarAlwaysVisible;
        private int scrollBarSpacing = 4;
        private ScrollBarStyle scrollBarStyle = ScrollBarStyle.DETACHED;
        @Nullable
        private ScrollerSprites scrollerSprites = DEFAULT_SCROLLER_SPRITE;
        private int scrollerWidth = 6;
        private int minScrollerHeight = 32;
        @Nullable
        private ResourceLocation scrollBarBackground = DEFAULT_SCROLL_BAR_BACKGROUND;
        private Border scrollBarBorder = DEFAULT_SCROLL_BAR_BORDER;
        private Padding scrollBarPadding = DEFAULT_SCROLL_BAR_PADDING;
        private Padding scrollBarContainerPadding = DEFAULT_SCROLL_BAR_CONTAINER_PADDING;
        @Nullable
        private Supplier<Boolean> activeSupplier;
        @Nullable
        private Consumer<Consumer<Item>> itemsSupplier;

        private Builder() {
        }

        public FrameworkSelectionList build() {
            return new FrameworkSelectionList(this.x, this.y, this.width, this.height, this.itemHeight, this.itemSprites, this.itemSpacing, this.listBackground, this.listBorder, this.listPadding, this.scrollBarAlwaysVisible, this.scrollBarSpacing, this.scrollBarStyle, this.scrollerSprites, this.scrollerWidth, this.minScrollerHeight, this.scrollBarBackground, this.scrollBarBorder, this.scrollBarPadding, this.scrollBarContainerPadding, this.activeSupplier, this.itemsSupplier);
        }

        public Builder setX(int x) {
            this.x = x;
            return this;
        }

        public Builder setY(int y) {
            this.y = y;
            return this;
        }

        public Builder setPosition(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder setWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder setHeight(int height) {
            this.height = height;
            return this;
        }

        public Builder setSize(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder setItemHeight(int height) {
            this.itemHeight = height;
            return this;
        }

        public Builder setItemSprites(@Nullable ItemSprites sprites) {
            this.itemSprites = sprites;
            return this;
        }

        public Builder noItemSprites() {
            this.itemSprites = null;
            return this;
        }

        public Builder setItemSpacing(int spacing) {
            this.itemSpacing = spacing;
            return this;
        }

        public Builder setListBackground(@Nullable ResourceLocation texture) {
            this.listBackground = texture;
            return this;
        }

        public Builder noListBackground() {
            this.listBackground = null;
            return this;
        }

        public Builder setListBorder(Border border) {
            this.listBorder = border;
            return this;
        }

        public Builder setListPadding(Padding padding) {
            this.listPadding = padding;
            return this;
        }

        public Builder setScrollBarAlwaysVisible(boolean alwaysVisible) {
            this.scrollBarAlwaysVisible = alwaysVisible;
            return this;
        }

        public Builder setScrollBarSpacing(int spacing) {
            this.scrollBarSpacing = spacing;
            return this;
        }

        public Builder setScrollBarStyle(ScrollBarStyle style) {
            this.scrollBarStyle = style;
            return this;
        }

        public Builder setScrollerSprites(@Nullable ScrollerSprites sprites) {
            this.scrollerSprites = sprites;
            return this;
        }

        public Builder setScrollerWidth(int width) {
            this.scrollerWidth = width;
            return this;
        }

        public Builder setMinScrollerHeight(int minHeight) {
            this.minScrollerHeight = minHeight;
            return this;
        }

        public Builder setScrollBarBackground(@Nullable ResourceLocation texture) {
            this.scrollBarBackground = texture;
            return this;
        }

        public Builder setScrollBarBorder(Border border) {
            this.scrollBarBorder = border;
            return this;
        }

        public Builder setScrollBarPadding(Padding padding) {
            this.scrollBarPadding = padding;
            return this;
        }

        public Builder setScrollBarContainerPadding(Padding padding) {
            this.scrollBarContainerPadding = padding;
            return this;
        }

        public Builder setDependent(Supplier<Boolean> active) {
            this.activeSupplier = active;
            return this;
        }

        public Builder setInitialItems(Consumer<Consumer<Item>> items) {
            this.itemsSupplier = items;
            return this;
        }
    }
}

