/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalbonemeal.world.level.block.behavior;

import com.google.common.collect.Sets;
import fuzs.universalbonemeal.world.level.block.behavior.ChorusFlowerBehavior;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ChorusPlantBehavior
extends ChorusFlowerBehavior {
    @Override
    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState blockState) {
        for (BlockPos flowerPosition : this.getFlowerPositions((BlockGetter)level, pos)) {
            if (!super.isValidBonemealTarget(level, flowerPosition, level.getBlockState(flowerPosition))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState blockState) {
        for (BlockPos flowerPosition : this.getFlowerPositions((BlockGetter)level, pos)) {
            super.performBonemeal(level, random, flowerPosition, level.getBlockState(flowerPosition));
        }
    }

    private Collection<BlockPos> getFlowerPositions(BlockGetter level, BlockPos startPos) {
        HashSet targets = Sets.newHashSet();
        ChorusPlantBehavior.getTopConnectedBlock(level, startPos.mutable(), Blocks.CHORUS_PLANT, Blocks.CHORUS_FLOWER, targets, Direction.DOWN, 128);
        return targets;
    }

    public static void getTopConnectedBlock(BlockGetter level, BlockPos.MutableBlockPos sourcePosition, Block sourceBlock, Block targetBlock, Collection<BlockPos> targets, Direction sourceDirection, int depth) {
        BlockState sourceState = level.getBlockState((BlockPos)sourcePosition);
        if (depth <= 0 || !sourceState.is(sourceBlock)) {
            if (sourceState.is(targetBlock)) {
                targets.add(sourcePosition.immutable());
            }
            return;
        }
        for (Map.Entry entry : PipeBlock.PROPERTY_BY_DIRECTION.entrySet()) {
            Direction direction = (Direction)entry.getKey();
            if (direction == Direction.DOWN || direction == sourceDirection || !((Boolean)sourceState.getValue((Property)entry.getValue())).booleanValue()) continue;
            sourcePosition.move(direction);
            ChorusPlantBehavior.getTopConnectedBlock(level, sourcePosition, sourceBlock, targetBlock, targets, direction.getOpposite(), depth - 1);
            sourcePosition.move(direction.getOpposite());
        }
    }
}

