/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.capability.v3.data;

import fuzs.puzzleslib.api.capability.v3.data.CapabilityComponent;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.entity.Entity;

public enum CopyStrategy {
    ALWAYS{

        @Override
        public void copy(Entity oldEntity, CapabilityComponent<?> oldCapability, Entity newEntity, CapabilityComponent<?> newCapability, boolean originalStillAlive) {
            this.copy((HolderLookup.Provider)newEntity.registryAccess(), oldCapability, newCapability);
        }
    }
    ,
    NEVER{

        @Override
        public void copy(Entity oldEntity, CapabilityComponent<?> oldCapability, Entity newEntity, CapabilityComponent<?> newCapability, boolean originalStillAlive) {
            if (originalStillAlive) {
                this.copy((HolderLookup.Provider)newEntity.registryAccess(), oldCapability, newCapability);
            }
        }
    }
    ,
    KEEP_PLAYER_INVENTORY{

        @Override
        public void copy(Entity oldEntity, CapabilityComponent<?> oldCapability, Entity newEntity, CapabilityComponent<?> newCapability, boolean originalStillAlive) {
            NEVER.copy(oldEntity, oldCapability, newEntity, newCapability, originalStillAlive);
        }
    };


    public abstract void copy(Entity var1, CapabilityComponent<?> var2, Entity var3, CapabilityComponent<?> var4, boolean var5);

    void copy(HolderLookup.Provider registries, CapabilityComponent<?> oldCapability, CapabilityComponent<?> newCapability) {
        newCapability.read(oldCapability.toCompoundTag(registries), registries);
    }
}

