/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.embedded.ca.solostudios.stringsimilarity.normalized;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.anti_ad.embedded.ca.solostudios.stringsimilarity.Levenshtein;
import org.anti_ad.embedded.ca.solostudios.stringsimilarity.interfaces.MetricStringDistance;
import org.anti_ad.embedded.ca.solostudios.stringsimilarity.interfaces.NormalizedStringDistance;
import org.anti_ad.embedded.ca.solostudios.stringsimilarity.interfaces.NormalizedStringSimilarity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B%\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/anti_ad/embedded/ca/solostudios/stringsimilarity/normalized/NormalizedLevenshtein;", "Lorg/anti_ad/embedded/ca/solostudios/stringsimilarity/interfaces/MetricStringDistance;", "Lorg/anti_ad/embedded/ca/solostudios/stringsimilarity/interfaces/NormalizedStringDistance;", "Lorg/anti_ad/embedded/ca/solostudios/stringsimilarity/interfaces/NormalizedStringSimilarity;", "insertionWeight", "", "deletionWeight", "substitutionWeight", "<init>", "(DDD)V", "levenshtein", "Lorg/anti_ad/embedded/ca/solostudios/stringsimilarity/Levenshtein;", "distance", "s1", "", "s2", "similarity", "kt-string-similarity"})
public final class NormalizedLevenshtein
implements MetricStringDistance,
NormalizedStringDistance,
NormalizedStringSimilarity {
    @NotNull
    private final Levenshtein levenshtein;

    public NormalizedLevenshtein(double insertionWeight, double deletionWeight, double substitutionWeight) {
        this.levenshtein = new Levenshtein(insertionWeight, deletionWeight, substitutionWeight);
    }

    public /* synthetic */ NormalizedLevenshtein(double d, double d2, double d3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 1.0;
        }
        if ((n & 2) != 0) {
            d2 = 1.0;
        }
        if ((n & 4) != 0) {
            d3 = 1.0;
        }
        this(d, d2, d3);
    }

    @Override
    public double distance(@NotNull String s1, @NotNull String s2) {
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        if (Intrinsics.areEqual((Object)s1, (Object)s2)) {
            return 0.0;
        }
        if (((CharSequence)s1).length() == 0 || ((CharSequence)s2).length() == 0) {
            return 1.0;
        }
        double distance = this.levenshtein.distance(s1, s2);
        return (double)2 * distance / ((double)(s1.length() + s2.length()) + distance);
    }

    @Override
    public double similarity(@NotNull String s1, @NotNull String s2) {
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        return 1.0 - this.distance(s1, s2);
    }

    public NormalizedLevenshtein() {
        this(0.0, 0.0, 0.0, 7, null);
    }
}

