/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.embedded.ca.solostudios.fuzzykt;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.anti_ad.embedded.ca.solostudios.stringsimilarity.normalized.NormalizedLevenshtein;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0016\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\"\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/anti_ad/embedded/ca/solostudios/fuzzykt/FuzzyKt;", "", "<init>", "()V", "normalizedLevenshtein", "Lorg/anti_ad/embedded/ca/solostudios/stringsimilarity/normalized/NormalizedLevenshtein;", "ratio", "", "s1", "", "s2", "partialRatio", "longestCommonSubstring", "Lkotlin/Pair;", "", "kt-fuzzy"})
public final class FuzzyKt {
    @NotNull
    public static final FuzzyKt INSTANCE = new FuzzyKt();
    @NotNull
    private static final NormalizedLevenshtein normalizedLevenshtein = new NormalizedLevenshtein(0.0, 0.0, 0.0, 7, null);

    private FuzzyKt() {
    }

    public final double ratio(@NotNull String s1, @NotNull String s2) {
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        return normalizedLevenshtein.similarity(s1, s2);
    }

    public final double partialRatio(@NotNull String s1, @NotNull String s2) {
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        Pair pair = s1.length() > s2.length() ? TuplesKt.to((Object)s2, (Object)s1) : TuplesKt.to((Object)s1, (Object)s2);
        String shorter = (String)pair.component1();
        String longer = (String)pair.component2();
        int start = ((Number)this.longestCommonSubstring(s1, s2).component1()).intValue();
        int upperBound = Math.min(start + shorter.length(), longer.length());
        int lowerBound = upperBound - shorter.length();
        String string = longer.substring(lowerBound, upperBound);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String splitString = string;
        return normalizedLevenshtein.similarity(splitString, shorter);
    }

    @NotNull
    public final Pair<Integer, Integer> longestCommonSubstring(@NotNull String s1, @NotNull String s2) {
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        int max = 0;
        int n = 0;
        int n2 = s1.length();
        int[][] nArrayArray = new int[n2][];
        while (n < n2) {
            int n3 = n++;
            nArrayArray[n3] = new int[s2.length()];
        }
        int[][] dp = nArrayArray;
        int endIndex = -1;
        int n4 = ((CharSequence)s1).length();
        for (int i = 0; i < n4; ++i) {
            int n5 = ((CharSequence)s2).length();
            for (int j = 0; j < n5; ++j) {
                if (s1.charAt(i) != s2.charAt(j)) continue;
                dp[i][j] = i == 0 || j == 0 ? 1 : dp[i - 1][j - 1] + 1;
                if (max >= dp[i][j]) continue;
                max = dp[i][j];
                endIndex = i;
            }
        }
        return TuplesKt.to((Object)(endIndex - max + 1), (Object)(endIndex + 1));
    }
}

