/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.octolib.client;

import it.hurts.octostudios.octolib.client.animation.Tween;
import it.hurts.octostudios.octolib.client.animation.easing.EaseType;
import it.hurts.octostudios.octolib.client.animation.easing.TransitionType;
import it.hurts.octostudios.octolib.client.particle.GalacticUIParticle;
import it.hurts.octostudios.octolib.client.particle.UIParticle;
import it.hurts.octostudios.octolib.util.OctoColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;

public class TestWidget
extends AbstractWidget {
    protected Screen screen;
    private Vector2f position = new Vector2f();
    private Vector2f scale = new Vector2f(1.0f, 1.0f);
    private OctoColor color = new OctoColor(1.0f, 1.0f, 1.0f, 1.0f);
    public TransitionType transitionType;
    public EaseType easeType;
    public Tween tween;
    private Matrix4f renderPose = new Matrix4f();
    public Tween hoverTween;
    private boolean hasHovered = false;

    public TestWidget(int x, int y, TransitionType transitionType, EaseType easeType, Screen screen) {
        super(x, y, 8, 8, (Component)Component.literal((String)(easeType.name() + "_" + transitionType.name())));
        this.transitionType = transitionType;
        this.easeType = easeType;
        this.screen = screen;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float partialTick) {
        float actualPartialTick = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(this.position.x + (float)this.getX(), this.position.y + (float)this.getY(), 0.0f);
        guiGraphics.pose().translate((float)this.width / 2.0f, (float)this.height / 2.0f, 0.0f);
        guiGraphics.pose().scale(this.scale.x, this.scale.y, 1.0f);
        guiGraphics.pose().translate((float)(-this.width) / 2.0f, (float)(-this.height) / 2.0f, 0.0f);
        this.renderPose = new Matrix4f((Matrix4fc)guiGraphics.pose().last().pose());
        guiGraphics.renderOutline(0, 0, this.getWidth(), this.getHeight(), this.color.getARGB());
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.getX(), (float)this.getY(), 0.0f);
        guiGraphics.renderOutline(-2, -12, 112, this.getHeight() + 14, 0x50FFFFFF);
        guiGraphics.pose().scale(0.75f, 1.0f, 1.0f);
        guiGraphics.drawString(Minecraft.getInstance().font, this.getMessage(), 0, -10, 0x50FFFFFF, true);
        guiGraphics.pose().popPose();
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public boolean isHovered() {
        boolean hovered = super.isHovered();
        if (hovered && !this.hasHovered) {
            this.hasHovered = true;
            if (this.hoverTween != null) {
                this.hoverTween.kill();
            }
            this.hoverTween = Tween.create().setTransitionType(TransitionType.QUART).setEase(EaseType.EASE_OUT);
            this.hoverTween.tweenProperty((Object)this, "scale", new Vector2f(1.25f, 1.25f), 0.2);
        } else if (!hovered && this.hasHovered) {
            this.hasHovered = false;
            if (this.hoverTween != null) {
                this.hoverTween.kill();
            }
            this.hoverTween = Tween.create().setTransitionType(TransitionType.QUART).setEase(EaseType.EASE_OUT);
            this.hoverTween.tweenProperty((Object)this, "scale", new Vector2f(1.0f, 1.0f), 0.2);
        }
        return hovered;
    }

    public void onClick(double mouseX, double mouseY) {
        if (this.tween != null) {
            this.tween.kill();
        }
        Runnable spawnParticle = () -> {
            GalacticUIParticle uiParticle = new GalacticUIParticle(20.0f, 1, (float)this.getX() + this.position.x, (float)this.getY() + this.position.y, UIParticle.Layer.SCREEN, 1.0f);
            uiParticle.setScreen(this.screen);
            uiParticle.instantiate();
        };
        this.tween = Tween.create().setTransitionType(this.transitionType).setEase(this.easeType).setLoops(3);
        this.tween.tweenMethod(this::setColor, OctoColor.GREEN, OctoColor.WHITE, 0.5).setTransitionType(TransitionType.LINEAR);
        this.tween.parallel().tweenProperty((Object)this, "position", new Vector2f(10.0f, 10.0f), 0.5);
        this.tween.parallel().tweenRunnable(spawnParticle);
        this.tween.tweenInterval(0.5);
        this.tween.tweenMethod(this::setColor, OctoColor.RED, OctoColor.WHITE, 0.5).setTransitionType(TransitionType.LINEAR);
        this.tween.parallel().tweenProperty((Object)this, "position", new Vector2f(0.0f, 0.0f), 0.5);
        this.tween.parallel().tweenRunnable(spawnParticle);
        this.tween.tweenInterval(0.5);
        super.onClick(mouseX, mouseY);
    }

    public void setColor(OctoColor color) {
        this.color = color;
    }
}

