/*
 * Decompiled with CFR 0.152.
 */
package accieo.cobbleworkers.utilities;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002BCB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000f\u0010\u0010J'\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\u0011\u001a\u00020\b\u00a2\u0006\u0004\b\u0013\u0010\u0014J'\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\b\u00a2\u0006\u0004\b\u0015\u0010\u0016J%\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001c\u0010\u001dJ%\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001c\u0010\u001eJ\u001d\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010!\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010#\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b#\u0010$J\u001f\u0010%\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b%\u0010&J\u001d\u0010(\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b(\u0010)J\u001d\u0010*\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010,\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b,\u0010-J\u001d\u0010.\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b.\u0010)R \u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00060/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R \u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002020/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00101R \u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00101R \u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002020/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00101R \u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002060/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00101R\u001a\u00109\u001a\b\u0012\u0004\u0012\u000206088\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:R \u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020;0/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b<\u00101R\u0016\u0010=\u001a\u00020;8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b=\u0010>R\u0014\u0010?\u001a\u00020;8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b?\u0010>R\u0014\u0010@\u001a\u00020;8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b@\u0010>R\u0014\u0010A\u001a\u00020;8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bA\u0010>\u00a8\u0006D"}, d2={"Laccieo/cobbleworkers/utilities/CobbleworkersNavigationUtils;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "pokemonEntity", "Lnet/minecraft/core/BlockPos;", "targetPos", "", "offset", "", "isPokemonAtPosition", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/core/BlockPos;D)Z", "Lnet/minecraft/world/entity/player/Player;", "player", "isPokemonNearPlayer", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;D)Z", "speed", "", "navigateTo", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/core/BlockPos;D)V", "navigateToPlayer", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;D)V", "Ljava/util/UUID;", "pokemonId", "target", "Lnet/minecraft/world/level/Level;", "world", "claimTarget", "(Ljava/util/UUID;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/Level;)V", "(Ljava/util/UUID;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/Level;)V", "releaseTarget", "(Ljava/util/UUID;Lnet/minecraft/world/level/Level;)V", "releasePlayerTarget", "(Ljava/util/UUID;)V", "getTarget", "(Ljava/util/UUID;Lnet/minecraft/world/level/Level;)Lnet/minecraft/core/BlockPos;", "getPlayerTarget", "(Ljava/util/UUID;Lnet/minecraft/world/level/Level;)Ljava/util/UUID;", "pos", "isTargeted", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/Level;)Z", "isPlayerTargeted", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/Level;)Z", "releaseExpiredClaims", "(Lnet/minecraft/world/level/Level;)V", "isRecentlyExpired", "", "pokemonToTarget", "Ljava/util/Map;", "Laccieo/cobbleworkers/utilities/CobbleworkersNavigationUtils$Claim;", "targetedBlocks", "pokemonToPlayerTarget", "targetedPlayers", "Laccieo/cobbleworkers/utilities/CobbleworkersNavigationUtils$ExpiredTarget;", "recentlyExpiredTargets", "Ljava/util/PriorityQueue;", "expiredQueue", "Ljava/util/PriorityQueue;", "", "lastPathfindTick", "lastCleanUpTick", "J", "CLAIM_TIMEOUT_TICKS", "EXPIRED_TARGET_TIMEOUT_TICKS", "PATHFIND_INTERVAL_TICKS", "Claim", "ExpiredTarget", "cobbleworkers-common"})
@SourceDebugExtension(value={"SMAP\nCobbleworkersNavigationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CobbleworkersNavigationUtils.kt\naccieo/cobbleworkers/utilities/CobbleworkersNavigationUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,201:1\n1869#2,2:202\n1869#2,2:204\n1869#2,2:206\n*S KotlinDebug\n*F\n+ 1 CobbleworkersNavigationUtils.kt\naccieo/cobbleworkers/utilities/CobbleworkersNavigationUtils\n*L\n175#1:202,2\n180#1:204,2\n184#1:206,2\n*E\n"})
public final class CobbleworkersNavigationUtils {
    @NotNull
    public static final CobbleworkersNavigationUtils INSTANCE = new CobbleworkersNavigationUtils();
    @NotNull
    private static final Map<UUID, BlockPos> pokemonToTarget = new LinkedHashMap();
    @NotNull
    private static final Map<BlockPos, Claim> targetedBlocks = new LinkedHashMap();
    @NotNull
    private static final Map<UUID, UUID> pokemonToPlayerTarget = new LinkedHashMap();
    @NotNull
    private static final Map<UUID, Claim> targetedPlayers = new LinkedHashMap();
    @NotNull
    private static final Map<BlockPos, ExpiredTarget> recentlyExpiredTargets = new LinkedHashMap();
    @NotNull
    private static final PriorityQueue<ExpiredTarget> expiredQueue = new PriorityQueue(new Comparator(){

        public final int compare(T a, T b) {
            ExpiredTarget it = (ExpiredTarget)a;
            boolean bl = false;
            Comparable comparable = Long.valueOf(it.getExpiryTick());
            it = (ExpiredTarget)b;
            Comparable comparable2 = comparable;
            bl = false;
            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getExpiryTick()));
        }
    });
    @NotNull
    private static final Map<UUID, Long> lastPathfindTick = new LinkedHashMap();
    private static long lastCleanUpTick;
    private static final long CLAIM_TIMEOUT_TICKS = 140L;
    private static final long EXPIRED_TARGET_TIMEOUT_TICKS = 300L;
    private static final long PATHFIND_INTERVAL_TICKS = 20L;

    private CobbleworkersNavigationUtils() {
    }

    public final boolean isPokemonAtPosition(@NotNull PokemonEntity pokemonEntity, @NotNull BlockPos targetPos, double offset) {
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        Intrinsics.checkNotNullParameter((Object)targetPos, (String)"targetPos");
        AABB interactionHitbox = new AABB(targetPos).inflate(offset);
        return pokemonEntity.getBoundingBox().intersects(interactionHitbox);
    }

    public static /* synthetic */ boolean isPokemonAtPosition$default(CobbleworkersNavigationUtils cobbleworkersNavigationUtils, PokemonEntity pokemonEntity, BlockPos blockPos, double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = 1.0;
        }
        return cobbleworkersNavigationUtils.isPokemonAtPosition(pokemonEntity, blockPos, d);
    }

    public final boolean isPokemonNearPlayer(@NotNull PokemonEntity pokemonEntity, @NotNull Player player, double offset) {
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        AABB interactionHitbox = player.getBoundingBox().inflate(offset);
        return pokemonEntity.getBoundingBox().intersects(interactionHitbox);
    }

    public static /* synthetic */ boolean isPokemonNearPlayer$default(CobbleworkersNavigationUtils cobbleworkersNavigationUtils, PokemonEntity pokemonEntity, Player player, double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = 1.0;
        }
        return cobbleworkersNavigationUtils.isPokemonNearPlayer(pokemonEntity, player, d);
    }

    public final void navigateTo(@NotNull PokemonEntity pokemonEntity, @NotNull BlockPos targetPos, double speed) {
        long last;
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        Intrinsics.checkNotNullParameter((Object)targetPos, (String)"targetPos");
        Level world = pokemonEntity.level();
        long now = world.getGameTime();
        UUID id = pokemonEntity.getPokemon().getUuid();
        Long l = lastPathfindTick.get(id);
        long l2 = last = l != null ? l : 0L;
        if (now - last < 20L) {
            return;
        }
        Long l3 = now;
        lastPathfindTick.put(id, l3);
        pokemonEntity.getNavigation().moveTo((double)targetPos.getX() + 0.5, (double)targetPos.getY(), (double)targetPos.getZ() + 0.5, speed);
    }

    public static /* synthetic */ void navigateTo$default(CobbleworkersNavigationUtils cobbleworkersNavigationUtils, PokemonEntity pokemonEntity, BlockPos blockPos, double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = 1.0;
        }
        cobbleworkersNavigationUtils.navigateTo(pokemonEntity, blockPos, d);
    }

    public final void navigateToPlayer(@NotNull PokemonEntity pokemonEntity, @NotNull Player player, double speed) {
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        pokemonEntity.getNavigation().moveTo(player.getX(), player.getY(), player.getZ(), speed);
    }

    public static /* synthetic */ void navigateToPlayer$default(CobbleworkersNavigationUtils cobbleworkersNavigationUtils, PokemonEntity pokemonEntity, Player player, double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = 1.0;
        }
        cobbleworkersNavigationUtils.navigateToPlayer(pokemonEntity, player, d);
    }

    public final void claimTarget(@NotNull UUID pokemonId, @NotNull BlockPos target, @NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)pokemonId, (String)"pokemonId");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.releaseExpiredClaims(world);
        this.releaseTarget(pokemonId, world);
        BlockPos immutableTarget = target.immutable();
        pokemonToTarget.put(pokemonId, immutableTarget);
        targetedBlocks.put(immutableTarget, new Claim(pokemonId, world.getGameTime()));
    }

    public final void claimTarget(@NotNull UUID pokemonId, @NotNull Player player, @NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)pokemonId, (String)"pokemonId");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.releaseExpiredClaims(world);
        this.releasePlayerTarget(pokemonId);
        pokemonToPlayerTarget.put(pokemonId, player.getUUID());
        targetedPlayers.put(player.getUUID(), new Claim(pokemonId, world.getGameTime()));
    }

    public final void releaseTarget(@NotNull UUID pokemonId, @NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)pokemonId, (String)"pokemonId");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        BlockPos releasedTarget = pokemonToTarget.remove(pokemonId);
        if (releasedTarget != null) {
            targetedBlocks.remove(releasedTarget);
            ExpiredTarget expired = new ExpiredTarget(releasedTarget, world.getGameTime());
            recentlyExpiredTargets.put(releasedTarget, expired);
            expiredQueue.add(expired);
        }
    }

    public final void releasePlayerTarget(@NotNull UUID pokemonId) {
        Intrinsics.checkNotNullParameter((Object)pokemonId, (String)"pokemonId");
        UUID playerId = pokemonToPlayerTarget.remove(pokemonId);
        if (playerId != null) {
            targetedPlayers.remove(playerId);
        }
    }

    @Nullable
    public final BlockPos getTarget(@NotNull UUID pokemonId, @NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)pokemonId, (String)"pokemonId");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.releaseExpiredClaims(world);
        return pokemonToTarget.get(pokemonId);
    }

    @Nullable
    public final UUID getPlayerTarget(@NotNull UUID pokemonId, @NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)pokemonId, (String)"pokemonId");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.releaseExpiredClaims(world);
        return pokemonToPlayerTarget.get(pokemonId);
    }

    public final boolean isTargeted(@NotNull BlockPos pos, @NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.releaseExpiredClaims(world);
        return targetedBlocks.containsKey(pos);
    }

    public final boolean isPlayerTargeted(@NotNull Player player, @NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.releaseExpiredClaims(world);
        return targetedPlayers.containsKey(player.getUUID());
    }

    private final void releaseExpiredClaims(Level world) {
        Claim claim;
        long now = world.getGameTime();
        if (now - lastCleanUpTick < 20L) {
            return;
        }
        lastCleanUpTick = now;
        List expiredPokemon = new ArrayList();
        Iterable $this$forEach$iv = targetedBlocks.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            claim = (Claim)element$iv;
            boolean bl = false;
            if (now - claim.getClaimTick() <= 140L) continue;
            expiredPokemon.add(claim.getPokemonId());
        }
        $this$forEach$iv = targetedPlayers.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            claim = (Claim)element$iv;
            boolean bl = false;
            if (now - claim.getClaimTick() <= 140L) continue;
            expiredPokemon.add(claim.getPokemonId());
        }
        $this$forEach$iv = expiredPokemon;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID it = (UUID)element$iv;
            boolean bl = false;
            INSTANCE.releaseTarget(it, world);
            INSTANCE.releasePlayerTarget(it);
        }
        while (!((Collection)expiredQueue).isEmpty() && now - expiredQueue.peek().getExpiryTick() > 300L) {
            recentlyExpiredTargets.remove(expiredQueue.poll().getPos());
        }
    }

    public final boolean isRecentlyExpired(@NotNull BlockPos pos, @NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.releaseExpiredClaims(world);
        return recentlyExpiredTargets.containsKey(pos);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001a\u001a\u0004\b\u001b\u0010\u000b\u00a8\u0006\u001c"}, d2={"Laccieo/cobbleworkers/utilities/CobbleworkersNavigationUtils$Claim;", "", "Ljava/util/UUID;", "pokemonId", "", "claimTick", "<init>", "(Ljava/util/UUID;J)V", "component1", "()Ljava/util/UUID;", "component2", "()J", "copy", "(Ljava/util/UUID;J)Laccieo/cobbleworkers/utilities/CobbleworkersNavigationUtils$Claim;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/UUID;", "getPokemonId", "J", "getClaimTick", "cobbleworkers-common"})
    private static final class Claim {
        @NotNull
        private final UUID pokemonId;
        private final long claimTick;

        public Claim(@NotNull UUID pokemonId, long claimTick) {
            Intrinsics.checkNotNullParameter((Object)pokemonId, (String)"pokemonId");
            this.pokemonId = pokemonId;
            this.claimTick = claimTick;
        }

        @NotNull
        public final UUID getPokemonId() {
            return this.pokemonId;
        }

        public final long getClaimTick() {
            return this.claimTick;
        }

        @NotNull
        public final UUID component1() {
            return this.pokemonId;
        }

        public final long component2() {
            return this.claimTick;
        }

        @NotNull
        public final Claim copy(@NotNull UUID pokemonId, long claimTick) {
            Intrinsics.checkNotNullParameter((Object)pokemonId, (String)"pokemonId");
            return new Claim(pokemonId, claimTick);
        }

        public static /* synthetic */ Claim copy$default(Claim claim, UUID uUID, long l, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = claim.pokemonId;
            }
            if ((n & 2) != 0) {
                l = claim.claimTick;
            }
            return claim.copy(uUID, l);
        }

        @NotNull
        public String toString() {
            return "Claim(pokemonId=" + this.pokemonId + ", claimTick=" + this.claimTick + ")";
        }

        public int hashCode() {
            int result = this.pokemonId.hashCode();
            result = result * 31 + Long.hashCode(this.claimTick);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Claim)) {
                return false;
            }
            Claim claim = (Claim)other;
            if (!Intrinsics.areEqual((Object)this.pokemonId, (Object)claim.pokemonId)) {
                return false;
            }
            return this.claimTick == claim.claimTick;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001a\u001a\u0004\b\u001b\u0010\u000b\u00a8\u0006\u001c"}, d2={"Laccieo/cobbleworkers/utilities/CobbleworkersNavigationUtils$ExpiredTarget;", "", "Lnet/minecraft/core/BlockPos;", "pos", "", "expiryTick", "<init>", "(Lnet/minecraft/core/BlockPos;J)V", "component1", "()Lnet/minecraft/core/BlockPos;", "component2", "()J", "copy", "(Lnet/minecraft/core/BlockPos;J)Laccieo/cobbleworkers/utilities/CobbleworkersNavigationUtils$ExpiredTarget;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/core/BlockPos;", "getPos", "J", "getExpiryTick", "cobbleworkers-common"})
    private static final class ExpiredTarget {
        @NotNull
        private final BlockPos pos;
        private final long expiryTick;

        public ExpiredTarget(@NotNull BlockPos pos, long expiryTick) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            this.pos = pos;
            this.expiryTick = expiryTick;
        }

        @NotNull
        public final BlockPos getPos() {
            return this.pos;
        }

        public final long getExpiryTick() {
            return this.expiryTick;
        }

        @NotNull
        public final BlockPos component1() {
            return this.pos;
        }

        public final long component2() {
            return this.expiryTick;
        }

        @NotNull
        public final ExpiredTarget copy(@NotNull BlockPos pos, long expiryTick) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            return new ExpiredTarget(pos, expiryTick);
        }

        public static /* synthetic */ ExpiredTarget copy$default(ExpiredTarget expiredTarget, BlockPos blockPos, long l, int n, Object object) {
            if ((n & 1) != 0) {
                blockPos = expiredTarget.pos;
            }
            if ((n & 2) != 0) {
                l = expiredTarget.expiryTick;
            }
            return expiredTarget.copy(blockPos, l);
        }

        @NotNull
        public String toString() {
            return "ExpiredTarget(pos=" + this.pos + ", expiryTick=" + this.expiryTick + ")";
        }

        public int hashCode() {
            int result = this.pos.hashCode();
            result = result * 31 + Long.hashCode(this.expiryTick);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExpiredTarget)) {
                return false;
            }
            ExpiredTarget expiredTarget = (ExpiredTarget)other;
            if (!Intrinsics.areEqual((Object)this.pos, (Object)expiredTarget.pos)) {
                return false;
            }
            return this.expiryTick == expiredTarget.expiryTick;
        }
    }
}

